/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarionetteHeartItem
extends Item {
    protected static final UUID ATTACK_UUID = UUID.fromString("dfff1a4a-93a1-11ee-b9d1-0242ac120002");

    public MarionetteHeartItem() {
        super(new Item.Properties().m_41491_(TensuraCreativeTab.MISCELLANEOUS).m_41497_(TensuraRarity.UNIQUE).m_41487_(1));
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.marionette_heart").m_130940_(ChatFormatting.RED));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot pEquipmentSlot, ItemStack stack) {
        if (pEquipmentSlot != EquipmentSlot.MAINHAND) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.builder().put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ATTACK_UUID, "Marionette Heart Modifier", -0.99, AttributeModifier.Operation.MULTIPLY_TOTAL)).build();
    }

    public boolean m_5812_(ItemStack pStack) {
        return true;
    }

    public int m_8105_(ItemStack pStack) {
        return 10000;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BOW;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand pHand) {
        ItemStack stack = player.m_21120_(pHand);
        if (player.m_36335_().m_41519_(stack.m_41720_()) && !player.m_150110_().f_35937_) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        player.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)pLivingEntity, (ParticleOptions)ParticleTypes.f_123808_);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level level, @NotNull LivingEntity entity, int pTimeLeft) {
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 10) {
            return;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150110_().f_35937_) {
                player.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, player.m_21233_() / 2.0f);
                player.m_36335_().m_41524_(pStack.m_41720_(), 2400);
                pStack.m_41774_(1);
            }
            TensuraEPCapability.setMajin((LivingEntity)player, true);
            TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                SkillHelper.outOfMagiculeStillConsume((LivingEntity)player, cap.getMagicule() - 200.0);
                TensuraPlayerCapability.sync(player);
            });
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)ParticleTypes.f_123812_, 0.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)entity, (ParticleOptions)TensuraParticles.SOLAR_FLASH.get(), 1.0);
        }
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity target, LivingEntity pAttacker) {
        if (target.m_6084_() && SkillHelper.isSubordinate(pAttacker, target)) {
            target.f_19802_ = 0;
            target.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, target.m_21233_() / 2.0f);
            if (pAttacker instanceof Player) {
                Player player = (Player)pAttacker;
                if (!player.m_150110_().f_35937_) {
                    player.m_36335_().m_41524_(pStack.m_41720_(), 2400);
                    pStack.m_41774_(1);
                }
            }
            TensuraEPCapability.setMajin(target, true);
            pAttacker.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123767_, 0.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.SOLAR_FLASH.get(), 1.0);
            return true;
        }
        return super.m_7579_(pStack, target, pAttacker);
    }
}

