/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.custom;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.TensuraClient;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.IceLanceProjectile;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.templates.custom.TwoHandedLongSword;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IceBladeItem
extends TwoHandedLongSword {
    public IceBladeItem() {
        super(TensuraToolTiers.HIGH_MAGISTEEL, 4, -2.6f, 1.0, 0.0, 0.0, 3, -2.8f, 100.0, 100.0, new Item.Properties().m_41491_(TensuraCreativeTab.GEAR).m_41486_().m_41497_(TensuraRarity.UNIQUE));
    }

    @Override
    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> TensuraClient::shiftDown, () -> () -> false)).booleanValue()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.iceblade.tooltip.shift").m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.press.shift").m_130940_(ChatFormatting.GRAY));
        }
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.tensura.long_sword.tooltip"));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.equals(Enchantments.f_44959_)) {
            return true;
        }
        return enchantment.f_44672_.m_7454_(stack.m_41720_());
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        boolean hurt = super.m_7579_(pStack, pTarget, pAttacker);
        if (!hurt) {
            return false;
        }
        SkillHelper.checkThenAddEffectSource(pTarget, (Entity)pAttacker, (MobEffect)TensuraMobEffects.CHILL.get(), 100, 1, true, true, true);
        pTarget.m_5496_(SoundEvents.f_144205_, 1.0f, 1.0f);
        if (pTarget.m_146888_() < 350) {
            pTarget.m_146917_(400);
        } else {
            pTarget.m_146917_(pTarget.m_146888_() + 50);
        }
        if (pTarget.m_6060_()) {
            pTarget.m_20095_();
        }
        return true;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity entity, int pTimeLeft) {
        int multiShot;
        double cost;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        int useTicks = this.m_8105_(pStack) - pTimeLeft;
        if (useTicks < 7) {
            return;
        }
        CompoundTag tag = pStack.m_41784_();
        double EP = tag.m_128459_("DurabilityEP");
        if (EP < (cost = (double)(100 * (1 + (multiShot = pStack.getEnchantmentLevel(Enchantments.f_44959_)) * 2)))) {
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_12318_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        if (!pLevel.f_46443_) {
            boolean left = player.m_7655_() == InteractionHand.OFF_HAND && player.m_5737_() == HumanoidArm.RIGHT || player.m_7655_() == InteractionHand.MAIN_HAND && player.m_5737_() == HumanoidArm.LEFT;
            this.icicle(pLevel, player, !left, 0, false);
            for (int i = 0; i < multiShot; ++i) {
                this.icicle(pLevel, player, !left, i + 1, false);
                this.icicle(pLevel, player, !left, i + 1, true);
            }
            pLevel.m_6269_(null, (Entity)player, SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                tag.m_128347_("DurabilityEP", EP - cost);
            }
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        player.m_21011_(player.m_7655_(), true);
    }

    public void icicle(Level pLevel, Player player, boolean right, int multiShot, boolean negativeAngle) {
        IceLanceProjectile icicle = new IceLanceProjectile(pLevel, (LivingEntity)player);
        icicle.setPosDirection((LivingEntity)player, right ? TensuraProjectile.PositionDirection.RIGHT : TensuraProjectile.PositionDirection.LEFT);
        icicle.setDamage(DamageSourceHelper.getWeaponDamage((LivingEntity)player, null, player.m_7655_() == InteractionHand.OFF_HAND));
        icicle.setMpCost(100.0);
        icicle.setBurnTicks(-1);
        icicle.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.CHILL.get(), 200, 2, false, false, true));
        Vector3f vector3f = new Vector3f(player.m_20252_(1.0f));
        if (multiShot > 0) {
            vector3f.m_122251_(new Quaternion(new Vector3f(player.m_20289_(1.0f)), negativeAngle ? -10.0f * (float)multiShot : 10.0f * (float)multiShot, true));
        }
        icicle.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.2f, 0.0f);
        pLevel.m_7967_((Entity)icicle);
    }
}

