/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.item.armor;

import com.github.manasmods.tensura.entity.DragonPeacockEntity;
import com.github.manasmods.tensura.item.TensuraArmourMaterials;
import com.github.manasmods.tensura.item.TensuraCreativeTab;
import com.github.manasmods.tensura.util.TensuraRarity;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;

public class WingedShoesItem
extends ArmorItem
implements DyeableLeatherItem {
    private int sprintTicks = 0;
    protected static final UUID WINGED_SPEED_UUID = UUID.fromString("43ab748c-e810-11ed-a05b-0242ac120003");
    protected static final UUID WINGED_STEP_UUID = UUID.fromString("43ab78d8-e810-11ed-a05b-0242ac120003");

    public WingedShoesItem() {
        super((ArmorMaterial)TensuraArmourMaterials.WINGED_SHOES, EquipmentSlot.FEET, new Item.Properties().m_41491_(TensuraCreativeTab.ARMOUR).m_41497_(TensuraRarity.UNIQUE));
    }

    public boolean canWalkOnPowderedSnow(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != EquipmentSlot.FEET) {
            return ImmutableMultimap.of();
        }
        return ImmutableMultimap.builder().put((Object)Attributes.f_22279_, (Object)new AttributeModifier(WINGED_SPEED_UUID, "Winged Modifier", 0.1, AttributeModifier.Operation.ADDITION)).put((Object)((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get()), (Object)new AttributeModifier(WINGED_STEP_UUID, "Winged Modifier", 1.0, AttributeModifier.Operation.ADDITION)).build();
    }

    public void onArmorTick(ItemStack pStack, Level pLevel, Player player) {
        if (!player.m_20096_()) {
            Vec3 vec3 = player.m_20184_();
            if (player.m_146895_() instanceof DragonPeacockEntity) {
                if (player.f_20899_ && !player.m_36335_().m_41519_(pStack.m_41720_())) {
                    player.m_36335_().m_41524_(pStack.m_41720_(), 10);
                    player.m_20256_(vec3.m_82520_(0.0, 1.0, 0.0));
                    pLevel.m_5594_(player, player.m_20183_(), SoundEvents.f_12230_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (vec3.f_82480_ < 0.0) {
                    player.m_20256_(vec3.m_82542_(1.0, 0.9, 1.0));
                }
            } else if (vec3.f_82480_ < 0.0) {
                player.m_20256_(vec3.m_82542_(1.0, 0.8, 1.0));
            }
            player.m_183634_();
        }
        if (player.m_20142_()) {
            Vec3 velocityBoost = new Vec3(Math.sin(Math.toRadians(player.m_6080_() + 180.0f)), Math.sin(Math.toRadians(0.0f - player.m_6080_())), Math.cos(Math.toRadians(player.m_6080_())));
            BlockPos belowPos = player.m_20183_().m_7495_();
            if (player.m_21255_() && pLevel.m_8055_(belowPos).m_60783_((BlockGetter)pLevel, belowPos, Direction.UP)) {
                player.m_20256_(velocityBoost.m_82542_(1.5, 1.0, 1.5));
                pStack.m_41622_(3, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.FEET));
            } else if (player.m_20096_()) {
                player.m_20256_(velocityBoost.m_82542_(1.0, 0.0, 1.0));
                ++this.sprintTicks;
                if (this.sprintTicks >= 10) {
                    this.sprintTicks = 0;
                    pStack.m_41622_(1, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.FEET));
                }
            }
        }
    }

    public int m_41121_(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41737_("display");
        return compoundtag != null && compoundtag.m_128425_("color", 99) ? compoundtag.m_128451_("color") : 0xFFFFFF;
    }
}

