/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler.client;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.effect.FearEffect;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientTickHandler {
    private static final float PARTICLE_SIZE = 0.2f;

    @SubscribeEvent
    public static void clientTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            return;
        }
        if (e.side.isServer()) {
            return;
        }
        Player player = e.player;
        if (player.m_5833_()) {
            return;
        }
        FearEffect.onClientTick(player, 10.0f);
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent e) {
        LivingEntity entity = e.getEntity();
        if (!entity.f_19853_.f_46443_) {
            return;
        }
        if (SkillUtils.isSkillToggled((Entity)entity, (ManasSkill)ExtraSkills.BLACK_FLAME.get())) {
            Vec3 right = ClientTickHandler.getArmPosition(entity, HumanoidArm.RIGHT).m_82520_(0.0, (double)0.1f, 0.0);
            Vec3 left = ClientTickHandler.getArmPosition(entity, HumanoidArm.LEFT).m_82520_(0.0, (double)0.1f, 0.0);
            ClientTickHandler.spawnParticle(entity.f_19853_, left, (ParticleOptions)TensuraParticles.BLACK_FIRE.get());
            ClientTickHandler.spawnParticle(entity.f_19853_, right, (ParticleOptions)TensuraParticles.BLACK_FIRE.get());
        }
    }

    public static void spawnParticle(Level level, Vec3 pos, ParticleOptions options) {
        int count = Math.round(2.0f);
        for (int i = 0; i < count; ++i) {
            double theta = RandomSource.m_216327_().m_188500_() * Math.PI * 2.0;
            double phi = RandomSource.m_216327_().m_188500_() * Math.PI;
            Vec3 direction = new Vec3(Math.sin(phi) * Math.cos(theta), Math.sin(phi) * Math.sin(theta), Math.cos(phi));
            Vec3 start = pos.m_82549_(direction.m_82490_((double)0.2f));
            level.m_6493_(options, true, start.f_82479_, start.f_82480_, start.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public static Vec3 getArmPosition(LivingEntity entity, HumanoidArm arm) {
        LivingEntityRenderer living;
        EntityModel entityModel;
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = mc.m_91290_();
        EntityRenderer renderer = dispatcher.m_114382_((Entity)entity);
        if (renderer instanceof LivingEntityRenderer && (entityModel = (living = (LivingEntityRenderer)renderer).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel humanoid = (HumanoidModel)entityModel;
            return switch (arm) {
                default -> throw new IncompatibleClassChangeError();
                case HumanoidArm.RIGHT -> ClientTickHandler.transform3rdPerson(new Vec3(0.0, -0.7, 0.0), new Vec3((double)humanoid.f_102811_.f_104203_, (double)humanoid.f_102811_.f_104204_, (double)humanoid.f_102811_.f_104205_), entity, HumanoidArm.RIGHT, mc.getPartialTick());
                case HumanoidArm.LEFT -> ClientTickHandler.transform3rdPerson(new Vec3(0.0, -0.7, 0.0), new Vec3((double)humanoid.f_102812_.f_104203_, (double)humanoid.f_102812_.f_104204_, (double)humanoid.f_102812_.f_104205_), entity, HumanoidArm.LEFT, mc.getPartialTick());
            };
        }
        return Vec3.f_82478_;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Vec3 transform3rdPerson(Vec3 pos, Vec3 angles, LivingEntity entity, HumanoidArm arm, float partialTicks) {
        float f;
        double d;
        Vec3 vec3;
        block2: {
            block3: {
                vec3 = ClientTickHandler.rotateRoll(pos, (float)(-angles.f_82481_)).m_82496_((float)(-angles.f_82479_)).m_82524_((float)(-angles.f_82480_));
                d = 0.0586f * (arm == HumanoidArm.RIGHT ? -6.0f : 6.0f);
                if (!entity.m_6144_()) break block2;
                if (!(entity instanceof Player)) break block3;
                Player player = (Player)entity;
                if (player.m_150110_().f_35935_) break block2;
            }
            f = 0.3f;
            return vec3.m_82520_(d, (double)(1.3f - f), (double)-0.05f).m_82524_(-Mth.m_14179_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_) * ((float)Math.PI / 180)).m_82520_(Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_()));
        }
        f = 0.0f;
        return vec3.m_82520_(d, (double)(1.3f - f), (double)-0.05f).m_82524_(-Mth.m_14179_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_) * ((float)Math.PI / 180)).m_82520_(Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_()), Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_()));
    }

    private static Vec3 rotateRoll(Vec3 pos, float roll) {
        float f = Mth.m_14089_((float)roll);
        float f1 = Mth.m_14031_((float)roll);
        double d0 = pos.f_82479_ * (double)f - pos.f_82480_ * (double)f1;
        double d1 = pos.f_82480_ * (double)f + pos.f_82479_ * (double)f1;
        double d2 = pos.f_82481_;
        return new Vec3(d0, d1, d2);
    }
}

