/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.manascore.api.skills.event.SkillDamageEvent;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.skill.unique.GuardianSkill;
import com.github.manasmods.tensura.capability.effects.ITensuraEffectsCapability;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.ITensuraEPCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.effect.skill.PresenceSenseEffect;
import com.github.manasmods.tensura.effect.template.Concealment;
import com.github.manasmods.tensura.effect.template.DamageAction;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.entity.template.TensuraHorseEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.event.ForcedTeleportationEvent;
import com.github.manasmods.tensura.handler.CapabilityHandler;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class StatusEffectsHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyEffectPreBarrier(SkillDamageEvent.PreCalculation e) {
        Object effect;
        MobEffect mobEffect;
        LivingEntity target = e.getEntity();
        if (SkillUtils.noInteractiveMode(target)) {
            return;
        }
        if (GuardianSkill.onSubordinateHurt(e.getEvent())) {
            return;
        }
        StatusEffectsHandler.magicInterference(e.getEvent(), target);
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)entity;
            for (MobEffectInstance instance : List.copyOf(source.m_21220_())) {
                mobEffect = instance.m_19544_();
                if (!(mobEffect instanceof DamageAction)) continue;
                effect = (DamageAction)mobEffect;
                effect.onDamagingEntity(source, e.getEvent());
            }
        }
        for (MobEffectInstance instance : List.copyOf(target.m_21220_())) {
            effect = instance.m_19544_();
            if (!(effect instanceof DamageAction)) continue;
            DamageAction effect2 = (DamageAction)effect;
            effect2.onBeingDamaged(e.getEvent());
            mobEffect = e.getSource().m_7639_();
            if (!(mobEffect instanceof LivingEntity)) continue;
            LivingEntity source = (LivingEntity)mobEffect;
            effect2.onDamagingEntity(source, e.getEvent());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onTakingDamage(LivingDamageEvent e) {
        LivingEntity target = e.getEntity();
        if (SkillUtils.noInteractiveMode(target)) {
            return;
        }
        EquipmentSlot[] equipmentSlotArray = e.getSource().m_7639_();
        if (equipmentSlotArray instanceof LivingEntity) {
            LivingEntity source = (LivingEntity)equipmentSlotArray;
            equipmentSlotArray = EquipmentSlot.values();
            int n = equipmentSlotArray.length;
            for (int i = 0; i < n; ++i) {
                EquipmentSlot slot = equipmentSlotArray[i];
                Map enchantments = source.m_6844_(slot).getAllEnchantments();
                for (Enchantment enchantment : enchantments.keySet()) {
                    if (!(enchantment instanceof EngravingEnchantment)) continue;
                    EngravingEnchantment engrave = (EngravingEnchantment)enchantment;
                    e.setAmount(e.getAmount() + engrave.getDamageBonus((Integer)enchantments.get(enchantment), e.getSource(), source, target, slot, e.getAmount()));
                }
            }
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            Map enchantments = target.m_6844_(slot).getAllEnchantments();
            for (Enchantment enchantment : enchantments.keySet()) {
                if (!(enchantment instanceof EngravingEnchantment)) continue;
                EngravingEnchantment engrave = (EngravingEnchantment)enchantment;
                e.setAmount(e.getAmount() - engrave.getDamageProtection((Integer)enchantments.get(enchantment), e.getSource(), target, slot, e.getAmount()));
            }
        }
        if (SkillUtils.haveSeveranceAttack(e.getSource(), target)) {
            TensuraEffectsCapability.getFrom(target).ifPresent(cap -> {
                int removeSec = (Integer)TensuraConfig.INSTANCE.skillsConfig.severanceRemoveSec.get();
                if (removeSec == 0) {
                    return;
                }
                cap.setSeveranceRemoveSec(removeSec);
                cap.setSeveranceAmount(cap.getSeveranceAmount() + (double)e.getAmount());
                TensuraEffectsCapability.sync(target);
            });
        }
    }

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent e) {
        if (!(e instanceof MobEffectEvent.Added)) {
            return;
        }
        LivingEntity entity = e.getEntity();
        MobEffectInstance instance = e.getEffectInstance();
        ResourceLocation resourceLocation = Registry.f_122823_.m_7981_((Object)instance.m_19544_());
        if (resourceLocation == null) {
            return;
        }
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> cap.addSyncedEffect(resourceLocation, entity));
    }

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent e) {
        if (e instanceof MobEffectEvent.Added || e instanceof MobEffectEvent.Applicable) {
            return;
        }
        MobEffectInstance instance = e.getEffectInstance();
        if (instance == null) {
            return;
        }
        LivingEntity entity = e.getEntity();
        MobEffect effect = instance.m_19544_();
        ResourceLocation resourceLocation = Registry.f_122823_.m_7981_((Object)effect);
        if (resourceLocation == null) {
            return;
        }
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            cap.removeSyncedEffect(resourceLocation, entity);
            cap.removeEffectSource(resourceLocation);
        });
        if (effect instanceof Concealment) {
            TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> cap.setPresenceConceal(0));
            TensuraEffectsCapability.sync(entity);
        } else if (effect instanceof PresenceSenseEffect) {
            TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> cap.setPresenceSense(0));
            TensuraEffectsCapability.sync(entity);
        } else if (effect == TensuraMobEffects.MIND_CONTROL.get()) {
            Player effectSource = TensuraEffectsCapability.getEffectSource(entity, effect);
            TensuraEPCapability.getFrom(entity).ifPresent(arg_0 -> StatusEffectsHandler.lambda$onEffectRemoved$5((LivingEntity)effectSource, entity, arg_0));
            TensuraEffectsCapability.sync(entity);
        }
    }

    @SubscribeEvent
    public static void onKnockBack(LivingKnockBackEvent e) {
        LivingEntity entity = e.getEntity();
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            if (cap.isNoKnockBack()) {
                cap.setNoKnockBack(false);
                e.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public static void onTeleport(EntityTeleportEvent e) {
        if (e instanceof EntityTeleportEvent.TeleportCommand || e instanceof EntityTeleportEvent.SpreadPlayersCommand) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!MobEffectHelper.noTeleportation(living)) {
            return;
        }
        if (!(e instanceof ForcedTeleportationEvent) && living instanceof Player) {
            Player player = (Player)living;
            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
        }
        e.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onChangingDimension(EntityTravelToDimensionEvent e) {
        Entity entity = e.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (!MobEffectHelper.noDimensionChanging(living)) {
            return;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            player.m_5661_((Component)Component.m_237115_((String)"tensura.skill.spatial_blockade").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
        }
        e.setCanceled(true);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        TensuraEffectsCapability.getFrom((LivingEntity)e.getEntity()).ifPresent(cap -> {
            cap.setWarpPortalTime(0);
            cap.setNoKnockBack(false);
            cap.setPresenceConceal(0);
            cap.setPresenceSense(0);
        });
        TensuraEffectsCapability.sync((LivingEntity)e.getEntity());
    }

    @SubscribeEvent
    public static void onHeal(LivingHealEvent e) {
        ITensuraEffectsCapability effectsCapability;
        LivingEntity entity = e.getEntity();
        if (Float.isNaN(e.getAmount())) {
            e.setCanceled(true);
            return;
        }
        if (Float.isNaN(entity.m_21223_()) || entity.m_21223_() < 0.0f) {
            entity.revive();
            entity.m_21153_(0.0f);
            e.setCanceled(true);
            if (!(entity instanceof Player)) {
                entity.m_146870_();
            }
            return;
        }
        if (MobEffectHelper.shouldCancelHeal(entity)) {
            e.setCanceled(Boolean.TRUE.booleanValue());
        }
        if ((effectsCapability = CapabilityHandler.getCapability((Entity)entity, TensuraEffectsCapability.CAPABILITY)) != null && effectsCapability.getSeveranceAmount() > 0.0) {
            float severedHealth = (float)((double)entity.m_21233_() - effectsCapability.getSeveranceAmount());
            if (entity.m_21223_() == severedHealth) {
                e.setCanceled(Boolean.TRUE.booleanValue());
            } else if (entity.m_21223_() + e.getAmount() > severedHealth) {
                if (entity.m_21223_() > severedHealth) {
                    entity.m_6469_(TensuraDamageSources.SEVERANCE_UPDATE, entity.m_21223_() - severedHealth);
                    e.setCanceled(Boolean.TRUE.booleanValue());
                } else {
                    e.setAmount(severedHealth - entity.m_21223_());
                }
            }
        }
        if (e.isCanceled()) {
            return;
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (!cap.isHeroEgg()) {
                return;
            }
            if (RaceHelper.shouldNamingStopAwakening(player)) {
                return;
            }
            if (cap.isTrueHero()) {
                return;
            }
            if (cap.isTrueDemonLord()) {
                return;
            }
            if (player.m_21223_() >= player.m_21233_() / 4.0f) {
                return;
            }
            if (RaceHelper.fightingBossForHero(player)) {
                cap.setTrueHero(true);
                RaceHelper.awakening(player, true);
            }
        });
    }

    private static void magicInterference(LivingHurtEvent e, LivingEntity target) {
        float magicInterfere = 0.0f;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            int level;
            if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND) || (level = target.m_6844_(slot).getEnchantmentLevel((Enchantment)TensuraEnchantments.MAGIC_INTERFERENCE.get())) <= 0) continue;
            magicInterfere = (float)((double)magicInterfere + 0.25 * (double)level);
        }
        if (target.m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK) && target.m_21211_().getEnchantmentLevel((Enchantment)TensuraEnchantments.MAGIC_INTERFERENCE.get()) > 0) {
            magicInterfere = 1.0f;
        }
        DamageSource source = e.getSource();
        if (magicInterfere > 0.0f) {
            LivingEntity living;
            if (source.m_19378_()) {
                return;
            }
            if (!DamageSourceHelper.isTensuraMagic(source)) {
                return;
            }
            Entity entity = e.getSource().m_7639_();
            if (entity instanceof LivingEntity && SkillHelper.getMP(living = (LivingEntity)entity, false) >= SkillHelper.getMP(target, false) * 1.5) {
                return;
            }
            e.setAmount(e.getAmount() * (1.0f - magicInterfere));
        }
    }

    private static /* synthetic */ void lambda$onEffectRemoved$5(LivingEntity effectSource, LivingEntity entity, ITensuraEPCapability cap) {
        if (effectSource == null || Objects.equals(cap.getTemporaryOwner(), effectSource.m_20148_())) {
            cap.setTemporaryOwner(null);
            UUID owner = cap.getPermanentOwner();
            if (entity instanceof TensuraTamableEntity) {
                TensuraTamableEntity tamable = (TensuraTamableEntity)entity;
                tamable.resetOwner(owner);
            } else if (entity instanceof TensuraHorseEntity) {
                TensuraHorseEntity horse = (TensuraHorseEntity)entity;
                horse.resetOwner(owner);
            } else if (entity instanceof TamableAnimal) {
                TamableAnimal animal = (TamableAnimal)entity;
                animal.m_21816_(owner);
                if (owner == null) {
                    animal.m_7105_(false);
                }
            }
        }
        if (effectSource != null) {
            cap.removeNeutralTarget(effectSource.m_20148_());
        }
    }
}

