/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.manascore.api.attribute.event.CriticalChanceEvent;
import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.manascore.api.skills.capability.SkillStorage;
import com.github.manasmods.manascore.api.skills.event.RemoveSkillEvent;
import com.github.manasmods.manascore.api.skills.event.SkillActivationEvent;
import com.github.manasmods.manascore.api.skills.event.SkillCooldownUpdateEvent;
import com.github.manasmods.manascore.api.skills.event.SkillDamageEvent;
import com.github.manasmods.manascore.api.skills.event.SkillReleaseEvent;
import com.github.manasmods.manascore.api.skills.event.SkillScrollEvent;
import com.github.manasmods.manascore.api.skills.event.UnlockSkillEvent;
import com.github.manasmods.tensura.ability.ISpatialStorage;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkill;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.skill.extra.FlameManipulationSkill;
import com.github.manasmods.tensura.ability.skill.extra.LightningManipulationSkill;
import com.github.manasmods.tensura.ability.skill.resist.ResistSkill;
import com.github.manasmods.tensura.ability.skill.unique.TunerSkill;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.api.entity.subclass.ISummonable;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.effect.skill.InstantRegenerationEffect;
import com.github.manasmods.tensura.effect.template.DamageAction;
import com.github.manasmods.tensura.effect.template.MobEffectHelper;
import com.github.manasmods.tensura.effect.template.SkillMobEffect;
import com.github.manasmods.tensura.entity.ElementalColossusEntity;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.entity.human.IOtherworlder;
import com.github.manasmods.tensura.entity.magic.barrier.RangedBarrierEntity;
import com.github.manasmods.tensura.entity.magic.misc.WarpPortalEntity;
import com.github.manasmods.tensura.handler.LabyrinthHandler;
import com.github.manasmods.tensura.item.custom.VortexSpearItem;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestClientSkillRemovePacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.race.human.HumanRace;
import com.github.manasmods.tensura.registry.TensuraStats;
import com.github.manasmods.tensura.registry.attribute.TensuraAttributeRegistry;
import com.github.manasmods.tensura.registry.dimensions.LabyrinthTeleporter;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.event.TensuraGameEvents;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.util.damage.TensuraEntityDamageSource;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatType;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingUseTotemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkillHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onSkillLearnt(UnlockSkillEvent e) {
        ManasSkillInstance instance = e.getSkillInstance();
        if (instance.getMastery() < 0) {
            return;
        }
        Entity pEntity = e.getEntity();
        if (!(pEntity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity = (LivingEntity)pEntity;
        if (!instance.isTemporarySkill()) {
            ManasSkill manasSkill;
            Player player;
            CompoundTag tag = instance.getTag();
            if (tag != null && tag.m_128471_("NoMagiculeCost")) {
                tag.m_128473_("NoMagiculeCost");
                if (tag.m_128456_()) {
                    instance.setTag(null);
                }
            } else if (pEntity instanceof Player && !(player = (Player)pEntity).m_7500_() && (manasSkill = instance.getSkill()) instanceof TensuraSkill) {
                TensuraSkill skill = (TensuraSkill)manasSkill;
                TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
                    if (cap.getRace() == null || !cap.getRace().isIntrinsicSkill(player, skill)) {
                        double cost = skill.getObtainingEpCost() * (double)player.f_19853_.m_46469_().m_46215_(TensuraGameRules.MP_SKILL_COST) / 100.0;
                        if (cap.getBaseMagicule() <= cost) {
                            player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.acquire_failed.mp", (Object[])new Object[]{skill.getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                            e.setCanceled(true);
                        } else {
                            cap.setBaseMagicule(cap.getBaseMagicule() - cost, (LivingEntity)player);
                            cap.setMagicule(cap.getMagicule() - cost);
                            TensuraPlayerCapability.sync(player);
                        }
                    }
                });
            }
        } else {
            SkillStorage storage = SkillAPI.getSkillsFrom((Entity)pEntity);
            Optional optionalCreator = storage.getSkill((ManasSkill)UniqueSkills.CREATOR.get());
            if (optionalCreator.isEmpty()) {
                return;
            }
            if (instance.getTag() == null || !instance.getTag().m_128441_("CreatorSkill")) {
                return;
            }
            if (!instance.getTag().m_128471_("CreatorSkill")) {
                return;
            }
            ResourceLocation location = new ResourceLocation(((ManasSkillInstance)optionalCreator.get()).getOrCreateTag().m_128461_("created_skill"));
            if (instance.getSkill() == SkillAPI.getSkillRegistry().getValue(location)) {
                return;
            }
            e.setCanceled(true);
        }
        if (e.isCanceled()) {
            return;
        }
        FlameManipulationSkill.learnFlameManipulation(instance, entity);
        LightningManipulationSkill.learnLightningManipulation(instance, entity);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSkillRemove(RemoveSkillEvent e) {
        ManasSkillInstance instance = e.getSkillInstance();
        if (e.getEntity().f_19853_.m_5776_()) {
            return;
        }
        Entity entity = e.getEntity();
        if (entity instanceof ServerPlayer) {
            ManasSkill manasSkill;
            ServerPlayer player = (ServerPlayer)entity;
            instance.onToggleOff((LivingEntity)player);
            if (instance.shouldRemove()) {
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.temporary.remove", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), false);
                if (instance.getTag() != null && instance.getTag().m_128451_("OldRemoval") == -1 && instance.getTag().m_128441_("OldMastery")) {
                    instance.setRemoveTime(-1);
                    instance.setMastery(instance.getTag().m_128451_("OldMastery"));
                    if (instance.getMastery() < 0) {
                        instance.setToggled(false);
                    }
                    instance.getTag().m_128473_("OldMastery");
                    e.setCanceled(true);
                    return;
                }
            } else {
                ResistSkill resist;
                manasSkill = instance.getSkill();
                if (manasSkill instanceof ResistSkill && (resist = (ResistSkill)manasSkill).getResistType() == ResistSkill.ResistType.RESISTANCE && resist.pointRequirement() != -1) {
                    instance.setMastery(resist.pointRequirement() * -1);
                    instance.setRemoveTime(-1);
                    instance.setToggled(false);
                    e.setCanceled(true);
                    return;
                }
            }
            TensuraSkillCapability.removeSkillFromSlots((Player)player, instance.getSkill());
            manasSkill = instance.getSkill();
            if (manasSkill instanceof ISpatialStorage) {
                ISpatialStorage storage = (ISpatialStorage)manasSkill;
                storage.dropAllItems(instance, (Player)player);
            }
            TensuraNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new RequestClientSkillRemovePacket(SkillUtils.getSkillId(instance.getSkill()), player.m_19879_()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void skillCooldown(SkillCooldownUpdateEvent e) {
        ManasSkillInstance instance = e.getSkillInstance();
        if (e.getCurrentCooldown() != 1) {
            return;
        }
        if (!instance.getSkill().equals(UniqueSkills.TUNER.get())) {
            return;
        }
        TunerSkill.clearDeathTypes(instance, e.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void skillActivation(SkillActivationEvent e) {
        ManasSkillInstance instance;
        Player player = e.getEntity();
        if (!TensuraSkillCapability.isSkillInSlot((LivingEntity)player, (instance = e.getSkillInstance()).getSkill(), e.getKeyNumber())) {
            e.setCanceled(true);
        } else {
            TensuraSkill skill;
            ManasSkill manasSkill = instance.getSkill();
            if (instance.onCoolDown() && !instance.canIgnoreCoolDown((LivingEntity)player)) {
                player.m_5661_((Component)Component.m_237110_((String)"tensura.skill.cooldown", (Object[])new Object[]{instance.getSkill().getName()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)), true);
                return;
            }
            if (instance.getMastery() < 0 && manasSkill instanceof TensuraSkill && (skill = (TensuraSkill)manasSkill).canLearnSkill(instance, (LivingEntity)player)) {
                skill.addLearnPoint(instance, (LivingEntity)player);
                if (SkillHandler.fail(player, instance.getMastery()) && SkillUtils.learningFailPenalty((LivingEntity)player) && instance.getMastery() < 0) {
                    instance.setMastery(Math.max(instance.getMastery() - player.m_217043_().m_216339_(1, 3), -100));
                }
                e.setCanceled(true);
            }
        }
    }

    private static boolean fail(Player player, int mastery) {
        if (mastery <= -80) {
            return (double)player.m_217043_().m_188501_() >= 0.05;
        }
        if (mastery <= -60) {
            return (double)player.m_217043_().m_188501_() >= 0.1;
        }
        if (mastery <= -40) {
            return (double)player.m_217043_().m_188501_() >= 0.2;
        }
        if (mastery <= -20) {
            return (double)player.m_217043_().m_188501_() >= 0.3;
        }
        return (double)player.m_217043_().m_188501_() >= 0.4;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void skillRelease(SkillReleaseEvent e) {
        ManasSkillInstance instance;
        Player player = e.getEntity();
        if (!TensuraSkillCapability.isSkillInSlot((LivingEntity)player, (instance = e.getSkillInstance()).getSkill(), e.getKeyNumber())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void skillScroll(SkillScrollEvent e) {
        Player player = e.getEntity();
        ManasSkillInstance instance = e.getSkillInstance();
        if (TensuraKeybinds.ACTIVATE_SLOT_1.m_90857_()) {
            if (!TensuraSkillCapability.isSkillInSlot((LivingEntity)player, instance.getSkill(), 0)) {
                e.setCanceled(true);
            }
        } else if (TensuraKeybinds.ACTIVATE_SLOT_2.m_90857_()) {
            if (!TensuraSkillCapability.isSkillInSlot((LivingEntity)player, instance.getSkill(), 1)) {
                e.setCanceled(true);
            }
        } else if (TensuraKeybinds.ACTIVATE_SLOT_3.m_90857_()) {
            if (!TensuraSkillCapability.isSkillInSlot((LivingEntity)player, instance.getSkill(), 2)) {
                e.setCanceled(true);
            }
        } else {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void barrierHandler(SkillDamageEvent.Calculation e) {
        LivingEntity entity = e.getEntity();
        if (SkillUtils.noInteractiveMode(entity)) {
            return;
        }
        AttributeInstance instance = entity.m_21051_((Attribute)TensuraAttributeRegistry.BARRIER.get());
        if (instance == null) {
            return;
        }
        double barrier = instance.m_22135_();
        if (barrier > 0.0) {
            double mpCost;
            Player player;
            double lackedMP;
            float f;
            LivingEntity attacker;
            Entity entity2 = e.getSource().m_7639_();
            if (entity2 instanceof LivingEntity && RangedBarrierEntity.shouldInstaBreak(attacker = (LivingEntity)entity2, (Entity)entity)) {
                instance.m_22132_();
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 1.0f, 1.0f);
                return;
            }
            DamageSource damageSource = e.getSource();
            if (damageSource instanceof TensuraEntityDamageSource) {
                TensuraEntityDamageSource tensuraSource = (TensuraEntityDamageSource)damageSource;
                f = Math.min(e.getAmount() * tensuraSource.getIgnoreBarrier(), e.getAmount());
            } else {
                f = 0.0f;
            }
            float ignoredDamage = f;
            float bypassDamage = (float)Math.max((double)(e.getAmount() - ignoredDamage) - barrier, 0.0);
            if (bypassDamage > 0.0f) {
                instance.m_22132_();
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            float takenDamage = bypassDamage + ignoredDamage;
            if (entity instanceof Player && (lackedMP = SkillHelper.outOfMagiculeStillConsume((LivingEntity)(player = (Player)entity), (int)(mpCost = (double)((e.getAmount() - takenDamage) * 5.0f)))) > 0.0) {
                takenDamage = (float)((double)takenDamage + lackedMP / 5.0);
                instance.m_22132_();
                entity.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_11983_, SoundSource.AMBIENT, 1.0f, 1.0f);
            }
            e.setAmount(takenDamage);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void critChance(CriticalChanceEvent e) {
        double chance = e.getCritChance();
        if (chance <= 0.0) {
            return;
        }
        if (SkillUtils.canNegateCritChance(e.getTarget())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void preCalculation(SkillDamageEvent.PreCalculation e) {
        LivingEntity attacker;
        Entity entity;
        LivingEntity target = e.getEntity();
        if (DamageSourceHelper.isHoly(e.getSource()) && RaceHelper.isUndead((Entity)target)) {
            e.setAmount(e.getAmount() * 3.0f);
        }
        if ((entity = e.getSource().m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21255_() && VortexSpearItem.onHit(attacker, target, target.m_20182_())) {
            double d7 = attacker.m_20184_().m_165924_();
            e.setAmount(e.getAmount() + (float)(d7 * 10.0));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void cancelingDamage(LivingAttackEvent e) {
        Player player;
        LivingEntity target = e.getEntity();
        if (target instanceof Player && TensuraPlayerCapability.isSpiritualForm(player = (Player)target) && !MobEffectHelper.inSpiritualWorld((ResourceKey<Level>)player.m_9236_().m_46472_()) && DamageSourceHelper.isPhysicalAttack(e.getSource())) {
            e.setCanceled(true);
        }
        if (TensuraGameRules.isLabyrinthPvpOff(target.m_9236_())) {
            if (e.getSource().equals(DamageSource.f_19307_)) {
                e.setCanceled(true);
                return;
            }
            if (TensuraGameRules.isLabyrinthPvpOff(target.m_9236_(), (Entity)target, e.getSource().m_7639_())) {
                e.setCanceled(true);
                return;
            }
        }
        if ((e.getSource().equals(DamageSource.f_19316_) || e.getSource().m_146707_()) && VortexSpearItem.onHit(target, null, target.m_20182_())) {
            e.setCanceled(true);
            return;
        }
        Entity entity = e.getSource().m_7639_();
        if (entity instanceof LivingEntity) {
            Player player2;
            boolean creativeSource;
            LivingEntity attacker = (LivingEntity)entity;
            boolean bl = creativeSource = attacker instanceof Player && (player2 = (Player)attacker).m_7500_();
            if (!creativeSource) {
                LivingEntity targetOwner;
                if (TensuraEPCapability.isTargetNeutral(attacker, target)) {
                    e.setCanceled(true);
                }
                if (SkillHelper.isSubordinate(target, attacker)) {
                    e.setCanceled(true);
                }
                if ((targetOwner = SkillHelper.getSubordinateOwner(target)) != null && SkillHelper.isSubordinate(targetOwner, attacker)) {
                    e.setCanceled(true);
                }
            }
            TensuraEPCapability.getFrom(target).ifPresent(cap -> {
                if (cap.isTargetNeutral(attacker.m_20148_())) {
                    cap.removeNeutralTarget(attacker.m_20148_());
                    TensuraEPCapability.sync(target);
                }
            });
        }
        if ((entity = e.getSource().m_7639_()) instanceof Player) {
            player = (Player)entity;
            if (SkillUtils.noInteractiveMode((LivingEntity)player)) {
                e.setCanceled(true);
            }
            if (TensuraPlayerCapability.isSpiritualForm(player) && !MobEffectHelper.inSpiritualWorld((ResourceKey<Level>)player.m_9236_().m_46472_()) && DamageSourceHelper.isPhysicalAttack(e.getSource())) {
                e.setCanceled(true);
            }
        }
        if (target.m_21023_((MobEffect)TensuraMobEffects.ALLY_BOOST.get()) && target.m_217043_().m_188503_(4) == 1 && !SkillUtils.canNegateDodge(target, e.getSource())) {
            target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void cancelingDamage(LivingDamageEvent e) {
        LivingEntity entity = e.getEntity();
        TensuraEffectsCapability.getFrom(entity).ifPresent(cap -> {
            if (DamageSourceHelper.noDyingAnimation(e.getSource())) {
                cap.setNoDyingAnimation(true);
                TensuraEffectsCapability.sync(entity);
            } else if (cap.isNoDyingAnimation()) {
                cap.setNoDyingAnimation(false);
                TensuraEffectsCapability.sync(entity);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDamaged(LivingDamageEvent e) {
        if (e.getAmount() > Float.MAX_VALUE || Float.isNaN(e.getAmount())) {
            e.setAmount(Float.MAX_VALUE);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onProjectileImpact(ProjectileImpactEvent e) {
        EntityHitResult entityHitResult;
        HitResult hitResult = e.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && (hitResult = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)hitResult;
            if (SkillUtils.noInteractiveMode(target)) {
                e.setCanceled(true);
            }
            if (target.m_21023_((MobEffect)TensuraMobEffects.ALLY_BOOST.get()) && target.m_217043_().m_188503_(4) == 1) {
                target.m_9236_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12318_, SoundSource.PLAYERS, 2.0f, 1.0f);
                e.setCanceled(true);
            }
            if (target instanceof IOtherworlder) {
                IOtherworlder entity = (IOtherworlder)target;
                entity.onProjectileImpact(e);
            }
        }
    }

    @SubscribeEvent
    public static void onTotemUse(LivingUseTotemEvent e) {
        LivingEntity entity = e.getEntity();
        SkillMobEffect.removeAllEffects(entity);
        TensuraEffectsCapability.resetEverything(entity, false, false);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent e) {
        Player player = e.getEntity();
        if (player.m_9236_().m_5776_() || e.isEndConquered()) {
            return;
        }
        TensuraEPCapability.setSkippingEPDrop((LivingEntity)player, false);
        TensuraEffectsCapability.resetEverything((LivingEntity)player, true, false);
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            cap.setSleepMode(0);
            if (cap.getRace() != null) {
                cap.setSpiritualForm(MobEffectHelper.inSpiritualWorld(cap.getRace().getRespawnDimension()));
                RaceHelper.handleRespawnDimension(player, cap.getRace());
            }
            TensuraPlayerCapability.sync(player);
        });
        TensuraEPCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
            cap.setSpiritualHealth(player.m_21133_((Attribute)TensuraAttributeRegistry.MAX_SPIRITUAL_HEALTH.get()));
            cap.setTemporaryOwner(null);
            cap.clearNeutralTargets();
            cap.setHumanKill(0);
        });
        TensuraEPCapability.sync((LivingEntity)player);
        SkillStorage storage = SkillAPI.getSkillsFrom((Entity)player);
        List<ManasSkillInstance> list = List.copyOf(storage.getLearnedSkills());
        for (ManasSkillInstance copy : list) {
            Optional optional = storage.getSkill(copy.getSkill());
            if (optional.isEmpty()) continue;
            ManasSkillInstance instance = (ManasSkillInstance)optional.get();
            if (instance.isTemporarySkill()) {
                if (instance.getTag() != null && instance.getTag().m_128451_("OldRemoval") == -1) {
                    if (!instance.getTag().m_128441_("OldMastery")) continue;
                    instance.setRemoveTime(-1);
                    instance.setMastery(instance.getTag().m_128451_("OldMastery"));
                    instance.getTag().m_128473_("OldMastery");
                    continue;
                }
                storage.forgetSkill(instance);
                continue;
            }
            if (!instance.isToggled()) continue;
            if (instance.canInteractSkill((LivingEntity)player)) {
                instance.onToggleOn((LivingEntity)player);
                continue;
            }
            instance.setToggled(false);
        }
    }

    @SubscribeEvent
    public static void onPlaySound(PlayLevelSoundEvent.AtEntity e) {
        Entity entity = e.getEntity();
        if (SkillUtils.isSkillToggled(entity, (ManasSkill)UniqueSkills.MURDERER.get())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent e) {
        LivingEntity entity = e.getEntity();
        if (MobEffectHelper.noTeleportation(entity)) {
            return;
        }
        if (entity.m_6144_() || entity.m_20092_()) {
            return;
        }
        List list = entity.m_9236_().m_6443_(WarpPortalEntity.class, entity.m_20191_().m_82400_((double)0.2f), portal -> portal.getLife() > 0 && portal.isInstant());
        if (!list.isEmpty()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDeathHighPriority(LivingDeathEvent e) {
        boolean instantRegen;
        LivingEntity entity = e.getEntity();
        if (entity.f_20890_) {
            e.setCanceled(true);
            return;
        }
        DamageSource source = e.getSource();
        Level level = entity.m_9236_();
        if (Float.isNaN(entity.m_21223_()) || entity.m_21223_() < 0.0f) {
            entity.revive();
            entity.m_21153_(0.0f);
            if (!(entity instanceof Player)) {
                entity.m_146870_();
            }
            return;
        }
        MobEffectInstance instance = entity.m_21124_((MobEffect)TensuraMobEffects.INSTANT_REGENERATION.get());
        boolean bl = instantRegen = instance != null && instance.m_19564_() >= 1 && InstantRegenerationEffect.canStopDeath(source, entity);
        if (!instantRegen && entity instanceof ElementalColossusEntity) {
            ElementalColossusEntity colossus = (ElementalColossusEntity)entity;
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity2;
                colossus.markAsPassedAndTeleport(living, false, true);
            } else if (colossus.m_21188_() != null) {
                colossus.markAsPassedAndTeleport(colossus.m_21188_(), false, true);
            }
        } else if (instantRegen) {
            entity.m_21153_(0.01f);
            e.setCanceled(true);
        } else if (level.m_46472_().equals(TensuraDimensions.LABYRINTH)) {
            ISummonable summonable;
            boolean canDie = source.m_19378_();
            boolean bl2 = canDie = canDie || entity.m_6095_().m_204039_(TensuraTags.EntityTypes.CAN_DIE_IN_LABYRINTH) || entity instanceof ISummonable && (summonable = (ISummonable)entity).getSummoningTick() > 0;
            if (canDie || level.m_46469_().m_46207_(TensuraGameRules.LABYRINTH_DEATH)) {
                LabyrinthHandler.handleGameMode(entity, true);
            } else {
                entity.m_21153_(0.01f);
                e.setCanceled(true);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    entity.f_19802_ = 100;
                    SkillHelper.removePredicateEffect(entity, effect -> true);
                    Entity entity3 = source.m_7639_();
                    if (entity3 instanceof ElementalColossusEntity) {
                        ElementalColossusEntity colossus = (ElementalColossusEntity)entity3;
                        colossus.markAsPassedAndTeleport(entity, true, false);
                    } else {
                        entity3 = entity.m_21188_();
                        if (entity3 instanceof ElementalColossusEntity) {
                            ElementalColossusEntity colossus = (ElementalColossusEntity)entity3;
                            colossus.markAsPassedAndTeleport(entity, true, false);
                        } else {
                            entity.changeDimension(serverLevel.m_7654_().m_129783_(), (ITeleporter)new LabyrinthTeleporter());
                        }
                    }
                }
            }
        }
        if (e.isCanceled()) {
            return;
        }
        Entity entity4 = source.m_7639_();
        if (entity4 instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity4;
            for (MobEffectInstance effectInstance : attacker.m_21220_()) {
                MobEffect mobEffect = effectInstance.m_19544_();
                if (!(mobEffect instanceof DamageAction)) continue;
                DamageAction effect2 = (DamageAction)mobEffect;
                effect2.onKillEntity(attacker, e);
            }
            if (e.isCanceled()) {
                return;
            }
            TensuraEPCapability.getFrom(entity).ifPresent(cap -> {
                if (Objects.equals(cap.getPermanentOwner(), attacker.m_20148_())) {
                    cap.setPermanentOwner(null);
                    TensuraEPCapability.sync(entity);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onDeathNormalPriority(LivingDeathEvent e) {
        if (e.isCanceled()) {
            return;
        }
        if (e.getEntity().f_19853_.m_5776_()) {
            return;
        }
        e.getEntity().m_146850_((GameEvent)TensuraGameEvents.AFTER_CHEAT_DEATH.get());
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeathLowPriority(LivingDeathEvent e) {
        entity = e.getEntity();
        if (e.isCanceled()) {
            return;
        }
        if (entity.f_19853_.m_5776_()) {
            return;
        }
        if (entity.m_6084_()) {
            return;
        }
        owner = SkillHelper.getSubordinateOwner(entity);
        if (owner != null) {
            SkillHandler.onSubordinateDeath(owner, e);
        }
        if (!(entity instanceof Player)) ** GOTO lbl-1000
        player = (Player)entity;
        if (e.getSource().equals(TensuraDamageSources.MAGICULE_POISON)) {
            RaceHelper.applyMajinChance(player);
        } else if ((var5_4 = e.getSource().m_7639_()) instanceof LivingEntity) {
            attacker = (LivingEntity)var5_4;
            SkillHandler.addStatistic(entity, attacker, e.getSource());
        }
        if (!entity.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        if (entity.m_6095_().m_204039_(TensuraTags.EntityTypes.DROP_CRYSTAL)) {
            if (entity.m_9236_().m_46469_().m_46215_(TensuraGameRules.VANILLA_EP) == 0) {
                id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
                if (id == null) {
                    return;
                }
                if (id.m_135827_().equals("minecraft")) {
                    return;
                }
            }
            IRanking.dropMagicCrystal(entity);
        }
    }

    private static void addStatistic(LivingEntity target, LivingEntity attacker, DamageSource source) {
        EntityType type;
        LivingEntity owner = attacker;
        LivingEntity subOwner = SkillHelper.getSubordinateOwner(attacker);
        if (subOwner != null && !(attacker instanceof Player)) {
            owner = subOwner;
        }
        if ((type = target.m_6095_()).m_204039_(TensuraTags.EntityTypes.HUMAN) || TensuraPlayerCapability.getRace(target) instanceof HumanRace) {
            TensuraEPCapability.increaseHumanKill(owner);
        }
        if (owner instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)owner;
            if (SkillHelper.getSubordinateOwner(target) == null) {
                if (type == TensuraEntityTypes.HINATA_SAKAGUCHI.get()) {
                    TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.GREAT_SAINT_OF_THE_WEST);
                }
                if (type.m_204039_(TensuraTags.EntityTypes.HERO_BOSS)) {
                    if (type == TensuraEntityTypes.IFRIT.get()) {
                        TensuraAdvancementsHelper.grant(player, TensuraAdvancementsHelper.Advancements.CONQUEROR_OF_FLAMES);
                    }
                    player.m_36246_(((StatType)TensuraStats.BOSS_KILLED.get()).m_12902_((Object)type));
                }
            }
            if (attacker instanceof CloneEntity) {
                CriteriaTriggers.f_10568_.m_48104_(player, (Entity)target, source);
                player.m_36246_(Stats.f_12986_.m_12902_((Object)type));
                player.m_36220_(Stats.f_12936_);
            }
        }
    }

    private static void onSubordinateDeath(LivingEntity owner, LivingDeathEvent e) {
        SkillStorage skillStorage = SkillAPI.getSkillsFrom((Entity)owner);
        List<ManasSkillInstance> list = List.copyOf(skillStorage.getLearnedSkills());
        if (list.isEmpty()) {
            return;
        }
        for (ManasSkillInstance copy : list) {
            TensuraSkillInstance skillInstance;
            Object t;
            Optional optional = skillStorage.getSkill(copy.getSkill());
            if (optional.isEmpty() || !((t = optional.get()) instanceof TensuraSkillInstance) || !(skillInstance = (TensuraSkillInstance)((Object)t)).canInteractSkill(owner)) continue;
            skillInstance.onSubordinateDeath(owner, e);
        }
        skillStorage.syncChanges();
    }
}

