/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.tensura.api.race.AdvancedHitbox;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.network.play2server.SlimeJumpReleasedPacket;
import com.github.manasmods.tensura.race.Race;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.race.slime.SlimeRace;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RaceHandler {
    @SubscribeEvent
    public static void resizeOnLogin(EntityJoinLevelEvent e) {
        if (e.getLevel().m_5776_()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        player.m_6210_();
        TensuraPlayerCapability.sync(player);
    }

    @SubscribeEvent
    public static void resizeOnSizeChange(EntityEvent.Size e) {
        float skillSize;
        float height;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        boolean shouldChange = false;
        EntityDimensions size = e.getNewSize();
        float eyeHeight = e.getNewEyeHeight();
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (race != null) {
            if (RaceHelper.getRaceSize(race) != 1.0f) {
                float scale = RaceHelper.getRaceSize(race);
                size = size.m_20388_(scale);
                eyeHeight *= scale;
                shouldChange = true;
            }
            if (race instanceof AdvancedHitbox) {
                AdvancedHitbox hitbox = (AdvancedHitbox)((Object)race);
                size = size.m_20390_(hitbox.getHitboxWidthModifier(), hitbox.getHitboxHeightModifier());
                eyeHeight *= hitbox.getHitboxHeightModifier();
                shouldChange = true;
            }
        }
        if ((height = TensuraEffectsCapability.getHeight((LivingEntity)player)) != 1.0f && height != 0.0f) {
            size = size.m_20390_(1.0f, height);
            eyeHeight *= height;
            shouldChange = true;
        }
        if ((skillSize = RaceHelper.getSkillSizeMultiplier((LivingEntity)player)) != 1.0f) {
            size = size.m_20388_(skillSize);
            eyeHeight *= skillSize;
            shouldChange = true;
        }
        if (shouldChange) {
            e.setNewSize(size);
            e.setNewEyeHeight(eyeHeight);
        }
    }

    @SubscribeEvent
    public static void onSetSpawn(PlayerSetSpawnEvent e) {
        Player player = e.getEntity();
        Race race = TensuraPlayerCapability.getRace((LivingEntity)player);
        if (race == null) {
            return;
        }
        if ((e.getSpawnLevel() == TensuraDimensions.LABYRINTH || e.getSpawnLevel() == TensuraDimensions.HELL) && race.getRespawnDimension() != e.getSpawnLevel()) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onSlimeTakeFallDamage(LivingFallEvent e) {
        if (e.getEntity().f_19853_.m_5776_()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.getRace() instanceof SlimeRace) {
                e.setDistance(Math.max(e.getDistance(), 0.0f));
                e.setDamageMultiplier(0.5f);
            }
        });
    }

    @SubscribeEvent
    public static void onSlimeJump(LivingEvent.LivingJumpEvent e) {
        if (e.getEntity().f_19853_.m_5776_()) {
            return;
        }
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_5833_()) {
            return;
        }
        TensuraPlayerCapability.getFrom(player).ifPresent(cap -> {
            if (cap.getRace() instanceof SlimeRace) {
                if (!SlimeJumpReleasedPacket.jumpChargeData.containsKey(player.m_20148_())) {
                    if (player.m_6047_() && !RaceHandler.isInFluid((LivingEntity)player) && player.m_20096_()) {
                        player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
                    }
                } else {
                    float jumpCharge = SlimeJumpReleasedPacket.jumpChargeData.get(player.m_20148_()).floatValue();
                    Vec3 look = player.m_20154_().m_82541_();
                    float modifier = 3.3000002f;
                    look = look.m_82542_((double)(3.5000002f * jumpCharge), (double)(3.3000002f * jumpCharge), (double)(3.5000002f * jumpCharge));
                    look = look.m_82520_(0.0, player.m_20184_().f_82480_, 0.0);
                    player.m_20256_(look);
                    player.f_19864_ = true;
                    SlimeJumpReleasedPacket.jumpChargeData.remove(player.m_20148_());
                }
            }
        });
    }

    public static boolean isInFluid(LivingEntity entity) {
        return entity.m_20072_() || entity.m_20077_() || entity.m_9236_().m_8055_(entity.m_20183_()).m_60734_() instanceof LiquidBlock;
    }
}

