/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.ElementalColossusEntity;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.dimensions.TensuraDimensions;
import com.github.manasmods.tensura.world.savedata.LabyrinthSaveData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LabyrinthHandler {
    @SubscribeEvent
    public static void projectileImpactEvent(ProjectileImpactEvent event) {
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        Projectile projectile = event.getProjectile();
        BlockPos location = blockHitResult.m_82425_();
        Level level = projectile.m_9236_();
        if (level.m_8055_(location).m_60734_() != TensuraBlocks.LABYRINTH_BARRIER_BLOCK.get()) {
            return;
        }
        projectile.m_146884_(blockHitResult.m_82450_());
        projectile.m_20256_(projectile.m_20184_().m_82548_().m_82490_(0.5));
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onThrowPureMagisteel(ItemTossEvent event) {
        Player player = event.getPlayer();
        Level level = player.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (level2.m_46472_() != TensuraDimensions.LABYRINTH) {
            return;
        }
        MinecraftServer server = level2.m_7654_();
        LabyrinthSaveData saveData = LabyrinthSaveData.get(server.m_129783_());
        Vec3 pos = saveData.getColossusPos();
        if (player.m_20238_(pos) >= 100.0) {
            return;
        }
        if (saveData.isHavingColossus()) {
            return;
        }
        ItemEntity item = event.getEntity();
        ItemStack stack = item.m_32055_();
        if (!stack.m_150930_((Item)TensuraBlocks.Items.PURE_MAGISTEEL_BLOCK.get())) {
            return;
        }
        if (stack.m_41613_() == 1) {
            item.m_146870_();
        } else {
            stack.m_41774_(1);
        }
        ElementalColossusEntity colossus = new ElementalColossusEntity(level2, pos, MobSpawnType.MOB_SUMMONED);
        level2.m_7967_((Entity)colossus);
        saveData.setHavingColossus(true);
        SkillHelper.knockBack((LivingEntity)colossus, (LivingEntity)player, 5.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)colossus, (ParticleOptions)ParticleTypes.f_123812_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)colossus, (ParticleOptions)ParticleTypes.f_123767_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)colossus, (ParticleOptions)ParticleTypes.f_123767_, 2.0);
        colossus.m_9236_().m_6263_(null, colossus.m_20185_(), colossus.m_20186_(), colossus.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 2.0f, 1.0f);
        colossus.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12513_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @SubscribeEvent
    public static void loadLabyrinth(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelAccessor;
        if (serverLevel.m_46472_() != TensuraDimensions.LABYRINTH) {
            return;
        }
        MinecraftServer server = serverLevel.m_7654_();
        LabyrinthSaveData saveData = LabyrinthSaveData.get(server.m_129783_());
        if (saveData.isLoaded()) {
            return;
        }
        ServerLevel level = server.m_129880_(TensuraDimensions.LABYRINTH);
        if (level == null) {
            return;
        }
        StructureTemplateManager manager = level.m_215082_();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        List<StructureTemplate> templates = LabyrinthHandler.loadTemplates(manager);
        for (StructureTemplate template : templates) {
            int i = templates.indexOf(template);
            BlockPos placePos = switch (i) {
                case 0 -> new BlockPos(26, 41, 9);
                case 1 -> new BlockPos(26, 41, 72);
                case 2 -> new BlockPos(26, 41, 136);
                case 3 -> new BlockPos(26, 41, 199);
                case 4 -> new BlockPos(26, 41, 263);
                case 5 -> new BlockPos(33, -6, 324);
                case 6 -> new BlockPos(33, -6, 369);
                case 7 -> new BlockPos(33, -6, 414);
                case 8 -> new BlockPos(33, -6, 459);
                case 9 -> new BlockPos(1, 77, 505);
                case 10 -> new BlockPos(33, -6, 587);
                case 11 -> new BlockPos(-33, -6, 587);
                case 12 -> new BlockPos(-143, -37, 587);
                case 13 -> new BlockPos(-143, 11, 587);
                case 14 -> new BlockPos(-143, 59, 586);
                case 15 -> new BlockPos(-143, 107, 586);
                case 16 -> new BlockPos(-143, 155, 586);
                case 17 -> new BlockPos(-143, 203, 586);
                default -> new BlockPos(0, 0, 0);
            };
            template.m_230328_((ServerLevelAccessor)level, placePos, placePos, settings, level.f_46441_, 3);
        }
        saveData.setLoaded(true);
        ElementalColossusEntity colossus = new ElementalColossusEntity(level, saveData.getColossusPos(), MobSpawnType.NATURAL);
        if (level.m_7967_((Entity)colossus)) {
            saveData.setHavingColossus(true);
        }
    }

    @SubscribeEvent
    public static void changedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player.m_9236_().m_5776_()) {
            return;
        }
        LabyrinthSaveData.removeStartedEntity((LivingEntity)player);
        if (event.getFrom() == TensuraDimensions.LABYRINTH) {
            LabyrinthHandler.handleGameMode((LivingEntity)player, true);
        } else if (event.getTo() == TensuraDimensions.LABYRINTH) {
            LabyrinthHandler.handleGameMode((LivingEntity)player, false);
        }
    }

    private static List<StructureTemplate> loadTemplates(StructureTemplateManager manager) {
        ArrayList<StructureTemplate> templates = new ArrayList<StructureTemplate>();
        for (int i = 0; i < 18; ++i) {
            String path = switch (i) {
                case 0 -> "labyrinth/labyrinth_entrance_hallway_1";
                case 1 -> "labyrinth/labyrinth_entrance_hallway_2";
                case 2 -> "labyrinth/labyrinth_entrance_hallway_3";
                case 3 -> "labyrinth/labyrinth_entrance_hallway_4";
                case 4 -> "labyrinth/labyrinth_entrance_hallway_5";
                case 5 -> "labyrinth/labyrinth_light_hallway_entrance_1";
                case 6 -> "labyrinth/labyrinth_light_hallway_entrance_2";
                case 7 -> "labyrinth/labyrinth_light_hallway_entrance_3";
                case 8 -> "labyrinth/labyrinth_light_hallway_entrance_4";
                case 9 -> "labyrinth/labyrinth_arena";
                case 10 -> "labyrinth/labyrinth_light_hallway_1";
                case 11 -> "labyrinth/labyrinth_light_hallway_2";
                case 12 -> "labyrinth/labyrinth_spirit_dwelling_1";
                case 13 -> "labyrinth/labyrinth_spirit_dwelling_2";
                case 14 -> "labyrinth/labyrinth_spirit_dwelling_3";
                case 15 -> "labyrinth/labyrinth_spirit_dwelling_4";
                case 16 -> "labyrinth/labyrinth_spirit_dwelling_5";
                case 17 -> "labyrinth/labyrinth_spirit_dwelling_6";
                default -> "";
            };
            ResourceLocation resourceLocation = new ResourceLocation("tensura", path);
            templates.add(manager.m_230359_(resourceLocation));
        }
        return templates;
    }

    public static void handleGameMode(LivingEntity entity, boolean leaving) {
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        GameType current = player.f_8941_.m_9290_();
        if (leaving) {
            if (current != GameType.ADVENTURE) {
                return;
            }
            MinecraftServer server = player.f_19853_.m_7654_();
            if (server == null) {
                player.m_143403_(GameType.f_151492_);
                return;
            }
            GameType type = server.m_130008_();
            if (type.m_46409_() && type != current) {
                player.m_143403_(type);
            } else {
                player.m_143403_(GameType.f_151492_);
            }
        } else {
            if (current != GameType.SURVIVAL) {
                return;
            }
            player.m_143403_(GameType.ADVENTURE);
        }
    }
}

