/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.handler;

import com.github.manasmods.tensura.capability.effects.ITensuraEffectsCapability;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.ITensuraEPCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapability;
import com.github.manasmods.tensura.capability.magicule.MagiculeChunkCapabilityImpl;
import com.github.manasmods.tensura.capability.race.ITensuraPlayerCapability;
import com.github.manasmods.tensura.capability.race.TensuraPlayerCapability;
import com.github.manasmods.tensura.capability.skill.ITensuraSkillCapability;
import com.github.manasmods.tensura.capability.skill.TensuraSkillCapability;
import com.github.manasmods.tensura.capability.smithing.ISmithingCapability;
import com.github.manasmods.tensura.capability.smithing.SmithingCapability;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tensura", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityHandler {
    public static void registerCapabilities(RegisterCapabilitiesEvent e) {
        e.register(ITensuraPlayerCapability.class);
        e.register(ISmithingCapability.class);
        e.register(ITensuraEffectsCapability.class);
        e.register(ITensuraEPCapability.class);
        e.register(ITensuraSkillCapability.class);
        e.register(MagiculeChunkCapability.class);
    }

    @SubscribeEvent
    static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        Player player = e.getEntity();
        if (player.m_20147_() && !player.m_150110_().f_35934_) {
            player.m_20331_(false);
        }
        TensuraPlayerCapability.sync(player);
        TensuraPlayerCapability.checkForFirstLogin(player);
        TensuraEffectsCapability.getFrom((LivingEntity)player).ifPresent(cap -> {
            if (cap.getHeight() == 0.0f) {
                cap.setHeight(1.0f);
            }
        });
        SmithingCapability.sync(player);
        TensuraEffectsCapability.sync((LivingEntity)player);
        TensuraEPCapability.sync((LivingEntity)player);
        TensuraSkillCapability.sync(player);
    }

    @SubscribeEvent
    static void onPlayerTrack(PlayerEvent.StartTracking e) {
        Entity entity = e.getTarget();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            TensuraEffectsCapability.sync(living);
            TensuraEffectsCapability.sync((LivingEntity)e.getEntity());
            TensuraEPCapability.sync(living);
            TensuraEPCapability.sync((LivingEntity)e.getEntity());
        }
        if ((entity = e.getTarget()) instanceof Player) {
            Player player = (Player)entity;
            TensuraPlayerCapability.sync(player);
            TensuraPlayerCapability.sync(e.getEntity());
            SmithingCapability.sync(player);
            TensuraSkillCapability.sync(player);
            TensuraSkillCapability.sync(e.getEntity());
        }
    }

    @SubscribeEvent
    static void onPlayerClone(PlayerEvent.Clone e) {
        e.getOriginal().reviveCaps();
        TensuraPlayerCapability.getFrom(e.getOriginal()).ifPresent(oldData -> TensuraPlayerCapability.getFrom(e.getEntity()).ifPresent(data -> {
            data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()));
            data.applyBaseAttributeModifiers((LivingEntity)e.getEntity());
            data.setSprintSpeed(data.getSprintSpeed(), e.getEntity());
        }));
        if (!e.isWasDeath()) {
            CloneEntity.copyAttributeModifiers((LivingEntity)e.getOriginal(), (LivingEntity)e.getEntity());
            for (MobEffectInstance instance : e.getOriginal().m_21220_()) {
                e.getEntity().m_7292_(new MobEffectInstance(instance));
            }
            e.getEntity().m_6210_();
        }
        SmithingCapability.getFrom(e.getOriginal()).ifPresent(oldData -> SmithingCapability.getFrom(e.getEntity()).ifPresent(data -> data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        TensuraEffectsCapability.getFrom((LivingEntity)e.getOriginal()).ifPresent(oldData -> TensuraEffectsCapability.getFrom((LivingEntity)e.getEntity()).ifPresent(data -> data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        TensuraEPCapability.getFrom((LivingEntity)e.getOriginal()).ifPresent(oldData -> TensuraEPCapability.getFrom((LivingEntity)e.getEntity()).ifPresent(data -> data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        TensuraSkillCapability.getFrom(e.getOriginal()).ifPresent(oldData -> TensuraSkillCapability.getFrom(e.getEntity()).ifPresent(data -> data.deserializeNBT((Tag)((CompoundTag)oldData.serializeNBT()))));
        e.getOriginal().invalidateCaps();
    }

    @SubscribeEvent
    static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent e) {
        TensuraPlayerCapability.checkForFirstLogin(e.getEntity());
        TensuraPlayerCapability.sync(e.getEntity());
        if (!e.isEndConquered()) {
            TensuraPlayerCapability.resetMagiculeAura(e.getEntity());
        }
        SmithingCapability.sync(e.getEntity());
        TensuraEffectsCapability.sync((LivingEntity)e.getEntity());
        TensuraEPCapability.sync((LivingEntity)e.getEntity());
        TensuraSkillCapability.sync(e.getEntity());
    }

    @SubscribeEvent
    static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        TensuraPlayerCapability.sync(e.getEntity());
        SmithingCapability.sync(e.getEntity());
        TensuraEffectsCapability.sync((LivingEntity)e.getEntity());
        TensuraEPCapability.sync((LivingEntity)e.getEntity());
        TensuraSkillCapability.sync(e.getEntity());
    }

    @Nullable
    public static <T> T getCapability(Entity entity, Capability<T> capability) {
        return (T)(entity.getCapability(capability).isPresent() ? entity.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    @SubscribeEvent
    static void onWatchChunk(ChunkWatchEvent.Watch e) {
        MagiculeChunkCapabilityImpl.get(e.getChunk()).sync(e.getPlayer());
    }
}

