/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.variant;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;

public enum PeacockVariant {
    DEFAULT(0),
    ALTERNATIVE(1);

    private static final PeacockVariant[] BY_ID;
    private final int id;
    public static final Map<PeacockVariant, ResourceLocation> LOCATION_BY_VARIANT;

    private PeacockVariant(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static PeacockVariant byId(int id) {
        return BY_ID[id % BY_ID.length];
    }

    static {
        BY_ID = (PeacockVariant[])Arrays.stream(PeacockVariant.values()).sorted(Comparator.comparingInt(PeacockVariant::getId)).toArray(PeacockVariant[]::new);
        LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(PeacockVariant.class), variant -> {
            variant.put(DEFAULT, new ResourceLocation("tensura", "textures/entity/dragon_peacock/dragon_peacock_1.png"));
            variant.put(ALTERNATIVE, new ResourceLocation("tensura", "textures/entity/dragon_peacock/dragon_peacock_2.png"));
        });
    }
}

