/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.variant;

import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.resources.ResourceLocation;

public enum LandfishVariant {
    GREEN(0, "green"),
    CYAN(1, "cyan"),
    BLUE(2, "blue"),
    COD(3, "cod"),
    SALMON(4, "salmon"),
    PUFFER(5, "puffer"),
    DOLPHIN(6, "dolphin"),
    GUARDIAN(7, "guardian"),
    ELDER_GUARDIAN(8, "elder_guardian");

    private static final LandfishVariant[] BY_ID;
    private final int id;
    private final String location;

    private LandfishVariant(int id, String location) {
        this.id = id;
        this.location = location;
    }

    public static LandfishVariant byId(int id) {
        return BY_ID[id % BY_ID.length];
    }

    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/landfish/landfish_" + this.getLocation() + ".png");
    }

    public int getId() {
        return this.id;
    }

    public String getLocation() {
        return this.location;
    }

    static {
        BY_ID = (LandfishVariant[])Arrays.stream(LandfishVariant.values()).sorted(Comparator.comparingInt(LandfishVariant::getId)).toArray(LandfishVariant[]::new);
    }
}

