/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.projectile;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class LightArrowProjectile
extends TensuraProjectile {
    public LightArrowProjectile(EntityType<? extends LightArrowProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public LightArrowProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.LIGHT_ARROW.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/light_arrow.png")};
    }

    @Override
    public boolean piercingBlock() {
        return true;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    protected void hitEntity(Entity entity) {
        if (entity == this.m_37282_()) {
            return;
        }
        super.hitEntity(entity);
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.getDamage() <= 0.0f) {
            return;
        }
        DamageSource damageSource = TensuraDamageSources.indirectElementalAttack("tensura.light_attack", (Entity)this, this.m_37282_(), true);
        if (target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), this.getDamage())) {
            target.f_19802_ = 0;
        }
    }

    @Override
    protected void playHitSound(SoundEvent sound, HitResult hitresult) {
        if (hitresult.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
            super.playHitSound(sound, hitresult);
        }
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123808_, x, y, z, 15, 0.1, 0.1, 0.1, 0.1, true);
    }

    @Override
    public void flyingParticles() {
    }
}

