/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.projectile;

import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.item.custom.KunaiItem;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class KunaiProjectile
extends AbstractArrow {
    protected static final EntityDataAccessor<Integer> LOYALTY_LEVEL = SynchedEntityData.m_135353_(KunaiProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> SOURCE_ITEM = SynchedEntityData.m_135353_(KunaiProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Boolean> MULTISHOT = SynchedEntityData.m_135353_(KunaiProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean finishPiercing;
    private int piercingEntity = 0;
    public int clientSideReturnKunaiTickCount;

    public KunaiProjectile(EntityType<? extends KunaiProjectile> type, Level level) {
        super(type, level);
    }

    public KunaiProjectile(Level worldIn, LivingEntity shooter, ItemStack pStack, boolean right) {
        super((EntityType)TensuraEntityTypes.KUNAI.get(), shooter, worldIn);
        this.setSourceItem(pStack.m_41777_());
        float rot = shooter.f_20885_ + (float)(right ? 60 : -60);
        this.m_6034_(shooter.m_20185_() - (double)shooter.m_20205_() * 0.5 * (double)Mth.m_14031_((float)(rot * ((float)Math.PI / 180))), shooter.m_20188_() - (double)0.2f, shooter.m_20189_() + (double)shooter.m_20205_() * 0.5 * (double)Mth.m_14089_((float)(rot * ((float)Math.PI / 180))));
    }

    public KunaiProjectile(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)TensuraEntityTypes.KUNAI.get(), pX, pY, pZ, pLevel);
    }

    public ItemStack m_7941_() {
        return this.getSourceItem();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.finishPiercing ? null : super.m_6351_(pStartVec, pEndVec);
    }

    public void m_8119_() {
        int i;
        if (this.f_36704_ > 4) {
            this.finishPiercing = true;
        }
        Entity owner = this.m_37282_();
        int n = i = this.isMultishot() ? 0 : this.getLoyaltyLevel();
        if (i > 0 && (this.finishPiercing || this.m_36797_()) && owner != null && this.m_6084_()) {
            if (!this.isAcceptableReturnOwner()) {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = owner.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnKunaiTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12317_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnKunaiTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.m_37282_();
        if (entity == null) {
            return false;
        }
        if (!entity.m_6084_()) {
            return false;
        }
        return !(entity instanceof ServerPlayer) || !entity.m_5833_();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void m_5790_(EntityHitResult pResult) {
        Entity ownerEntity;
        DamageSource damagesource;
        Entity entity = pResult.m_82443_();
        ItemStack sourceStack = this.getSourceItem();
        Item item = sourceStack.m_41720_();
        if (!(item instanceof KunaiItem)) return;
        KunaiItem kunai = (KunaiItem)item;
        float projectileDamage = (float)((double)kunai.getBaseProjectileDamage() + this.m_36789_());
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            projectileDamage += EnchantmentHelper.m_44833_((ItemStack)sourceStack, (MobType)livingentity.m_6336_());
        }
        if (entity.m_6469_(damagesource = TensuraDamageSources.kunai(this, (Entity)Objects.requireNonNullElse(ownerEntity = this.m_37282_(), this)), projectileDamage)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (ownerEntity instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)ownerEntity;
                    EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)ownerEntity);
                    EnchantmentHelper.m_44896_((LivingEntity)owner, (Entity)livingEntity);
                    EngravingEnchantment.doAdditionalAttack(sourceStack, owner, entity, projectileDamage);
                    pResult.m_82443_().m_20254_(3 * sourceStack.getEnchantmentLevel(Enchantments.f_44981_));
                }
                this.m_7761_(livingEntity);
            }
        }
        ++this.piercingEntity;
        if (this.piercingEntity < 1 + sourceStack.getEnchantmentLevel(Enchantments.f_44961_)) return;
        this.finishPiercing = true;
        float breakingChance = 0.1f - (float)sourceStack.getEnchantmentLevel(Enchantments.f_44986_) * 0.01f;
        if (this.isMultishot()) {
            breakingChance = 0.0f;
        }
        if (sourceStack.m_41720_().getEnchantmentLevel(sourceStack, Enchantments.f_44963_) > 0) {
            breakingChance = 1.0f;
        }
        if (breakingChance > 0.0f) {
            Random random = new Random();
            if (random.nextFloat() < breakingChance) {
                this.m_146870_();
                this.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
                return;
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
    }

    protected void m_8060_(BlockHitResult pResult) {
        super.m_8060_(pResult);
        ItemStack sourceStack = this.getSourceItem();
        float breakingChance = 0.1f - (float)sourceStack.getEnchantmentLevel(Enchantments.f_44986_) * 0.01f;
        if (this.isMultishot()) {
            breakingChance = 0.0f;
        }
        if (sourceStack.m_41720_().getEnchantmentLevel(sourceStack, Enchantments.f_44963_) > 0) {
            breakingChance = 1.0f;
        }
        if (!this.finishPiercing) {
            Random random = new Random();
            if (random.nextFloat() < breakingChance) {
                if (this.f_19853_.f_46443_) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.05, 0.0);
                }
                this.m_146870_();
                this.m_5496_(SoundEvents.f_12018_, 1.0f, 1.0f);
            }
        }
    }

    protected boolean m_142470_(Player pPlayer) {
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(this.m_7941_());
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_37282_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public ItemStack getSourceItem() {
        return (ItemStack)this.f_19804_.m_135370_(SOURCE_ITEM);
    }

    public void setSourceItem(ItemStack pStack) {
        this.f_19804_.m_135381_(SOURCE_ITEM, (Object)pStack);
        this.setLoyaltyLevel(EnchantmentHelper.m_44928_((ItemStack)pStack));
    }

    public int getLoyaltyLevel() {
        return (Integer)this.f_19804_.m_135370_(LOYALTY_LEVEL);
    }

    public void setLoyaltyLevel(int level) {
        this.f_19804_.m_135381_(LOYALTY_LEVEL, (Object)level);
    }

    public boolean isMultishot() {
        return (Boolean)this.f_19804_.m_135370_(MULTISHOT);
    }

    public void setMultishot(boolean b) {
        this.f_19804_.m_135381_(MULTISHOT, (Object)b);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(MULTISHOT, (Object)Boolean.FALSE);
        this.f_19804_.m_135372_(SOURCE_ITEM, (Object)((KunaiItem)((Object)TensuraToolItems.KUNAI.get())).m_7968_());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("Source Item", 10)) {
            this.setSourceItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Source Item")));
        }
        this.setLoyaltyLevel(pCompound.m_128451_("Loyalty"));
        this.setMultishot(pCompound.m_128471_("Multishot"));
        this.finishPiercing = pCompound.m_128471_("DealtDamage");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("DealtDamage", this.finishPiercing);
        pCompound.m_128365_("Source Item", (Tag)this.getSourceItem().m_41739_(new CompoundTag()));
        pCompound.m_128405_("Loyalty", this.getLoyaltyLevel());
        pCompound.m_128379_("Multishot", this.isMultishot());
    }

    public void m_6901_() {
        int i = this.getLoyaltyLevel();
        if ((this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) && ++this.f_36697_ >= (Integer)TensuraConfig.INSTANCE.entitiesConfig.spearDespawn.get()) {
            this.m_146870_();
        }
    }

    protected float m_6882_() {
        return 0.7f + (float)this.getSourceItem().getEnchantmentLevel(Enchantments.f_44956_) * 0.04f;
    }
}

