/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.multipart;

import com.github.manasmods.tensura.api.entity.subclass.ILivingPartEntity;
import com.github.manasmods.tensura.entity.multipart.LivingMultipartBody;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class LivingMultipartHead
extends TensuraTamableEntity {
    private static final EntityDataAccessor<Optional<UUID>> CHILD_UUID = SynchedEntityData.m_135353_(LivingMultipartHead.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> CHILD_ID = SynchedEntityData.m_135353_(LivingMultipartHead.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SEGMENT_COUNT = SynchedEntityData.m_135353_(LivingMultipartHead.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final float[] ringBuffer = new float[64];
    public int ringBufferIndex = -1;
    protected LivingMultipartBody[] parts;

    public LivingMultipartHead(EntityType<? extends LivingMultipartHead> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHILD_UUID, Optional.empty());
        this.f_19804_.m_135372_(CHILD_ID, (Object)-1);
        this.f_19804_.m_135372_(SEGMENT_COUNT, (Object)5);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getChildId() != null) {
            compound.m_128362_("ChildUUID", this.getChildId());
        }
        compound.m_128405_("SegCount", this.getSegmentCount());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("ChildUUID")) {
            this.setChildId(compound.m_128342_("ChildUUID"));
        }
        this.setSegmentCount(compound.m_128451_("SegCount"));
    }

    public int getSegmentCount() {
        return Math.max((Integer)this.f_19804_.m_135370_(SEGMENT_COUNT), 1);
    }

    public void setSegmentCount(int segments) {
        this.f_19804_.m_135381_(SEGMENT_COUNT, (Object)segments);
    }

    @Nullable
    public UUID getChildId() {
        return ((Optional)this.f_19804_.m_135370_(CHILD_UUID)).orElse(null);
    }

    public void setChildId(@Nullable UUID uniqueId) {
        this.f_19804_.m_135381_(CHILD_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getChild() {
        UUID id = this.getChildId();
        if (id != null && !this.f_19853_.f_46443_) {
            return ((ServerLevel)this.f_19853_).m_8791_(id);
        }
        return null;
    }

    @Override
    public boolean m_7307_(Entity pEntity) {
        if (pEntity instanceof LivingMultipartBody) {
            LivingMultipartBody body = (LivingMultipartBody)pEntity;
            if (Objects.equals(body.getHeadId(), this.m_20148_())) {
                return true;
            }
            if (body.getHead() != null && pEntity.m_7307_(body.getHead())) {
                return true;
            }
        }
        return super.m_7307_(pEntity);
    }

    public boolean m_6779_(LivingEntity pTarget) {
        LivingMultipartBody body;
        if (pTarget instanceof LivingMultipartBody && Objects.equals((body = (LivingMultipartBody)pTarget).getHeadId(), this.m_20148_())) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    private boolean shouldReplaceParts() {
        if (this.parts == null || this.parts[0] == null || this.parts.length != this.getSegmentCount()) {
            return true;
        }
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            if (this.parts[i] != null) continue;
            return true;
        }
        return false;
    }

    abstract LivingMultipartBody createBody(LivingEntity var1, boolean var2);

    public void m_6842_(boolean pInvisible) {
        super.m_6842_(pInvisible);
        if (this.getChild() != null) {
            this.getChild().m_6842_(pInvisible);
        }
    }

    public void m_21837_(boolean pSitting) {
        super.m_21837_(pSitting);
        Entity entity = this.getChild();
        if (entity instanceof TamableAnimal) {
            TamableAnimal child = (TamableAnimal)entity;
            child.m_21837_(pSitting);
        }
    }

    public void m_6138_() {
        List list = this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82363_(0.2, 0.0, 0.2));
        for (Entity entity : list) {
            ILivingPartEntity part;
            if (!entity.m_6094_() || entity instanceof ILivingPartEntity && Objects.equals((part = (ILivingPartEntity)entity).getHeadId(), this.m_20148_())) continue;
            entity.m_7334_((Entity)this);
        }
    }

    protected void updateRot() {
        this.f_20885_ = this.f_20883_ = Mth.m_14036_((float)this.m_146908_(), (float)(this.f_20883_ - 2.0f), (float)(this.f_20883_ + 2.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.f_19817_ = false;
        this.updateRot();
        this.updateRingBuffer();
        if (!this.f_19853_.f_46443_) {
            Vec3 prevPos;
            Entity child = this.getChild();
            if (child == null) {
                TensuraTamableEntity partParent = this;
                this.parts = new LivingMultipartBody[this.getSegmentCount()];
                prevPos = this.m_20182_();
                float backOffset = this.m_20205_() / 2.0f;
                for (int i = 0; i < this.getSegmentCount(); ++i) {
                    float prevReqRot = this.calcPartRotation(i) + this.getPartYaw(i);
                    float reqRot = this.calcPartRotation(i + 1) + this.getPartYaw(i);
                    LivingMultipartBody part = this.createBody((LivingEntity)partParent, i == this.getSegmentCount() - 1);
                    part.setHead((Entity)this);
                    part.setParent((Entity)partParent);
                    part.setBodyIndex(i);
                    if (partParent == this) {
                        this.setChildId(part.m_20148_());
                        this.f_19804_.m_135381_(CHILD_ID, (Object)part.m_19879_());
                    }
                    if (partParent instanceof LivingMultipartBody) {
                        LivingMultipartBody body = (LivingMultipartBody)partParent;
                        body.setChildId(part.m_20148_());
                    }
                    part.m_146884_(part.repositionParts(backOffset, prevPos, this.m_146909_(), prevReqRot, reqRot, false));
                    this.f_19853_.m_7967_((Entity)part);
                    this.parts[i] = part;
                    partParent = part;
                    backOffset = part.getBackOffset();
                    prevPos = part.m_20182_();
                }
            }
            if (this.f_19797_ > 1) {
                if (this.shouldReplaceParts() && (prevPos = this.getChild()) instanceof LivingMultipartBody) {
                    LivingMultipartBody firstBody = (LivingMultipartBody)prevPos;
                    this.parts = new LivingMultipartBody[this.getSegmentCount()];
                    this.parts[0] = firstBody;
                    this.f_19804_.m_135381_(CHILD_ID, (Object)this.parts[0].m_19879_());
                    LivingMultipartBody partParent = this.parts[0];
                    Vec3 prevPos2 = this.m_20182_();
                    float backOffset = this.m_20205_() / 2.0f;
                    for (int i = 1; i < this.getSegmentCount(); ++i) {
                        Entity part = this.parts[i - 1].getChild();
                        if (part instanceof LivingMultipartBody) {
                            LivingMultipartBody body;
                            this.parts[i] = body = (LivingMultipartBody)part;
                            partParent = body;
                            backOffset = body.getBackOffset();
                            prevPos2 = body.m_20182_();
                            continue;
                        }
                        if (this.parts[i - 1].isEndSegment()) {
                            this.parts[i - 1].setEndSegment(false);
                        }
                        float prevReqRot = this.calcPartRotation(i) + this.getPartYaw(i);
                        float reqRot = this.calcPartRotation(i + 1) + this.getPartYaw(i);
                        LivingMultipartBody part2 = this.createBody((LivingEntity)partParent, i == this.getSegmentCount() - 1);
                        part2.setHead((Entity)this);
                        part2.setParent((Entity)partParent);
                        part2.setBodyIndex(i);
                        if (partParent instanceof LivingMultipartBody) {
                            LivingMultipartBody body = partParent;
                            body.setChildId(part2.m_20148_());
                        }
                        part2.m_146884_(part2.repositionParts(backOffset, prevPos2, this.m_146909_(), prevReqRot, reqRot, false));
                        this.f_19853_.m_7967_((Entity)part2);
                        this.parts[i] = part2;
                        partParent = part2;
                        backOffset = part2.getBackOffset();
                        prevPos2 = part2.m_20182_();
                    }
                }
                this.updatePartPosition();
            }
        }
    }

    protected void updateRingBuffer() {
        if (this.ringBufferIndex < 0) {
            Arrays.fill(this.ringBuffer, this.f_20883_);
        }
        if (this.shouldUpdateRingBuffer() || this.ringBufferIndex < 0) {
            ++this.ringBufferIndex;
        }
        if (this.ringBufferIndex == this.ringBuffer.length) {
            this.ringBufferIndex = 0;
        }
        this.ringBuffer[this.ringBufferIndex] = this.m_146908_();
    }

    protected void updatePartPosition() {
        if (this.parts == null) {
            return;
        }
        Vec3 prev = this.m_20182_();
        float xRot = this.m_146909_();
        float backOffset = this.m_20205_() / 2.0f;
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            if (this.parts[i] == null) continue;
            float prevReqRot = this.calcPartRotation(i) + this.getPartYaw(i);
            float reqRot = this.calcPartRotation(i + 1) + this.getPartYaw(i);
            prev = this.parts[i].repositionParts(backOffset, prev, xRot, prevReqRot, reqRot, true);
            xRot = this.parts[i].m_146909_();
            backOffset = this.parts[i].getBackOffset();
        }
    }

    protected boolean shouldUpdateRingBuffer() {
        if (this.m_6688_() != null) {
            return true;
        }
        return this.m_20184_().m_82556_() >= 0.005;
    }

    protected float getPartYaw(int i) {
        return this.getRingBuffer(4 + i, 1.0f);
    }

    protected float calcPartRotation(int i) {
        return 0.0f;
    }

    public float getRingBuffer(int bufferOffset, float partialTicks) {
        if (this.m_21224_()) {
            partialTicks = 0.0f;
        }
        partialTicks = 1.0f - partialTicks;
        int i = this.ringBufferIndex - bufferOffset & 0x3F;
        int j = this.ringBufferIndex - bufferOffset - 1 & 0x3F;
        float d0 = this.ringBuffer[i];
        float d1 = this.ringBuffer[j] - d0;
        return Mth.m_14177_((float)(d0 + d1 * partialTicks));
    }
}

