/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.skill;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class HeatSphereProjectile
extends TensuraProjectile {
    protected static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_0.png"), new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_1.png"), new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_2.png"), new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_3.png"), new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_4.png"), new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_5.png"), new ResourceLocation("tensura", "textures/entity/projectiles/heat_sphere/heat_sphere_6.png")};

    public HeatSphereProjectile(EntityType<? extends HeatSphereProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public HeatSphereProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.HEAT_SPHERE.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public String getMagic() {
        return "heat_wave";
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public boolean piercingEntity() {
        return true;
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return TEXTURES;
    }

    @Override
    public void setPosAndShoot(LivingEntity entity) {
        this.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0));
        this.shootFromRot(entity.m_20154_());
    }

    @Override
    protected void dealDamage(Entity target) {
        DamageSource damageSource = TensuraDamageSources.HEAT_WAVE;
        Entity entity = this.m_37282_();
        if (entity instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            damageSource = TensuraDamageSources.heatWave((Entity)owner);
        }
        if (this.damage > 0.0f) {
            target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), this.getDamage());
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.applyEffectAround(this.getEffectRange());
    }

    @Override
    public void applyEffectAround(double inflateRadius) {
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(inflateRadius), entityData -> this.m_37282_() == null || !entityData.m_7307_(this.m_37282_()) && !entityData.m_7306_(this.m_37282_()));
        if (livingEntityList.isEmpty()) {
            return;
        }
        for (LivingEntity target : livingEntityList) {
            if (RandomSource.m_216327_().m_188499_()) continue;
            DamageSource damageSource = TensuraDamageSources.HEAT_WAVE;
            Entity entity = this.m_37282_();
            if (entity instanceof LivingEntity) {
                LivingEntity owner = (LivingEntity)entity;
                damageSource = TensuraDamageSources.heatWave((Entity)owner);
            }
            if (!(this.damage > 0.0f)) continue;
            target.m_6469_(DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost() / 10.0), this.getDamage() / 6.0f);
        }
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1, 0.12, 0.12, 0.12, 0.15, false);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), x, y, z, 10, 0.5, 0.5, 0.5, 0.1, false);
    }

    @Override
    public void flyingParticles() {
        if ((double)this.f_19796_.m_188501_() <= 0.8) {
            double dx = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double dy = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double dz = this.f_19853_.f_46441_.m_188500_() * 0.05 - 0.05;
            double x = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            double y = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            double z = (this.f_19853_.f_46441_.m_188500_() - 0.5) * 4.0;
            this.f_19853_.m_7106_((ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, dx, dy, dz);
        }
    }
}

