/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.skill;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class FusionistProjectile
extends TensuraProjectile {
    public FusionistProjectile(EntityType<? extends FusionistProjectile> entityType, Level level) {
        super(entityType, level);
        this.setSize(0.25f);
    }

    public FusionistProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.FUSIONIST_PROJECTILE.get()), levelIn);
        this.m_5602_((Entity)shooter);
        this.setSize(0.25f);
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("minecraft:textures/block/cobblestone.png")};
    }

    @Override
    public void setPosAndShoot(LivingEntity entity) {
        this.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_(), 0.0));
        this.shootFromRot(entity.m_20154_());
    }

    @Override
    public void explosion(double x, double y, double z) {
        if (this.getExplosionRadius() <= 0.0f) {
            return;
        }
        super.explosion(x, y, z);
        this.m_146870_();
    }

    @Override
    protected void dealDamage(Entity target) {
        Entity entity = this.m_37282_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(DamageSource.m_19344_((Player)player), this.getMpCost(), this.getSkill()), 0.0f);
        }
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_11913_);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123813_, x, y, z, 1, 0.12, 0.12, 0.12, 0.15, false);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123747_, x, y, z, 3, 0.5, 0.5, 0.5, 0.1, false);
    }

    @Override
    public void flyingParticles() {
    }
}

