/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.projectile;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraIndirectEntityDamageSource;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpatialArrowProjectile
extends TensuraProjectile {
    public SpatialArrowProjectile(EntityType<? extends SpatialArrowProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SpatialArrowProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.SPATIAL_ARROW.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/energy_arrow.png")};
    }

    @Override
    public boolean piercingBlock() {
        return true;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    protected void hitEntity(Entity entity) {
        if (entity == this.m_37282_()) {
            return;
        }
        super.hitEntity(entity);
    }

    @Override
    protected void dealDamage(Entity target) {
        DamageSource damageSource = new TensuraIndirectEntityDamageSource("arrow", (Entity)this, this.m_37282_()).setSpatial().m_19366_();
        if (this.damage > 0.0f && target.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(damageSource, this.getMpCost(), this.getSkill()), this.getDamage())) {
            target.f_19802_ = 0;
        }
    }

    @Override
    protected void playHitSound(SoundEvent sound, HitResult hitresult) {
        if (hitresult.m_6662_().equals((Object)HitResult.Type.ENTITY)) {
            super.playHitSound(sound, hitresult);
        }
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123808_, x, y, z, 15, 0.1, 0.1, 0.1, 0.1, true);
    }

    @Override
    public void flyingParticles() {
        Vec3 vec3 = this.m_20182_().m_82546_(this.m_20184_().m_82490_(2.0));
        for (int i = 0; i < 2; ++i) {
            Vec3 random = this.vec3Random().m_82490_((double)0.1f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123808_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, random.f_82479_, random.f_82480_, random.f_82481_);
        }
    }
}

