/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.projectile;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class AuraBulletProjectile
extends TensuraProjectile {
    private static final EntityDataAccessor<Integer> COLOR_ID = SynchedEntityData.m_135353_(AuraBulletProjectile.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public AuraBulletProjectile(EntityType<? extends AuraBulletProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public AuraBulletProjectile(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.AURA_BULLET.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage > 0.0f) {
            target.f_19802_ = 0;
            target.m_6469_(TensuraDamageSources.auraBullet(this, this.m_37282_(), this.getSkill(), this.getApCost()), this.damage);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR_ID, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Color", this.getColor());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(COLOR_ID, (Object)pCompound.m_128451_("Color"));
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR_ID);
    }

    public AuraColor getAuraColor() {
        return AuraColor.byId((Integer)this.f_19804_.m_135370_(COLOR_ID));
    }

    public void setColor(AuraColor color) {
        this.f_19804_.m_135381_(COLOR_ID, (Object)(color.getId() & 0xFF));
    }

    public AuraColor getColorBySize(float size) {
        if ((double)size <= 2.5) {
            return AuraColor.BLUE;
        }
        if ((double)size <= 4.5) {
            return AuraColor.PURPLE;
        }
        if ((double)size <= 6.5) {
            return AuraColor.YELLOW;
        }
        if ((double)size <= 8.5) {
            return AuraColor.PINK;
        }
        return AuraColor.RED;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    protected boolean shouldGrief() {
        return false;
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/aura_bullet/" + AuraColor.byId(this.getColor()).getName() + "_aura_bullet.png")};
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123747_, x, y, z, 5, 0.1, 0.1, 0.1, 0.25, true);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123762_, x, y, z, 5, 0.1, 0.1, 0.1, 0.25, true);
    }

    @Override
    public void flyingParticles() {
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_11892_);
    }

    public static enum AuraColor {
        BLUE(0, "blue"),
        PURPLE(1, "purple"),
        YELLOW(2, "yellow"),
        PINK(3, "pink"),
        RED(4, "red");

        private static final AuraColor[] BY_ID;
        private final int id;
        private final String name;

        private AuraColor(int id, String location) {
            this.id = id;
            this.name = location;
        }

        public static AuraColor byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        static {
            BY_ID = (AuraColor[])Arrays.stream(AuraColor.values()).sorted(Comparator.comparingInt(AuraColor::getId)).toArray(AuraColor[]::new);
        }
    }
}

