/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.misc;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.CharybdisEntity;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.StoneShotProjectile;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TempestScaleEntity
extends TensuraProjectile {
    @Nullable
    private LivingEntity target;

    public TempestScaleEntity(EntityType<? extends TempestScaleEntity> entityType, Level level) {
        super(entityType, level);
    }

    public TempestScaleEntity(Level levelIn, LivingEntity shooter) {
        super((EntityType<? extends Projectile>)((EntityType)TensuraEntityTypes.TEMPEST_SCALE.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public boolean shouldDiscardInWater() {
        return false;
    }

    @Override
    public boolean shouldDiscardInLava() {
        return false;
    }

    public void setTarget(@Nullable LivingEntity pTarget) {
        this.target = pTarget;
    }

    @Override
    protected boolean m_5603_(Entity target) {
        if (this.m_37282_() != null && (this.m_37282_().m_7307_(target) || target.m_7307_(this.m_37282_()))) {
            return false;
        }
        return super.m_5603_(target);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Entity entity = this.m_37282_();
        if (entity instanceof CharybdisEntity) {
            CharybdisEntity charybdis = (CharybdisEntity)entity;
            if (this.getTarget() == null) {
                List<LivingEntity> list = this.getTargetList(charybdis);
                if (!list.isEmpty()) {
                    this.setTarget(list.get(this.f_19796_.m_188503_(list.size())));
                }
            } else {
                this.homing((Entity)this.getTarget());
            }
        }
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) && this.f_19796_.m_188503_(10) == 1) {
            SkillHelper.launchBlock((Entity)this, this.m_20182_(), 2, 1, 0.5f, 0.2f, blockState -> {
                if (this.f_19796_.m_188503_(3) != 1) {
                    return false;
                }
                return blockState.m_204336_(TensuraTags.Blocks.EARTH_DOMINATING);
            }, blockPos -> true);
        }
        super.m_8060_(blockHitResult);
    }

    @Override
    protected void hitEntity(Entity entity) {
        super.hitEntity(entity);
        if (entity instanceof LivingEntity) {
            LivingEntity pLivingEntity = (LivingEntity)entity;
            StoneShotProjectile.breakTargetArmor(pLivingEntity, 10);
        }
        if (!entity.m_6084_() && this.f_19796_.m_188503_(10) == 1) {
            this.m_19998_((ItemLike)TensuraMobDropItems.CHARYBDIS_SCALE.get());
        }
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage <= 0.0f) {
            return;
        }
        target.m_6469_(TensuraDamageSources.tempestScale(this, this.m_37282_()), this.damage);
    }

    private List<LivingEntity> getTargetList(CharybdisEntity charybdis) {
        AABB box = charybdis.m_20191_().m_82386_(0.0, -25.0, 0.0).m_82400_(128.0);
        return this.m_9236_().m_6443_(LivingEntity.class, box, entity -> {
            if (entity == this.m_37282_()) {
                return false;
            }
            if (charybdis.m_7307_((Entity)entity)) {
                return false;
            }
            if (charybdis.shouldAttackPlayer((LivingEntity)entity)) {
                return true;
            }
            return charybdis.shouldAttack((LivingEntity)entity);
        });
    }

    private void homing(Entity target) {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        double motionX = this.m_20184_().f_82479_;
        double motionY = this.m_20184_().f_82480_;
        double motionZ = this.m_20184_().f_82481_;
        Vec3 targetVector = new Vec3(target.m_20185_() - posX, target.m_20186_() + (double)(target.m_20206_() / 2.0f) - posY, target.m_20189_() - posZ);
        targetVector = targetVector.m_82541_();
        double weight = 0.8;
        motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.f_82479_;
        motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.f_82480_;
        motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.f_82481_;
        this.m_6034_(posX += motionX, posY += motionY, posZ += motionZ);
        this.m_20334_(motionX, motionY, motionZ);
        if (target.m_20270_((Entity)this) < 3.0f && target != this.m_37282_()) {
            this.m_5790_(new EntityHitResult(target));
        }
    }

    @Override
    public Optional<SoundEvent> hitSound() {
        return Optional.of(SoundEvents.f_12514_);
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123808_, x, y, z, 1, 0.12, 0.12, 0.12, 0.15, false);
    }

    @Override
    public void flyingParticles() {
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }
}

