/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.breath;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.entity.magic.breath.BreathEntity;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import com.github.manasmods.tensura.world.TensuraGameRules;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WindBreathProjectile
extends BreathEntity {
    public WindBreathProjectile(EntityType<? extends WindBreathProjectile> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
    }

    public WindBreathProjectile(Level level, LivingEntity entity) {
        this((EntityType<? extends WindBreathProjectile>)((EntityType)TensuraEntityTypes.WIND_BREATH.get()), level);
        this.m_5602_((Entity)entity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            this.removeFire();
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity) {
            entity.m_6469_((DamageSource)DamageSourceHelper.addSkillAndCost(TensuraDamageSources.windBreath(this, this.m_37282_()), this.getMpCost(), this.getSkill()), this.getDamage());
        }
        if (entity.m_6060_()) {
            entity.m_20095_();
        }
        if (this.m_37282_() != null) {
            SkillHelper.pushBackFromPos(new BlockPos(this.m_37282_().m_146892_()), entity, 0.5f);
        }
    }

    public void removeFire() {
        if (this.m_37282_() == null) {
            return;
        }
        if (!TensuraGameRules.canSkillGrief(this.m_9236_())) {
            return;
        }
        float range = 0.2617994f;
        for (int i = 0; i < 3; ++i) {
            SkillGriefEvent.Pre preGrief;
            Vec3 cast = this.m_37282_().m_20154_().m_82541_().m_82496_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range).m_82524_(this.m_9236_().f_46441_.m_188501_() * range * 2.0f - range);
            BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(this.m_37282_().m_146892_(), this.m_37282_().m_146892_().m_82549_(cast.m_82490_((double)this.getLength())), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (hitResult.m_6662_() != HitResult.Type.BLOCK) continue;
            Vec3 pos = hitResult.m_82450_().m_82546_(cast.m_82490_(0.5));
            BlockPos blockPos = new BlockPos(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (!this.m_9236_().m_8055_(blockPos).m_204336_(BlockTags.f_13076_) || MinecraftForge.EVENT_BUS.post((Event)(preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), blockPos)))) continue;
            this.m_9236_().m_7471_(blockPos, false);
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), blockPos));
        }
    }

    @Override
    public void spawnParticle() {
        Entity entity = this.m_37282_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity owner = (LivingEntity)entity;
        Vec3 rotation = owner.m_20154_().m_82541_();
        Vec3 pos = owner.m_20182_().m_82549_(rotation.m_82490_(1.6));
        double x = pos.f_82479_;
        double y = pos.f_82480_ + (double)(owner.m_20192_() * 0.9f);
        double z = pos.f_82481_;
        double speed = owner.m_217043_().m_188500_() * 0.35 + 0.35;
        for (int i = 0; i < 20; ++i) {
            double ox = Math.random() * 0.3 - 0.15;
            double oy = Math.random() * 0.3 - 0.15;
            double oz = Math.random() * 0.3 - 0.15;
            Vec3 randomVec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_();
            Vec3 result = rotation.m_82490_(3.0).m_82549_(randomVec).m_82541_().m_82490_(speed);
            owner.m_9236_().m_7106_((ParticleOptions)(Math.random() < 0.75 ? ParticleTypes.f_123796_ : (ParticleOptions)TensuraParticles.SMALL_GUST.get()), x + ox, y + oy, z + oz, result.f_82479_, result.f_82480_, result.f_82481_);
        }
    }
}

