/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.breath;

import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.tensura.entity.magic.breath.BreathPart;
import com.github.manasmods.tensura.entity.magic.breath.PredatorMistProjectile;
import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.NotNull;

public class BreathEntity
extends Projectile {
    private static final EntityDataAccessor<Float> LENGTH = SynchedEntityData.m_135353_(BreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(BreathEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected double mpCost = 0.0;
    protected float damage = 0.0f;
    protected ManasSkillInstance skill = null;
    protected int age;
    protected float prevLength = 0.0f;
    public BreathPart[] parts = new BreathPart[]{new BreathPart(this, "Breath 1", 1.0f, 1.0f), new BreathPart(this, "Breath 2", 2.0f, 1.5f), new BreathPart(this, "Breath 3", 3.0f, 2.0f), new BreathPart(this, "Breath 4", 4.0f, 2.5f)};

    public BreathEntity(EntityType<? extends BreathEntity> entityType, Level level, LivingEntity entity) {
        this(entityType, level);
        this.m_5602_((Entity)entity);
    }

    public BreathEntity(EntityType<? extends BreathEntity> entityType, Level level) {
        super(entityType, level);
        this.m_20242_(true);
        this.f_19850_ = false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LENGTH, (Object)Float.valueOf(10.0f));
        this.f_19804_.m_135372_(LIFE, (Object)5);
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128347_("MPCost", this.getMpCost());
        pCompound.m_128350_("Damage", this.getDamage());
        pCompound.m_128350_("Length", this.getLength());
        pCompound.m_128405_("Life", this.getLife());
        if (this.skill != null) {
            pCompound.m_128365_("skill", (Tag)this.skill.toNBT());
        }
    }

    protected void m_7378_(@NotNull CompoundTag pCompound) {
        Tag tag;
        super.m_7378_(pCompound);
        this.setMpCost(pCompound.m_128459_("MPCost"));
        this.setDamage(pCompound.m_128457_("Damage"));
        this.f_19804_.m_135381_(LENGTH, (Object)Float.valueOf(pCompound.m_128457_("Length")));
        this.f_19804_.m_135381_(LIFE, (Object)pCompound.m_128451_("Life"));
        if (pCompound.m_128441_("skill") && (tag = pCompound.m_128423_("skill")) instanceof CompoundTag) {
            CompoundTag tag2 = (CompoundTag)tag;
            this.skill = ManasSkillInstance.fromNBT((CompoundTag)tag2);
        }
    }

    public float getLength() {
        return ((Float)this.f_19804_.m_135370_(LENGTH)).floatValue();
    }

    public void setLength(float length) {
        this.f_19804_.m_135381_(LENGTH, (Object)Float.valueOf(length));
        this.buildParts();
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int life) {
        this.f_19804_.m_135381_(LIFE, (Object)life);
    }

    public void increaseLife(int life) {
        this.setLife(Math.min(this.getLife() + life, 100));
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    public void buildParts() {
        if (this.getLength() <= 0.0f) {
            return;
        }
        float f = this.getLength();
        int l = 1;
        while (f > 0.0f) {
            f -= (float)l;
            ++l;
        }
        BreathPart[] temp = new BreathPart[l - 1];
        float length = this.getLength();
        int i = 1;
        while (length > 0.0f) {
            float partLength = i;
            if (length < (float)i) {
                partLength = Math.max(length, 2.0f);
            }
            length -= (float)i;
            temp[i - 1] = new BreathPart(this, "part" + i, partLength, 0.5f + (float)i * 0.5f);
            ++i;
        }
        this.parts = temp;
    }

    protected static boolean hasLineOfSight(Entity source, Entity target) {
        Vec3 sourceEye = new Vec3(source.m_20185_(), source.m_20186_() + (double)(source.m_20206_() / 2.0f), source.m_20189_());
        Vec3 targetEye = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_());
        return source.m_9236_().m_45547_(new ClipContext(sourceEye, targetEye, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source)).m_6662_() == HitResult.Type.MISS;
    }

    protected Set<Entity> getPartCollision() {
        ArrayList list = new ArrayList();
        for (BreathPart entity : this.parts) {
            list.addAll(this.m_9236_().m_45933_((Entity)entity, entity.m_20191_()));
        }
        return list.stream().filter(this::canCollide).collect(Collectors.toSet());
    }

    protected boolean canCollide(Entity entity) {
        Entity owner = this.m_37282_();
        if (owner != null) {
            if (entity == owner) {
                return false;
            }
            if (!BreathEntity.hasLineOfSight((Entity)this, entity)) {
                return false;
            }
            Entity vehicle = entity.m_20202_();
            if (entity == vehicle) {
                Mob mob;
                return vehicle instanceof Mob && (mob = (Mob)vehicle).m_5448_() == owner;
            }
            if (owner.m_20197_().contains(entity)) {
                Mob mob;
                return entity instanceof Mob && (mob = (Mob)entity).m_5448_() == owner;
            }
        }
        return BreathEntity.hasLineOfSight((Entity)this, entity);
    }

    public void m_20234_(int id) {
        super.m_20234_(id);
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i] == null) continue;
            this.parts[i].m_20234_(id + i + 1);
        }
    }

    public void m_8119_() {
        Entity owner;
        super.m_8119_();
        if (this.prevLength != this.getLength()) {
            this.prevLength = this.getLength();
            this.buildParts();
        }
        if ((owner = this.m_37282_()) != null) {
            Vec3 eye = owner.m_20299_(1.0f).m_82492_(0.0, 0.8, 0.0);
            this.m_146884_(eye);
            this.m_146926_(owner.m_146909_());
            this.m_146922_(owner.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
            double distance = 1.0;
            for (BreathPart part : this.parts) {
                if (part == null) continue;
                Vec3 newVector = eye.m_82549_(owner.m_20252_(0.5f).m_82542_(distance += (double)(part.m_6972_(null).f_20377_ * 4.0f / 5.0f), distance, distance));
                part.m_146884_(newVector);
                part.m_20256_(eye.m_82549_(owner.m_20252_(1.0f).m_82542_(distance, distance, distance)));
                Vec3 vec3 = new Vec3(part.m_20185_(), part.m_20186_(), part.m_20189_());
                part.f_19854_ = vec3.f_82479_;
                part.f_19855_ = vec3.f_82480_;
                part.f_19856_ = vec3.f_82481_;
                part.f_19790_ = vec3.f_82479_;
                part.f_19791_ = vec3.f_82480_;
                part.f_19792_ = vec3.f_82481_;
            }
        }
        if (!this.m_9236_().m_5776_()) {
            for (Entity entity : this.getPartCollision()) {
                this.m_5790_(new EntityHitResult(entity));
            }
        } else {
            this.spawnParticle();
        }
        if (++this.age > this.getLife()) {
            this.m_146870_();
        }
    }

    public void spawnParticle() {
    }

    public static void spawnBreathEntity(EntityType<? extends BreathEntity> entityType, LivingEntity owner, ManasSkillInstance instance, double cost) {
        BreathEntity.spawnBreathEntity(entityType, owner, instance, 0.0f, cost);
    }

    public static void spawnBreathEntity(EntityType<? extends BreathEntity> entityType, LivingEntity owner, ManasSkillInstance instance, float damage, double cost) {
        CompoundTag tag = instance.getOrCreateTag();
        Level level = owner.m_9236_();
        if (tag.m_128451_("BreathEntity") == 0) {
            BreathEntity breath = (BreathEntity)entityType.m_20615_(level);
            if (breath == null) {
                return;
            }
            breath.setDamage(damage);
            breath.m_5602_((Entity)owner);
            breath.m_146884_(owner.m_20182_().m_82520_(0.0, (double)(owner.m_20206_() / 2.0f), 0.0));
            breath.setMpCost(cost);
            breath.setSkill(instance);
            owner.m_9236_().m_7967_((Entity)breath);
            tag.m_128405_("BreathEntity", breath.m_19879_());
        } else {
            Entity entity = owner.m_9236_().m_6815_(tag.m_128451_("BreathEntity"));
            if (!(entity instanceof BreathEntity)) {
                tag.m_128405_("BreathEntity", 0);
            } else {
                BreathEntity breath = (BreathEntity)entity;
                breath.increaseLife(1);
            }
        }
        instance.markDirty();
    }

    public static void spawnPredationMist(EntityType<? extends PredatorMistProjectile> entityType, LivingEntity owner, ManasSkillInstance instance, double cost, float length, int blockMode, boolean projectile) {
        CompoundTag tag = instance.getOrCreateTag();
        Level level = owner.m_9236_();
        if (tag.m_128451_("BreathEntity") == 0) {
            PredatorMistProjectile breath = (PredatorMistProjectile)entityType.m_20615_(level);
            if (breath == null) {
                return;
            }
            breath.m_5602_((Entity)owner);
            breath.setLength(length);
            breath.setBlockMode(blockMode);
            breath.setConsumeProjectile(projectile);
            breath.m_146884_(owner.m_20182_().m_82520_(0.0, (double)(owner.m_20206_() / 2.0f), 0.0));
            breath.setMpCost(cost);
            breath.setSkill(instance);
            owner.m_9236_().m_7967_((Entity)breath);
            tag.m_128405_("BreathEntity", breath.m_19879_());
        } else {
            Entity entity = owner.m_9236_().m_6815_(tag.m_128451_("BreathEntity"));
            if (!(entity instanceof PredatorMistProjectile)) {
                tag.m_128405_("BreathEntity", 0);
            } else {
                PredatorMistProjectile breath = (PredatorMistProjectile)entity;
                breath.increaseLife(1);
                breath.setLength(length);
            }
        }
        instance.markDirty();
    }

    public double getMpCost() {
        return this.mpCost;
    }

    public void setMpCost(double mpCost) {
        this.mpCost = mpCost;
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public ManasSkillInstance getSkill() {
        return this.skill;
    }

    public void setSkill(ManasSkillInstance skill) {
        this.skill = skill;
    }
}

