/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.beam;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class SolarBeamProjectile
extends BeamProjectile {
    public SolarBeamProjectile(EntityType<? extends SolarBeamProjectile> entityType, Level level) {
        super((EntityType<? extends BeamProjectile>)entityType, level);
        this.beamColorAndSize.put(new Color(252, 186, 3, 255), Float.valueOf(0.33f));
        this.beamColorAndSize.put(new Color(252, 186, 3, 120), Float.valueOf(0.66f));
        this.beamColorAndSize.put(new Color(255, 255, 255, 30), Float.valueOf(1.0f));
    }

    public SolarBeamProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends SolarBeamProjectile>)((EntityType)TensuraEntityTypes.SOLAR_BEAM.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage <= 0.0f || target instanceof ItemEntity) {
            return;
        }
        DamageSource damagesource = TensuraDamageSources.indirectElementalAttack("tensura.light_attack", (Entity)this, this.m_37282_(), this.getMpCost(), this.getSkill(), true);
        if (target.m_6469_(damagesource, this.damage)) {
            TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)TensuraParticles.SOLAR_FLASH.get());
        }
    }

    @Override
    protected void interactBlocks(BlockPos pos) {
        SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), pos);
        if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
            return;
        }
        if (this.shouldBreak(pos) && this.f_19853_.m_7471_(pos, false)) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 5, 0.04, 0.06, 0.04, 0.05);
        }
        this.placeFires(pos);
        MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), pos));
    }

    private boolean shouldBreak(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (state.m_204336_(TensuraTags.Blocks.SKILL_SMELT_EASY)) {
            return true;
        }
        if (!state.m_60767_().m_76336_()) {
            return false;
        }
        if (state.m_60767_().equals(Material.f_76309_)) {
            return false;
        }
        return !this.f_19853_.m_6425_(pos).m_76170_();
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        Vec3 end = new Vec3(x, y, z);
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, end, (ParticleOptions)TensuraParticles.SOLAR_FLASH.get(), this.getSize(), 1);
    }
}

