/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.beam;

import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.awt.Color;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ElectroBlastProjectile
extends BeamProjectile {
    public ElectroBlastProjectile(EntityType<? extends ElectroBlastProjectile> entityType, Level level) {
        super((EntityType<? extends BeamProjectile>)entityType, level);
        this.beamColorAndSize.put(new Color(2, 218, 255, 200), Float.valueOf(0.2f));
        this.beamColorAndSize.put(new Color(67, 48, 243, 100), Float.valueOf(0.4f));
        this.beamColorAndSize.put(new Color(191, 183, 255, 30), Float.valueOf(0.6f));
    }

    public ElectroBlastProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends ElectroBlastProjectile>)((EntityType)TensuraEntityTypes.ELECTRO_BLAST.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    public ResourceLocation[] getTextureLocation() {
        return new ResourceLocation[]{new ResourceLocation("tensura", "textures/entity/projectiles/beam/electric_beam.png")};
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage <= 0.0f || target instanceof ItemEntity) {
            return;
        }
        DamageSource damagesource = TensuraDamageSources.indirectElementalAttack("tensura.wind_attack", (Entity)this, this.m_37282_(), this.getMpCost(), this.getSkill(), true);
        if (target.m_6469_(damagesource, this.getDamage())) {
            TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)TensuraParticles.LIGHTNING_EFFECT.get());
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                living.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 600, 1, false, false, false));
            }
        }
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        Vec3 end = new Vec3(x, y, z);
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, end, (ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get(), this.getSize(), 3);
    }

    @Override
    public void rayParticles(Vec3 pos, int i) {
        if (this.f_19797_ % this.f_19796_.m_216339_(10, 16) != 0) {
            return;
        }
        TensuraParticleHelper.addParticlesAroundPos(this.f_19796_, this.f_19853_, pos, (ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get(), this.getVisualSize(), 1);
    }
}

