/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.magic.beam;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.magic.beam.BeamProjectile;
import com.github.manasmods.tensura.event.SkillGriefEvent;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class DarknessCannonProjectile
extends BeamProjectile {
    public DarknessCannonProjectile(EntityType<? extends DarknessCannonProjectile> entityType, Level level) {
        super((EntityType<? extends BeamProjectile>)entityType, level);
        this.beamColorAndSize.put(new Color(255, 0, 0, 200), Float.valueOf(0.2f));
        this.beamColorAndSize.put(new Color(0, 0, 0, 100), Float.valueOf(0.4f));
        this.beamColorAndSize.put(new Color(170, 9, 0, 30), Float.valueOf(0.6f));
    }

    public DarknessCannonProjectile(Level levelIn, LivingEntity shooter) {
        this((EntityType<? extends DarknessCannonProjectile>)((EntityType)TensuraEntityTypes.DARKNESS_CANNON.get()), levelIn);
        this.m_5602_((Entity)shooter);
    }

    @Override
    protected void dealDamage(Entity target) {
        if (this.damage <= 0.0f || target instanceof ItemEntity) {
            return;
        }
        DamageSource damagesource = TensuraDamageSources.indirectElementalAttack("tensura.dark_attack", (Entity)this, this.m_37282_(), this.getMpCost(), this.getSkill(), true);
        if (target.m_6469_(damagesource, this.getDamage())) {
            TensuraParticleHelper.addServerParticlesAroundSelf(target, (ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get());
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 600, 1, false, false, false));
                living.m_7292_(new MobEffectInstance(MobEffects.f_19612_, 600, 1, false, false, false));
                int insanityLevel = 0;
                MobEffectInstance insanity = living.m_21124_((MobEffect)TensuraMobEffects.INSANITY.get());
                if (insanity != null) {
                    insanityLevel = insanity.m_19564_() + 1;
                }
                SkillHelper.checkThenAddEffectSource(living, this.m_37282_(), new MobEffectInstance((MobEffect)TensuraMobEffects.INSANITY.get(), 200, insanityLevel, false, false, false));
                for (EquipmentSlot slot : EquipmentSlot.values()) {
                    if (slot.m_20743_().equals((Object)EquipmentSlot.Type.HAND)) continue;
                    ItemStack slotStack = living.m_6844_(slot);
                    slotStack.m_41622_(1250, living, livingEntity -> livingEntity.m_21166_(slot));
                }
            }
        }
    }

    @Override
    protected void interactBlocks(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        if (state.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY) || state.m_60767_().m_76336_() && !this.f_19853_.m_6425_(pos).m_76170_()) {
            SkillGriefEvent.Pre preGrief = new SkillGriefEvent.Pre(this.m_37282_(), this.getSkill(), pos);
            if (MinecraftForge.EVENT_BUS.post((Event)preGrief)) {
                return;
            }
            this.f_19853_.m_46961_(pos, false);
            MinecraftForge.EVENT_BUS.post((Event)new SkillGriefEvent.Post(this.m_37282_(), this.getSkill(), pos));
        }
    }

    @Override
    public void hitParticles(double x, double y, double z) {
        if (this.f_19797_ % 3 != 0) {
            return;
        }
        Vec3 end = new Vec3(x, y, z);
        TensuraParticleHelper.addParticlesAroundPos(this.m_9236_().f_46441_, this.f_19853_, end, (ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get(), this.getSize(), 3);
    }

    @Override
    public void rayParticles(Vec3 pos, int i) {
        if (this.f_19797_ % this.f_19796_.m_216339_(10, 16) != 0) {
            return;
        }
        TensuraParticleHelper.addParticlesAroundPos(this.f_19796_, this.f_19853_, pos, (ParticleOptions)TensuraParticles.DARK_RED_LIGHTNING_SPARK.get(), this.getVisualSize(), 1);
    }
}

