/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.entity.AkashEntity;
import com.github.manasmods.tensura.entity.IfritEntity;
import com.github.manasmods.tensura.entity.SylphideEntity;
import com.github.manasmods.tensura.entity.UndineEntity;
import com.github.manasmods.tensura.entity.WarGnomeEntity;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.entity.magic.field.Hellfire;
import com.github.manasmods.tensura.entity.magic.projectile.FireBallProjectile;
import com.github.manasmods.tensura.entity.magic.skill.HeatSphereProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraArmorItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.PacketDistributor;

public class ShizuEntity
extends OtherworlderEntity {
    private static final EntityDataAccessor<Integer> TRANSFORM_TICK = SynchedEntityData.m_135353_(ShizuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DYING = SynchedEntityData.m_135353_(ShizuEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public ShizuEntity(EntityType<? extends ShizuEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OtherworlderEntity>)pEntityType, pLevel);
        this.f_19793_ = 2.0f;
        this.f_21365_ = new TransformLookControl();
        this.f_21342_ = new TransformMoveControl();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.2f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<ShizuEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new ShizuAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, ShizuEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, this::shouldAttackPlayer));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TRANSFORM_TICK, (Object)0);
        this.f_19804_.m_135372_(DYING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("TransformTick", this.getTransformTick());
        compound.m_128379_("Dying", this.isDying());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setTransformTick(compound.m_128451_("TransformTick"));
        this.setDying(compound.m_128471_("Dying"));
    }

    public int getTransformTick() {
        return (Integer)this.f_19804_.m_135370_(TRANSFORM_TICK);
    }

    public void setTransformTick(int tick) {
        this.f_19804_.m_135381_(TRANSFORM_TICK, (Object)tick);
    }

    public boolean isDying() {
        return (Boolean)this.f_19804_.m_135370_(DYING);
    }

    public void setDying(boolean dying) {
        this.f_19804_.m_135381_(DYING, (Object)dying);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/shizu.png");
    }

    @Override
    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.DEGENERATE.get());
    }

    public boolean m_6060_() {
        return TensuraEffectsCapability.hasSyncedEffect((LivingEntity)this, (MobEffect)TensuraMobEffects.BLACK_BURN.get());
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.isDying()) {
            if (this.f_19797_ % 100 == 0) {
                this.m_6469_(TensuraDamageSources.OUT_OF_ENERGY, 5.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123798_);
            }
            return;
        }
        if (this.getTransformTick() >= 100) {
            return;
        }
        if (this.m_21223_() > this.m_21233_() / 3.0f) {
            return;
        }
        this.setSleeping(false);
        this.setTransformTick(this.getTransformTick() + 1);
        this.m_21573_().m_26573_();
        if (this.f_19797_ % 5 == 0) {
            this.combust(false);
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        if (this.getTransformTick() >= 100) {
            this.summonIfrit(this.m_5448_());
        }
    }

    @Override
    protected void updatePoses() {
        if (this.isDying()) {
            this.m_20124_(Pose.SLEEPING);
        } else if (this.getTransformTick() > 1) {
            this.m_20124_(Pose.STANDING);
        } else {
            super.updatePoses();
        }
    }

    @Override
    protected void sleepHandler() {
        if (this.isDying()) {
            return;
        }
        if (this.getTransformTick() > 1) {
            return;
        }
        super.sleepHandler();
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity;
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && (entity = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity source = (LivingEntity)entity;
            if (!source.m_6084_()) {
                return true;
            }
            if (source instanceof Player && ((player = (Player)source).m_7500_() || player.m_5833_())) {
                return true;
            }
            source.m_7311_(Math.max(200, source.m_20094_()));
        }
        return hurt;
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        if (super.m_7327_(pEntity) && pEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)pEntity;
            target.m_7311_(Math.max(200, target.m_20094_()));
            return true;
        }
        return false;
    }

    private void fireBallShoot(boolean heatWave) {
        TensuraProjectile fireBall;
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        this.m_21011_(InteractionHand.OFF_HAND, true);
        if (heatWave) {
            fireBall = new HeatSphereProjectile(this.f_19853_, (LivingEntity)this);
            fireBall.setEffectRange(2.5f);
            fireBall.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.HEAT_WAVE.get()).orElse(null));
        } else {
            fireBall = new FireBallProjectile(this.f_19853_, (LivingEntity)this);
            fireBall.setSpiritAttack(true);
            fireBall.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SpiritualMagics.FIRE_BOLT.get()).orElse(null));
        }
        fireBall.setMpCost(100.0);
        fireBall.setSpeed(1.2f);
        fireBall.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 2.0));
        fireBall.setBurnTicks(20);
        fireBall.m_20242_(true);
        fireBall.setPosAndShoot((LivingEntity)this);
        this.f_19853_.m_7967_((Entity)fireBall);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    private void hellFire() {
        Vec3 pos;
        LivingEntity target = this.m_5448_();
        if (target != null) {
            pos = target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0);
        } else {
            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(this.f_19853_, (Entity)this, ClipContext.Fluid.NONE, 15.0);
            pos = result.m_82450_().m_82520_(0.0, 0.5, 0.0);
        }
        Hellfire sphere = new Hellfire(this.m_9236_(), (Entity)this);
        sphere.setDamage(250.0f);
        sphere.setMpCost(10000.0);
        sphere.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SpiritualMagics.HELLFIRE.get()).orElse(null));
        sphere.setLife(60);
        sphere.setRadius(2.5f);
        sphere.m_6034_(pos.f_82479_, pos.f_82480_ - (double)sphere.getRadius(), pos.f_82481_);
        this.m_9236_().m_7967_((Entity)sphere);
        this.m_21011_(InteractionHand.OFF_HAND, true);
        this.m_9236_().m_6263_(null, sphere.m_20185_(), sphere.m_20186_(), sphere.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)((SimpleParticleType)TensuraParticles.RED_FIRE.get()), this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), 10, 0.08, 0.08, 0.08, 0.15);
        TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> sphere), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:fire_sphere_5x5"), sphere.m_19879_(), 0.0, sphere.getRadius(), 0.0, false));
    }

    private void combust(boolean constant) {
        if (constant) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.RED_FIRE.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 5.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && entity != this.m_21826_() && entity != this);
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity target : list) {
            target.m_6469_(TensuraDamageSources.heatWave((Entity)this), (float)this.m_21133_(Attributes.f_22281_));
            target.m_20334_(0.0, 0.1, 0.0);
            SkillHelper.knockBack((LivingEntity)this, target, constant ? 1.0f : 2.0f);
        }
    }

    private void summonIfrit(@Nullable LivingEntity target) {
        TensuraEPCapability.setSkippingEPDrop((LivingEntity)this, true);
        Mob entity = this.getSpiritSummoning();
        entity.m_146884_(this.m_20182_());
        entity.m_6710_(target);
        this.m_9236_().m_7967_((Entity)entity);
        this.m_146870_();
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.5, true);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 0.5f, 0.4f + (this.f_19796_.m_188501_() * 0.4f + 0.8f));
    }

    private Mob getSpiritSummoning() {
        if (SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.shizuChance.get(), this.f_19796_)) {
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207603_)) {
                UndineEntity entity = new UndineEntity((EntityType<? extends UndineEntity>)((EntityType)TensuraEntityTypes.UNDINE.get()), this.f_19853_);
                entity.setShizuNBT(this.serializeNBT());
                entity.setMiscAnimation(7);
                return entity;
            }
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_PEAK)) {
                SylphideEntity entity = new SylphideEntity((EntityType<? extends SylphideEntity>)((EntityType)TensuraEntityTypes.SYLPHIDE.get()), this.f_19853_);
                entity.setShizuNBT(this.serializeNBT());
                entity.setMiscAnimation(7);
                return entity;
            }
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_215818_)) {
                AkashEntity entity = new AkashEntity((EntityType<? extends AkashEntity>)((EntityType)TensuraEntityTypes.AKASH.get()), this.f_19853_);
                entity.setShizuNBT(this.serializeNBT());
                entity.setMiscAnimation(4);
                return entity;
            }
            if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(Tags.Biomes.IS_CAVE)) {
                WarGnomeEntity entity = new WarGnomeEntity((EntityType<? extends WarGnomeEntity>)((EntityType)TensuraEntityTypes.WAR_GNOME.get()), this.f_19853_);
                entity.setShizuNBT(this.serializeNBT());
                entity.setMiscAnimation(7);
                return entity;
            }
        }
        IfritEntity entity = new IfritEntity((EntityType<? extends IfritEntity>)((EntityType)TensuraEntityTypes.IFRIT.get()), this.f_19853_);
        entity.setShizuNBT(this.serializeNBT());
        entity.setMiscAnimation(7);
        return entity;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        ItemStack mask = new ItemStack((ItemLike)TensuraArmorItems.ANTI_MAGIC_MASK.get());
        this.m_8061_(EquipmentSlot.HEAD, mask);
        this.inventory.m_6836_(0, mask);
        this.inventory.m_6596_();
        ItemStack stack = new ItemStack((ItemLike)TensuraToolItems.PURE_MAGISTEEL_LONG_SWORD.get());
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(4, stack);
        this.inventory.m_6596_();
    }

    @Override
    public void m_6667_(DamageSource source) {
        if (this.getTransformTick() < 100) {
            Entity entity;
            LivingEntity target = this.m_5448_();
            if (target == null && (entity = source.m_7639_()) instanceof LivingEntity) {
                LivingEntity living;
                target = living = (LivingEntity)entity;
            }
            this.summonIfrit(target);
            return;
        }
        super.m_6667_(source);
    }

    public class TransformLookControl
    extends TensuraTamableEntity.SleepLookControl {
        public TransformLookControl() {
            super(ShizuEntity.this);
        }

        @Override
        public void m_8128_() {
            if (ShizuEntity.this.isDying()) {
                return;
            }
            if (ShizuEntity.this.getTransformTick() < 1) {
                super.m_8128_();
            }
        }
    }

    public class TransformMoveControl
    extends TensuraTamableEntity.SleepMoveControl {
        public TransformMoveControl() {
            super(ShizuEntity.this);
        }

        @Override
        public void m_8126_() {
            if (ShizuEntity.this.isDying()) {
                return;
            }
            if (ShizuEntity.this.getTransformTick() < 1) {
                super.m_8126_();
            }
        }
    }

    public class ShizuAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final ShizuEntity entity;

        public ShizuAttackGoal(ShizuEntity entity) {
            super(ShizuEntity.this, (PathfinderMob)entity, 2.0, true);
            this.entity = entity;
        }

        @Override
        public boolean m_8036_() {
            if (this.entity.isDying()) {
                return false;
            }
            if (this.entity.getTransformTick() >= 1) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.entity.isDying()) {
                return false;
            }
            if (this.entity.getTransformTick() >= 1) {
                return false;
            }
            return super.m_8045_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double attackRange;
            double d0 = this.m_6639_(pEnemy);
            int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
            if (randomAttack == 0) {
                return;
            }
            switch (randomAttack) {
                case 4: {
                    double d = d0 + 25.0;
                    break;
                }
                case 3: {
                    double d = d0 + 200.0;
                    break;
                }
                case 2: {
                    double d = d0 + 900.0;
                    break;
                }
                default: {
                    double d = attackRange = d0;
                }
            }
            if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                this.m_25563_();
                switch (randomAttack) {
                    default: {
                        this.entity.m_7327_((Entity)pEnemy);
                        break;
                    }
                    case 2: {
                        this.entity.fireBallShoot(this.entity.m_217043_().m_188503_(5) == 1);
                        break;
                    }
                    case 3: {
                        this.entity.m_21573_().m_26573_();
                        this.entity.hellFire();
                        break;
                    }
                    case 4: {
                        this.entity.m_21573_().m_26573_();
                        this.entity.combust(true);
                    }
                }
                this.entity.m_21011_(InteractionHand.MAIN_HAND, true);
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if (this.entity.f_19796_.m_188503_(5) == 1 && distSqr > this.m_6639_(target) || this.entity.f_19796_.m_188503_(10) == 1) {
                if ((double)this.entity.f_19796_.m_188501_() <= 0.05) {
                    return 3;
                }
                return 2;
            }
            if ((double)this.entity.f_19796_.m_188501_() <= 0.1) {
                return 4;
            }
            return 1;
        }
    }
}

