/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.misc.ThrownItemProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;

public class ShinjiTanimuraEntity
extends OtherworlderEntity {
    public ShinjiTanimuraEntity(EntityType<? extends ShinjiTanimuraEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OtherworlderEntity>)pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<ShinjiTanimuraEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HealerAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, ShinjiTanimuraEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/shinji_tanimura.png");
    }

    @Override
    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.HEALER.get());
    }

    public boolean m_7301_(MobEffectInstance instance) {
        if (instance.m_19544_() == TensuraMobEffects.INFECTION.get()) {
            return false;
        }
        if (instance.m_19544_() == TensuraMobEffects.FATAL_POISON.get()) {
            return false;
        }
        if (instance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_7301_(instance);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_() && this.m_21223_() < this.m_21233_() && this.f_19797_ % 40 == 0 && this.getHealer() != null) {
            this.m_5634_(20.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123750_);
        }
    }

    @Override
    public boolean m_7327_(Entity target) {
        boolean flag = super.m_7327_(target);
        if (flag && this.getHealer() != null) {
            this.applyVirus(target);
        }
        return flag;
    }

    private void throwNeedles() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42001_);
        stack.m_41784_().m_128379_("FakeItem", true);
        if (this.m_5448_() != null) {
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, this.m_5448_().m_146892_());
        }
        ThrownItemProjectile projectile = new ThrownItemProjectile(this.f_19853_, (LivingEntity)this, stack, true, 20.0f);
        projectile.setWeaponDamage(DamageSourceHelper.getMainWeaponDamage((LivingEntity)this, null));
        Vector3f vector3f = new Vector3f(this.m_20252_(1.0f));
        projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        projectile.m_6686_(vector3f.m_122239_(), vector3f.m_122260_(), vector3f.m_122269_(), 2.0f, 0.0f);
        this.m_9236_().m_7967_((Entity)projectile);
        this.m_21011_(InteractionHand.MAIN_HAND, true);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11687_, SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public void applyVirus(Entity entity) {
        if (this.getHealer() == null) {
            return;
        }
        if (this.m_21223_() > this.m_21233_()) {
            return;
        }
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (!target.m_21023_((MobEffect)TensuraMobEffects.INFECTION.get())) {
            SkillHelper.checkThenAddEffectSource(target, (Entity)this, new MobEffectInstance((MobEffect)TensuraMobEffects.INFECTION.get(), 900, 0));
            DamageSourceHelper.markHurt(target, (Entity)this);
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123784_, 1.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)ParticleTypes.f_123784_, 2.0);
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215734_, SoundSource.PLAYERS, 10.0f, 1.0f);
    }

    @Nullable
    private ManasSkillInstance getHealer() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)UniqueSkills.HEALER.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_213945_(this.f_19796_, pDifficulty);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    @Nullable
    public Item getEquipmentForArmorSlot(EquipmentSlot pSlot, int pChance) {
        return switch (pSlot) {
            case EquipmentSlot.HEAD -> {
                if (pChance == 3) {
                    yield Items.f_42468_;
                }
                yield null;
            }
            case EquipmentSlot.CHEST -> {
                if (pChance == 3) {
                    yield Items.f_42469_;
                }
                if (pChance == 1) {
                    yield Items.f_42465_;
                }
                yield null;
            }
            case EquipmentSlot.LEGS -> {
                if (pChance == 3) {
                    yield Items.f_42470_;
                }
                if (pChance == 1) {
                    yield Items.f_42466_;
                }
                yield null;
            }
            case EquipmentSlot.FEET -> {
                if (pChance == 3) {
                    yield Items.f_42471_;
                }
                if (pChance == 1) {
                    yield Items.f_42467_;
                }
                yield null;
            }
            default -> null;
        };
    }

    public class HealerAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final ShinjiTanimuraEntity entity;

        public HealerAttackGoal(ShinjiTanimuraEntity entity) {
            super(ShinjiTanimuraEntity.this, (PathfinderMob)entity, 2.0, true);
            this.entity = entity;
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
            if (randomAttack == 0) {
                return;
            }
            double d = randomAttack == 1 ? d0 : d0 + 900.0;
            if (pDistToEnemySqr <= d && this.m_25564_()) {
                this.m_25563_();
                if (randomAttack == 1) {
                    this.entity.m_7327_((Entity)pEnemy);
                } else {
                    this.entity.throwNeedles();
                }
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if (distSqr > this.m_6639_(target) || this.entity.f_19796_.m_188503_(7) == 2) {
                return 2;
            }
            return 1;
        }
    }
}

