/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.human;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.ITeleportation;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.human.OtherworlderEntity;
import com.github.manasmods.tensura.entity.magic.projectile.SpatialArrowProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.ProjectileImpactEvent;

public class MaiFurukiEntity
extends OtherworlderEntity
implements ITeleportation {
    public MaiFurukiEntity(EntityType<? extends MaiFurukiEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OtherworlderEntity>)pEntityType, pLevel);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<MaiFurukiEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal(this, (PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, MaiFurukiEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, this::shouldAttackPlayer));
        this.f_21346_.m_25352_(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, LivingEntity.class, false, entity -> entity.m_6095_().m_204039_(TensuraTags.EntityTypes.OTHERWORLDER_PREY)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return new ResourceLocation("tensura", "textures/entity/otherworlder/mai_furuki.png");
    }

    @Override
    public List<ManasSkill> getUniqueSkills() {
        return List.of((ManasSkill)UniqueSkills.TRAVELER.get());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (!this.m_6084_()) {
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        if (target.m_20270_((Entity)this) <= 5.0f && this.getTraveler() != null) {
            this.teleportTowards((LivingEntity)this, (Entity)target, 12.0);
        } else if (target.m_20270_((Entity)this) >= 20.0f && this.getTraveler() != null) {
            this.teleportTowards((LivingEntity)this, (Entity)target, 20.0);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float pAmount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.shouldDodge(source)) {
            return false;
        }
        return super.m_6469_(source, pAmount);
    }

    @Override
    public void onProjectileImpact(ProjectileImpactEvent event) {
        AbstractArrow arrow;
        if (event.isCanceled()) {
            return;
        }
        if (this.getTraveler() == null) {
            return;
        }
        Projectile projectile = event.getProjectile();
        if (projectile instanceof AbstractArrow && (arrow = (AbstractArrow)projectile).m_36796_() > 0) {
            return;
        }
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
        if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
            this.teleportTowards((LivingEntity)this, (Entity)this.m_5448_(), 16.0);
        }
        event.setCanceled(true);
    }

    private boolean shouldDodge(DamageSource source) {
        if (this.m_9236_().m_5776_()) {
            return false;
        }
        if (this.getTraveler() == null) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (source.m_19378_()) {
                return false;
            }
            if (!DamageSourceHelper.isPhysicalAttack(source)) {
                return false;
            }
            if ((double)entity2.m_217043_().m_188501_() >= 0.25) {
                return false;
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 2.0f, 1.0f);
            if (!this.m_9236_().m_5776_() && this.m_5448_() != null) {
                this.teleportTowards((LivingEntity)this, (Entity)this.m_5448_(), 12.0);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void performBowAttack(ItemStack weapon, BowItem bow, LivingEntity pTarget, float distance) {
        if (this.getTraveler() == null) {
            super.performBowAttack(weapon, bow, pTarget, distance);
            return;
        }
        if ((double)this.f_19796_.m_188501_() <= 0.3) {
            this.stardustRain(pTarget);
            return;
        }
        SpatialArrowProjectile arrow = new SpatialArrowProjectile(this.m_9236_(), (LivingEntity)this);
        arrow.setLife(50);
        arrow.setDamage((float)this.m_21133_(Attributes.f_22281_));
        arrow.setMpCost(150.0);
        arrow.setSkill(this.getTraveler());
        if (this.m_21223_() < this.m_21233_() / 2.0f) {
            arrow.shootFromBehind((Entity)pTarget, 2.0f, 0.0f);
        } else {
            arrow.m_6034_(this.m_20185_(), this.m_20188_() - 0.1, this.m_20189_());
            double d0 = pTarget.m_20185_() - this.m_20185_();
            double d1 = pTarget.m_20227_(0.3333333333333333) - arrow.m_20186_();
            double d2 = pTarget.m_20189_() - this.m_20189_();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            arrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 0.0f);
        }
        this.m_5496_(SoundEvents.f_11687_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)arrow);
    }

    protected void stardustRain(LivingEntity target) {
        Vec3 pos = target.m_20182_().m_82520_(0.0, (double)target.m_20192_(), 0.0);
        int arrowAmount = 12;
        for (int i = 0; i < arrowAmount; ++i) {
            Vec3 arrowPos = pos.m_82549_(new Vec3(0.0, Math.random() - 0.5, 0.6).m_82541_().m_82490_((double)(target.m_20205_() + 6.0f)).m_82524_(360.0f * (float)i * ((float)Math.PI / 180) / (float)arrowAmount));
            SpatialArrowProjectile arrow = new SpatialArrowProjectile(this.f_19853_, (LivingEntity)this);
            arrow.setSpeed(1.0f);
            arrow.m_146884_(arrowPos);
            arrow.shootFromRot(pos.m_82546_(arrowPos).m_82541_());
            arrow.setSkill(this.getTraveler());
            arrow.setLife(50);
            arrow.setDamage((float)this.m_21133_(Attributes.f_22281_));
            arrow.setMpCost(5000.0f / (float)arrowAmount);
            this.f_19853_.m_7967_((Entity)arrow);
            this.f_19853_.m_6263_(null, arrow.m_20185_(), arrow.m_20186_(), arrow.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Nullable
    private ManasSkillInstance getTraveler() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)UniqueSkills.TRAVELER.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Override
    protected float m_21519_(EquipmentSlot pSlot) {
        if (this.m_21824_()) {
            return 0.0f;
        }
        if (pSlot.equals((Object)EquipmentSlot.MAINHAND)) {
            return 0.05f;
        }
        return super.m_21519_(pSlot);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        ItemStack stack = new ItemStack((ItemLike)TensuraToolItems.LONG_SPIDER_BOW.get());
        stack.m_41714_((Component)Component.m_237113_((String)"Crescent Bow").m_130940_(ChatFormatting.GOLD));
        stack.m_41663_(Enchantments.f_44952_, 1);
        stack.m_41663_(Enchantments.f_44962_, 1);
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(4, stack);
        this.inventory.m_6596_();
    }
}

