/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.projectile;

import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class MagicBoltRenderer
extends EntityRenderer<TensuraProjectile> {
    public static final ModelLayerLocation MAGIC_BOLT = new ModelLayerLocation(new ResourceLocation("tensura", "magic_bolt"), "main");
    private final ModelPart bolt;

    public MagicBoltRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(MAGIC_BOLT);
        this.bolt = modelpart.m_171324_("Bolt");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Ball = partdefinition.m_171599_("Bolt", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-3.0f, -3.0f, -5.3333f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)6.0f, (float)0.3333f));
        PartDefinition fire = Ball.m_171599_("Fire", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-1.3333f));
        fire.m_171599_("fire_1", CubeListBuilder.m_171558_().m_171514_(-16, 16).m_171488_(-6.0f, 0.0f, -8.0f, 24.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)-1.5708f, (float)0.0f));
        fire.m_171599_("fire_2", CubeListBuilder.m_171558_().m_171514_(-16, 16).m_171488_(-6.0f, 0.0f, -8.0f, 24.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)-1.5708f, (float)0.0f));
        fire.m_171599_("fire_3", CubeListBuilder.m_171558_().m_171514_(-16, 0).m_171488_(-6.0f, 0.0f, -8.0f, 24.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)-1.5708f, (float)0.0f));
        fire.m_171599_("fire_4", CubeListBuilder.m_171558_().m_171514_(-16, 0).m_171488_(-6.0f, 0.0f, -8.0f, 24.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)44);
    }

    public void render(TensuraProjectile entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && entity.m_20177_((Player)minecraft.f_91074_)) {
            return;
        }
        poseStack.m_85836_();
        Vec3 motion = entity.m_20184_();
        float xRot = -((float)(Mth.m_14136_((double)motion.m_165924_(), (double)motion.f_82480_) * 57.2957763671875) - 90.0f);
        float yRot = -((float)(Mth.m_14136_((double)motion.f_82481_, (double)motion.f_82479_) * 57.2957763671875) + 90.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(yRot));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(xRot));
        poseStack.m_85841_(entity.getVisualSize(), entity.getVisualSize(), entity.getVisualSize());
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.bolt.m_104301_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(TensuraProjectile instance) {
        ResourceLocation[] resourceLocations = instance.getTextureLocation();
        if (resourceLocations == null) {
            return new ResourceLocation("tensura", "textures/blank_texture.png");
        }
        return Arrays.stream(resourceLocations).toList().get(instance.f_19797_ % resourceLocations.length);
    }
}

