/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.projectile;

import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class MagicBallRenderer
extends EntityRenderer<TensuraProjectile> {
    public static final ModelLayerLocation MAGIC_BALL = new ModelLayerLocation(new ResourceLocation("tensura", "magic_ball"), "main");
    private final ModelPart bolt;

    public MagicBallRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(MAGIC_BALL);
        this.bolt = modelpart.m_171324_("Ball");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("Ball", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-3.0f, 0.0f, -5.3333f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)44);
    }

    public void render(TensuraProjectile entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && entity.m_20177_((Player)minecraft.f_91074_)) {
            return;
        }
        poseStack.m_85836_();
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85836_();
        float swirlX = Mth.m_14089_((float)(0.05f * f * 2.0f)) * 90.0f;
        float swirlY = Mth.m_14031_((float)(0.05f * f * 2.0f)) * 90.0f;
        float swirlZ = Mth.m_14089_((float)(0.05f * f * 2.0f + 5464.0f)) * 90.0f;
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(swirlX * 0.45f));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(swirlY * 0.45f));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(swirlZ * 0.45f));
        float scale = entity.getVisualSize();
        poseStack.m_85841_(scale, scale, scale);
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.bolt.m_104301_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_);
        poseStack.m_85849_();
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(swirlZ));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(swirlX));
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(swirlY));
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(TensuraProjectile instance) {
        ResourceLocation[] resourceLocations = instance.getTextureLocation();
        if (resourceLocations == null) {
            return new ResourceLocation("tensura", "textures/blank_texture.png");
        }
        return Arrays.stream(resourceLocations).toList().get(instance.f_19797_ % resourceLocations.length);
    }
}

