/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client.layer;

import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.entity.SlimeEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.GeoModelProvider;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class StaticBlockLayer<P extends LivingEntity>
extends GeoLayerRenderer<P> {
    public StaticBlockLayer(IGeoRenderer entityRendererIn) {
        super(entityRendererIn);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, P entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation chargingTexture = StaticBlockLayer.getBlockTexture(entity);
        if (chargingTexture == null) {
            return;
        }
        RenderType renderType = StaticBlockLayer.getBlockRenderType(chargingTexture);
        VertexConsumer vertexconsumer = bufferIn.m_6299_(renderType);
        matrixStackIn.m_85836_();
        GeoModelProvider geoModelProvider = this.getEntityModel();
        if (geoModelProvider instanceof AnimatedGeoModel) {
            AnimatedGeoModel model = (AnimatedGeoModel)geoModelProvider;
            GeoModel geoModel = model.getModel(model.getModelResource(entity));
            geoModel.getBone("body").ifPresent(rootBone -> rootBone.childBones.forEach(bone -> {
                bone.setHidden(rootBone.isHidden());
                bone.setScale(1.1f, 1.1f, 1.1f);
            }));
            if (entity instanceof SlimeEntity) {
                SlimeEntity slime = (SlimeEntity)entity;
                float scale = 1.0f / (0.175f * (float)slime.getSize());
                matrixStackIn.m_85841_(scale, scale, scale);
            }
            this.getRenderer().render(geoModel, entity, partialTicks, renderType, matrixStackIn, bufferIn, vertexconsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, StaticBlockLayer.getAlphaValue(entity));
        }
        matrixStackIn.m_85849_();
    }

    public static RenderType getBlockRenderType(ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    public static float getAlphaValue(LivingEntity entity) {
        if (TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.FROST.get())) {
            return 0.5f;
        }
        return 1.0f;
    }

    @Nullable
    public static ResourceLocation getBlockTexture(LivingEntity entity) {
        if (TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.PETRIFICATION.get())) {
            return new ResourceLocation("tensura", "textures/models/layer/block/stone.png");
        }
        if (TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.FROST.get())) {
            return new ResourceLocation("tensura", "textures/models/layer/block/ice.png");
        }
        if (TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.WEBBED.get()) && TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.SILENCE.get())) {
            return new ResourceLocation("tensura", "textures/models/layer/block/web.png");
        }
        if (TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.SHADOW_BIND.get())) {
            return new ResourceLocation("tensura", "textures/models/layer/block/shadow.png");
        }
        if (TensuraEffectsCapability.hasSyncedEffect(entity, (MobEffect)TensuraMobEffects.DIAMOND_PATH.get())) {
            return new ResourceLocation("tensura", "textures/models/layer/block/diamond.png");
        }
        return null;
    }
}

