/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.UnicornEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ChestedHorseModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class UnicornModel<T extends UnicornEntity>
extends ChestedHorseModel<T> {
    public static final ModelLayerLocation UNICORN = new ModelLayerLocation(new ResourceLocation("tensura", "unicorn"), "unicorn");
    private final ModelPart horn;

    public UnicornModel(ModelPart root) {
        super(root);
        this.horn = root.m_171324_("horn");
    }

    public static LayerDefinition m_170483_() {
        MeshDefinition meshdefinition = ChestedHorseModel.m_170669_((CubeDeformation)CubeDeformation.f_171458_);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -21.0f, 0.5f, 1.0f, 5.0f, 1.0f, CubeDeformation.f_171458_).m_171514_(0, 6).m_171488_(-1.0f, -16.0f, 0.0f, 2.0f, 5.0f, 2.0f, CubeDeformation.f_171458_), PartPose.m_171419_((float)0.0f, (float)-4.0f, (float)-11.0f));
        PartDefinition child = partdefinition.m_171597_("body");
        CubeListBuilder cubelistbuilder = CubeListBuilder.m_171558_().m_171514_(26, 21).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 8.0f, 3.0f);
        child.m_171599_("left_chest", cubelistbuilder, PartPose.m_171423_((float)6.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)-1.5707964f, (float)0.0f));
        child.m_171599_("right_chest", cubelistbuilder, PartPose.m_171423_((float)-6.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)1.5707964f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderHorn(T entity, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, float partialTick) {
        this.horn.m_104315_(this.f_102752_);
        float newRed = 1.0f;
        float newGreen = 1.0f;
        float newBlue = 1.0f;
        if (this.shouldRainbowHorn((UnicornEntity)((Object)entity))) {
            int i = ((UnicornEntity)((Object)entity)).f_19797_ / 25 + entity.m_19879_();
            int j = DyeColor.values().length;
            float v = ((float)(((UnicornEntity)((Object)entity)).f_19797_ % 25) + partialTick) / 25.0f;
            float[] afloat1 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)(i % j)));
            float[] afloat2 = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)((i + 1) % j)));
            float r = afloat1[0] * (1.0f - v) + afloat2[0] * v;
            float g = afloat1[1] * (1.0f - v) + afloat2[1] * v;
            float b = afloat1[2] * (1.0f - v) + afloat2[2] * v;
            newRed = Math.min(1.0f, r + 0.5f);
            newGreen = Math.min(1.0f, g + 0.5f);
            newBlue = Math.min(1.0f, b + 0.5f);
        }
        this.horn.m_104306_(poseStack, vertexConsumer, packedLightIn, packedOverlayIn, newRed, newBlue, newGreen, 1.0f);
    }

    public boolean shouldRainbowHorn(UnicornEntity unicorn) {
        if (unicorn.getRainbowHornTicks() > 0) {
            return true;
        }
        return unicorn.m_8077_() && "jeb_".equals(unicorn.m_7755_().getString());
    }
}

