/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.LandfishEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class LandfishModel
extends AnimatedGeoModel<LandfishEntity> {
    public ResourceLocation getModelResource(LandfishEntity object) {
        return new ResourceLocation("tensura", "geo/landfish.geo.json");
    }

    public ResourceLocation getTextureResource(LandfishEntity instance) {
        return instance.getVariant().getTextureLocation();
    }

    public ResourceLocation getAnimationResource(LandfishEntity moth) {
        return new ResourceLocation("tensura", "animations/landfish.animation.json");
    }

    public void setCustomAnimations(LandfishEntity fish, int instanceId, AnimationEvent customPredicate) {
        super.setCustomAnimations((IAnimatable)fish, instanceId, customPredicate);
        this.suitHandling(fish);
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        IBone head = this.getAnimationProcessor().getBone("Head");
        if (head != null) {
            head.setRotationX(extraData.headPitch * ((float)Math.PI / 180));
            head.setRotationY(extraData.netHeadYaw * ((float)Math.PI / 180));
        }
    }

    private void suitHandling(LandfishEntity fish) {
        IBone suitLeftLeg;
        IBone suitRightLeg;
        IBone suitLeftArm;
        IBone suitRightArm;
        IBone suitTail;
        IBone suit;
        IBone hat;
        boolean hasSuit = fish.m_7770_() != null && (fish.m_7770_().getString().equalsIgnoreCase("Nieadni") || fish.m_7770_().getString().equalsIgnoreCase("Nie"));
        if (hasSuit == (hat = this.getAnimationProcessor().getBone("Hat")).isHidden()) {
            hat.setHidden(!hasSuit);
        }
        if (hasSuit == (suit = this.getAnimationProcessor().getBone("Suit")).isHidden()) {
            suit.setHidden(!hasSuit);
        }
        if (hasSuit == (suitTail = this.getAnimationProcessor().getBone("SuitTail")).isHidden()) {
            suitTail.setHidden(!hasSuit);
        }
        if (hasSuit == (suitRightArm = this.getAnimationProcessor().getBone("SuitRightArm")).isHidden()) {
            suitRightArm.setHidden(!hasSuit);
        }
        if (hasSuit == (suitLeftArm = this.getAnimationProcessor().getBone("SuitLeftArm")).isHidden()) {
            suitLeftArm.setHidden(!hasSuit);
        }
        if (hasSuit == (suitRightLeg = this.getAnimationProcessor().getBone("SuitRightLeg")).isHidden()) {
            suitRightLeg.setHidden(!hasSuit);
        }
        if (hasSuit == (suitLeftLeg = this.getAnimationProcessor().getBone("SuitLeftLeg")).isHidden()) {
            suitLeftLeg.setHidden(!hasSuit);
        }
    }
}

