/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.IfritCloneEntity;
import com.github.manasmods.tensura.entity.IfritEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class IfritModel<T extends HumanoidNPCEntity>
extends AnimatedGeoModel<T> {
    public ResourceLocation getModelResource(T object) {
        return new ResourceLocation("tensura", "geo/ifrit.geo.json");
    }

    public ResourceLocation getTextureResource(T instance) {
        return new ResourceLocation("tensura", "textures/entity/ifrit/ifrit.png");
    }

    public ResourceLocation getAnimationResource(T ifrit) {
        return new ResourceLocation("tensura", "animations/ifrit.animation.json");
    }

    public void setCustomAnimations(T ifrit, int instanceId, AnimationEvent customPredicate) {
        super.setCustomAnimations(ifrit, instanceId, customPredicate);
        if (this.shouldStand(ifrit)) {
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            IBone head = this.getAnimationProcessor().getBone("Head");
            if (head != null) {
                head.setRotationX(extraData.headPitch * (float)Math.PI / 180.0f);
                head.setRotationY(extraData.netHeadYaw * (float)Math.PI / 180.0f);
            }
        }
    }

    private boolean shouldStand(T entity) {
        IfritCloneEntity clone;
        if (entity instanceof IfritEntity) {
            IfritEntity ifrit = (IfritEntity)entity;
            return ifrit.shouldStand();
        }
        return entity instanceof IfritCloneEntity && (clone = (IfritCloneEntity)entity).shouldStand();
    }
}

