/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.HornedRabbitEntity;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HornedRabbitModel<T extends HornedRabbitEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation HORNED_RABBIT = new ModelLayerLocation(new ResourceLocation("tensura", "horned_rabbit"), "horned_rabbit");
    private final ModelPart leftRearFoot;
    private final ModelPart rightRearFoot;
    private final ModelPart leftHaunch;
    private final ModelPart rightHaunch;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart head;
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final ModelPart tail;
    private final ModelPart nose;
    private float jumpRotation;

    public HornedRabbitModel(ModelPart pRoot) {
        this.leftRearFoot = pRoot.m_171324_("left_hind_foot");
        this.rightRearFoot = pRoot.m_171324_("right_hind_foot");
        this.leftHaunch = pRoot.m_171324_("left_haunch");
        this.rightHaunch = pRoot.m_171324_("right_haunch");
        this.body = pRoot.m_171324_("body");
        this.leftFrontLeg = pRoot.m_171324_("left_front_leg");
        this.rightFrontLeg = pRoot.m_171324_("right_front_leg");
        this.head = pRoot.m_171324_("head");
        this.rightEar = pRoot.m_171324_("right_ear");
        this.leftEar = pRoot.m_171324_("left_ear");
        this.tail = pRoot.m_171324_("tail");
        this.nose = pRoot.m_171324_("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171481_(-2.5f, -4.0f, -5.0f, 5.0f, 4.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-1.0f));
        head.m_171599_("horn", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -2.0f, -1.5f, 1.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)-2.5f, (float)0.4363f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(52, 0).m_171481_(-2.5f, -9.0f, -1.0f, 2.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)-0.2617994f, (float)0.0f));
        partdefinition.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(58, 0).m_171481_(0.5f, -9.0f, -1.0f, 2.0f, 5.0f, 1.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-1.0f, (float)0.0f, (float)0.2617994f, (float)0.0f));
        partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(52, 6).m_171481_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)20.0f, (float)7.0f, (float)-0.3490659f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(32, 9).m_171481_(-0.5f, -2.5f, -5.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-1.0f));
        partdefinition.m_171599_("left_hind_foot", CubeListBuilder.m_171558_().m_171514_(26, 24).m_171481_(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), PartPose.m_171419_((float)3.0f, (float)17.5f, (float)3.7f));
        partdefinition.m_171599_("right_hind_foot", CubeListBuilder.m_171558_().m_171514_(8, 24).m_171481_(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), PartPose.m_171419_((float)-3.0f, (float)17.5f, (float)3.7f));
        partdefinition.m_171599_("left_haunch", CubeListBuilder.m_171558_().m_171514_(30, 15).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), PartPose.m_171423_((float)3.0f, (float)17.5f, (float)3.7f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_haunch", CubeListBuilder.m_171558_().m_171514_(16, 15).m_171481_(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), PartPose.m_171423_((float)-3.0f, (float)17.5f, (float)3.7f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -2.0f, -10.0f, 6.0f, 5.0f, 10.0f), PartPose.m_171423_((float)0.0f, (float)19.0f, (float)8.0f, (float)-0.34906584f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(8, 15).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)3.0f, (float)17.0f, (float)-1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 15).m_171481_(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)-3.0f, (float)17.0f, (float)-1.0f, (float)-0.17453292f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void m_7695_(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        if (this.f_102610_) {
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.56666666f, 0.56666666f, 0.56666666f);
            pPoseStack.m_85837_(0.0, 1.375, 0.125);
            ImmutableList.of((Object)this.head, (Object)this.leftEar, (Object)this.rightEar, (Object)this.nose).forEach(p_103597_ -> p_103597_.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
            pPoseStack.m_85849_();
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.4f, 0.4f, 0.4f);
            pPoseStack.m_85837_(0.0, 2.25, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail).forEach(p_103587_ -> p_103587_.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
            pPoseStack.m_85849_();
        } else {
            pPoseStack.m_85836_();
            pPoseStack.m_85841_(0.6f, 0.6f, 0.6f);
            pPoseStack.m_85837_(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.head, (Object)this.rightEar, (Object)this.leftEar, (Object)this.tail, (Object)this.nose, (Object[])new ModelPart[0]).forEach(p_103572_ -> p_103572_.m_104306_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
            pPoseStack.m_85849_();
        }
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = pAgeInTicks - (float)((HornedRabbitEntity)pEntity).f_19797_;
        this.nose.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.rightEar.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.leftEar.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.nose.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.rightEar.f_104204_ = this.nose.f_104204_ - 0.2617994f;
        this.leftEar.f_104204_ = this.nose.f_104204_ + 0.2617994f;
        this.jumpRotation = Mth.m_14031_((float)(((HornedRabbitEntity)pEntity).getJumpCompletion(f) * (float)Math.PI));
        this.leftHaunch.f_104203_ = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rightHaunch.f_104203_ = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.leftRearFoot.f_104203_ = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rightRearFoot.f_104203_ = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.leftFrontLeg.f_104203_ = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rightFrontLeg.f_104203_ = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.m_6839_(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.jumpRotation = Mth.m_14031_((float)(((HornedRabbitEntity)pEntity).getJumpCompletion(pPartialTick) * (float)Math.PI));
    }
}

