/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.HellMothEntity;
import com.github.manasmods.tensura.entity.client.HellMothModel;
import com.github.manasmods.tensura.entity.variant.MothVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib3.geo.render.built.GeoModel;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class HellMothRenderer
extends GeoEntityRenderer<HellMothEntity> {
    public HellMothRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new HellMothModel());
        this.f_114477_ = 0.5f;
    }

    public ResourceLocation getTextureLocation(HellMothEntity instance) {
        if (instance.m_7770_() != null && instance.m_7770_().getString().equals("Mothra")) {
            return new ResourceLocation("tensura", "textures/entity/hell_moth_line/mothra.png");
        }
        return MothVariant.LOCATION_BY_VARIANT.get((Object)instance.getVariant());
    }

    public RenderType getRenderType(HellMothEntity moth, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        if (moth.m_6162_()) {
            float size = 0.25f * (float)moth.getBabySize();
            stack.m_85841_(size, size, size);
        }
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(moth));
    }

    public void render(GeoModel model, HellMothEntity moth, float partialTick, RenderType type, PoseStack poseStack, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float newRed = red;
        float newBlue = blue;
        float newGreen = green;
        if (moth.isWet) {
            newRed *= 0.5f;
            newBlue *= 0.5f;
            newGreen *= 0.5f;
        }
        super.render(model, (Object)moth, partialTick, type, poseStack, bufferSource, buffer, packedLight, packedOverlay, newRed, newGreen, newBlue, alpha);
    }
}

