/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity.client;

import com.github.manasmods.tensura.entity.CharybdisEntity;
import com.github.manasmods.tensura.entity.client.CharybdisModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;

public class CharybdisRenderer
extends GeoEntityRenderer<CharybdisEntity> {
    public CharybdisRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (AnimatedGeoModel)new CharybdisModel());
        this.f_114477_ = 3.0f;
    }

    protected float getDeathMaxRotation(CharybdisEntity animatable) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(CharybdisEntity instance) {
        return CharybdisModel.getLocation(instance);
    }

    public RenderType getRenderType(CharybdisEntity entity, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        float size = 0.1f * entity.getSize();
        stack.m_85841_(size, size, size);
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity));
    }

    public void render(CharybdisEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, bufferSource, packedLight);
        if (entity.getMiscAnimation() == 3 && entity.getBeamTarget() != BlockPos.f_121853_) {
            CharybdisRenderer.renderBeam(entity, partialTicks, poseStack, bufferSource, 0xF000F0, 2.5f, 189, 75, 75, 255);
            CharybdisRenderer.renderBeam(entity, partialTicks, poseStack, bufferSource, 0xF000F0, 4.0f, 62, 1, 61, 155);
        }
    }

    public static void renderBeam(CharybdisEntity charybdis, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float size, int red, int green, int blue, int alpha) {
        Vec3 offset = charybdis.getBeamStartOffset();
        double x = charybdis.m_20185_() + offset.m_7096_();
        double y = charybdis.m_20186_() + offset.m_7098_();
        double z = charybdis.m_20189_() + offset.m_7094_();
        float xDist = (float)(x - (double)charybdis.getBeamTarget().m_123341_()) * -1.0f;
        float yDist = (float)(y - (double)charybdis.getBeamTarget().m_123342_()) * -1.0f;
        float zDist = (float)(z - (double)charybdis.getBeamTarget().m_123343_()) * -1.0f;
        float f = Mth.m_14116_((float)(xDist * xDist + zDist * zDist));
        float f1 = Mth.m_14116_((float)(xDist * xDist + yDist * yDist + zDist * zDist));
        poseStack.m_85836_();
        poseStack.m_85837_(offset.m_7096_(), offset.m_7098_(), offset.m_7094_());
        poseStack.m_85845_(Vector3f.f_122225_.m_122270_((float)(-Math.atan2(zDist, xDist)) - 1.5707964f));
        poseStack.m_85845_(Vector3f.f_122223_.m_122270_((float)(-Math.atan2(f, yDist)) - 1.5707964f));
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)BeaconRenderer.f_112102_));
        float f2 = 0.0f - ((float)charybdis.f_19797_ + partialTick) * 0.01f;
        float f3 = f1 / 32.0f - ((float)charybdis.f_19797_ + partialTick) * 0.01f;
        int i = 10;
        float f4 = 0.0f;
        float f5 = 0.25f;
        float f6 = 0.0f;
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_85861_();
        Matrix3f matrix3f = pose.m_85864_();
        for (int j = 1; j <= i; ++j) {
            float f7 = Mth.m_14031_((float)((float)j * ((float)Math.PI * 2) / (float)i)) * size;
            float f8 = Mth.m_14089_((float)((float)j * ((float)Math.PI * 2) / (float)i)) * size;
            float f9 = (float)j / (float)i;
            vertexConsumer.m_85982_(matrix4f, f4, f5, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(f6, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f4, f5, f1).m_6122_(red, green, blue, alpha).m_7421_(f6, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f7, f8, f1).m_6122_(red, green, blue, alpha).m_7421_(f9, f3).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_85982_(matrix4f, f7, f8, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(f9, f2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(matrix3f, 0.0f, -1.0f, 0.0f).m_5752_();
            f4 = f7;
            f5 = f8;
            f6 = f9;
        }
        poseStack.m_85849_();
    }
}

