/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.AquaFrogEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.magic.barrier.AcidRainEntity;
import com.github.manasmods.tensura.entity.magic.projectile.PoisonBallProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.WaterBallProjectile;
import com.github.manasmods.tensura.entity.magic.skill.WaterBladeProjectile;
import com.github.manasmods.tensura.entity.template.GreaterSpiritEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class UndineEntity
extends GreaterSpiritEntity {
    public int stayingTicks = 0;

    public UndineEntity(EntityType<? extends UndineEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GreaterSpiritEntity>)pEntityType, pLevel);
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.BLUE, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((PathfinderMob)this, 2.0, true){

            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return UndineEntity.this.usingMeleeWeapon();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new UndineAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GreaterSpiritEntity.FollowHinataGoal(this, 1.0, HinataSakaguchiEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new GreaterSpiritEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this, 1.0, 12));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, UndineEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        if (this.m_5803_()) {
            return entitydimensions;
        }
        if (this.m_20096_() && this.stayingTicks >= 1200) {
            return entitydimensions.m_20390_(1.0f, 0.5f);
        }
        return entitydimensions;
    }

    public static boolean shouldDistinguishProjectile(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        return entity.m_6095_().m_204039_(TensuraTags.EntityTypes.CAN_DISTINGUISH);
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity2;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof AquaFrogEntity) {
            return false;
        }
        if (DamageSourceHelper.isCold(pSource)) {
            pAmount *= 0.05f;
        }
        pAmount = DamageSourceHelper.isNaturalEffects(pSource) ? (pAmount *= 0.2f) : (pAmount *= this.getPhysicalAttackInput(pSource));
        if (UndineEntity.shouldDistinguishProjectile(pSource.m_7640_())) {
            this.m_5496_(SoundEvents.f_12031_, 10.0f, 0.8f);
            pSource.m_7640_().m_142687_(Entity.RemovalReason.KILLED);
            return false;
        }
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && (entity2 = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity damageSource = (LivingEntity)entity2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(AquaFrogEntity.class, this.m_20191_().m_82400_(32.0), entity -> !entity.m_21824_());
            if (!list.isEmpty()) {
                list.forEach(frog -> frog.m_6710_(damageSource));
            }
        }
        return hurt;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof AquaFrogEntity) {
            AquaFrogEntity frog = (AquaFrogEntity)entity;
            return frog.m_21824_() == this.m_21824_();
        }
        if (entity instanceof UndineEntity) {
            UndineEntity undine = (UndineEntity)entity;
            return undine.m_21824_() == this.m_21824_();
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21825_()) {
            ++this.stayingTicks;
            if (this.stayingTicks == 1200) {
                this.m_6210_();
            }
        } else if (this.stayingTicks != 0) {
            this.stayingTicks = 0;
            this.m_6210_();
        }
        if (!this.f_19853_.m_5776_()) {
            this.m_7311_(Math.min(60, this.m_20094_()));
        } else if (this.m_6084_() && this.f_19797_ % 10 == 0) {
            TensuraParticleHelper.addParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.WATER_EFFECT.get(), 2.0);
        }
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                if ((this.getMiscAnimation() == 1 || this.getMiscAnimation() == 2) && this.miscAnimationTicks == 10) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    UndineEntity.shootWaterBlade((LivingEntity)this);
                    this.m_5496_(SoundEvents.f_12520_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 3) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 25) {
                        this.waterBall();
                    } else {
                        this.setMagicID(0);
                    }
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    this.m_5496_(SoundEvents.f_11862_, 8.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 4 && this.miscAnimationTicks == 22) {
                    this.tailSlam();
                    TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.WATER_EFFECT.get(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), 55, 0.08, 0.08, 0.08, 0.15, true);
                    TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.SNOWFLAKE.get(), this.m_20182_().m_7096_(), this.m_20182_().m_7098_(), this.m_20182_().m_7094_(), 55, 0.08, 0.08, 0.08, 0.15, true);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11807_, SoundSource.NEUTRAL, 5.0f, 1.0f);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, SoundSource.NEUTRAL, 5.0f, 1.0f);
                } else if (this.getMiscAnimation() == 5) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 35) {
                        this.acidRain();
                        this.m_5496_(SoundEvents.f_12521_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 6) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 20) {
                        this.combust();
                        this.m_5496_(SoundEvents.f_11913_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 7) {
                    this.m_21573_().m_26573_();
                    switch (this.miscAnimationTicks) {
                        case 10: {
                            this.summonAquaFrog(3, 7);
                            break;
                        }
                        case 20: {
                            this.summonAquaFrog(5, 10);
                            break;
                        }
                        case 30: {
                            this.summonAquaFrog(7, 15);
                        }
                    }
                    this.m_5496_(SoundEvents.f_11917_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -1 -> 200;
            case 3 -> 60;
            case 4 -> 35;
            case 5 -> 50;
            case 6 -> 30;
            case 7 -> 40;
            default -> 15;
        };
    }

    public static void shootWaterBlade(LivingEntity undine) {
        WaterBladeProjectile bolt = new WaterBladeProjectile(undine.f_19853_, undine);
        bolt.setSkill(SkillUtils.getSkillOrNull((Entity)undine, (ManasSkill)SpiritualMagics.WATER_CUTTER.get()));
        float angle = (float)Math.PI / 180 * undine.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        bolt.m_7678_(undine.m_20185_() + xOffset, undine.m_20188_() - 0.2, undine.m_20189_() + zOffset, undine.m_146908_(), undine.m_146909_());
        bolt.setDamage((float)undine.m_21133_(Attributes.f_22281_));
        bolt.setSpiritAttack(true);
        bolt.setSpeed(2.0f);
        bolt.m_20242_(true);
        bolt.shootFromRot(undine.m_20154_());
        undine.f_19853_.m_7967_((Entity)bolt);
    }

    private void waterBall() {
        int ballId = this.getMagicID();
        if (ballId == 0) {
            PoisonBallProjectile ball = new PoisonBallProjectile(this.f_19853_, (LivingEntity)this);
            ball.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 3.0));
            ball.setSpiritAttack(true);
            ball.setMpCost(500.0);
            ball.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.WATER_MANIPULATION.get()).orElse(null));
            ball.m_146884_(this.m_146892_().m_82520_(0.0, 4.0, 0.0));
            ball.setOwnerOffset(new Vec3(0.0, 3.0, 0.0));
            ball.setLookDistance(30.0f);
            ball.setDelayTick(15);
            ball.m_20242_(true);
            ball.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.FATAL_POISON.get(), 200, 1, false, false, false));
            ball.setEffectRange(3.0f);
            this.m_9236_().m_7967_((Entity)ball);
            this.setMagicID(ball.m_19879_());
        } else {
            Entity entity = this.m_9236_().m_6815_(ballId);
            if (!(entity instanceof WaterBallProjectile)) {
                this.setMagicID(0);
                this.waterBall();
            } else {
                WaterBallProjectile ball = (WaterBallProjectile)entity;
                if (ball.getDelayTick() > 0) {
                    ball.setSize(ball.getSize() + 0.3f);
                }
            }
        }
        this.m_5496_(SoundEvents.f_12521_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
    }

    public void tailSlam() {
        AABB aabb = this.m_20191_().m_82400_(5.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, this::shouldAttack);
        if (list.isEmpty()) {
            return;
        }
        double damageMultiplier = 1.5;
        TensuraDamageSource damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)this).m_19389_(), 20.0, SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.WATER_MANIPULATION.get())).setNotTensuraMagic();
        for (LivingEntity target : list) {
            target.m_6469_((DamageSource)damageSource, (float)(this.m_21133_(Attributes.f_22281_) * damageMultiplier));
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.CHILL.get(), 200, 1, false, false, false));
            SkillHelper.knockBack((LivingEntity)this, target, 1.0f);
        }
    }

    private void acidRain() {
        AcidRainEntity rain = new AcidRainEntity(this.m_9236_(), (LivingEntity)this);
        rain.m_146884_(this.m_20182_());
        rain.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 0.5));
        rain.setMpCost(1000.0);
        rain.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SpiritualMagics.ACID_RAIN.get()).orElse(null));
        if (this.m_5448_() != null) {
            rain.setTarget((Entity)this.m_5448_());
        }
        rain.setLife(200);
        rain.setRadius(2.5f);
        this.m_9236_().m_7967_((Entity)rain);
    }

    public void combust() {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.WATER_EFFECT.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.SNOWFLAKE.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), 55, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123795_, 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123795_, 3.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123795_, 4.0);
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 10.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, this::shouldAttack);
        if (list.isEmpty()) {
            return;
        }
        TensuraDamageSource damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)this).m_19389_(), 100.0, SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.WATER_MANIPULATION.get())).setNotTensuraMagic();
        for (LivingEntity target : list) {
            target.m_6469_((DamageSource)damageSource, (float)this.m_21133_(Attributes.f_22281_) * 3.0f);
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.CHILL.get(), 200, 2, false, false, false));
            target.m_20334_(0.0, 0.1, 0.0);
            SkillHelper.knockBack((LivingEntity)this, target, 2.0f);
        }
    }

    private void summonAquaFrog(int minRadius, int maxRadius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        AquaFrogEntity frog = new AquaFrogEntity((EntityType<? extends AquaFrogEntity>)((EntityType)TensuraEntityTypes.AQUA_FROG.get()), (Level)serverLevel);
        for (int l = 0; l < 50; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            frog.m_6034_(i1, j1, k1);
            if (!serverLevel.m_45784_((Entity)frog) || !serverLevel.m_45786_((Entity)frog)) continue;
            frog.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(frog.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            frog.m_6710_(this.m_5448_());
            serverLevel.m_47205_((Entity)frog);
            frog.setSummonerUUID(this.getSummonerUUID());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)frog, (ParticleOptions)TensuraParticles.WATER_EFFECT.get(), 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)frog, (ParticleOptions)ParticleTypes.f_123774_, 2.0);
            break;
        }
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.WATER;
    }

    @Override
    public Item getElementalCore() {
        return (Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get();
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 39) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
            this.spawnDeathParticles();
        }
    }

    @Override
    protected void spawnDeathParticles() {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.WATER_EFFECT.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.SNOWFLAKE.get(), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11878_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11884_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11881_;
    }

    public boolean shouldStand() {
        if (this.m_21525_()) {
            return true;
        }
        if (this.getMiscAnimation() >= 3 && this.getMiscAnimation() != 5) {
            return true;
        }
        return this.m_20096_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.relax", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_() && this.getMiscAnimation() == -1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.idle_train", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving() && (this.getMiscAnimation() < 3 || this.getMiscAnimation() == 5) && !this.m_21525_()) {
            if (!this.m_20096_()) {
                if (this.m_21660_()) {
                    String name = "animation.undine.swim_swift";
                    if (this.getMiscAnimation() == 1) {
                        name = "animation.undine.swim_with_right_attack";
                    } else if (this.getMiscAnimation() == 2) {
                        name = "animation.undine.swim_with_left_attack";
                    }
                    event.getController().setAnimation(new AnimationBuilder().addAnimation(name, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.swim_slow", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.shouldStand()) {
            if (this.m_20096_() && this.stayingTicks >= 1200) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.idle_staring", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.idle_swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.water_ball_right", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.water_ball_left", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.water_ball_massive", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.tail_slam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.acid_rain", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.burst", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 7) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.undine.death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    static class UndineAttackGoal
    extends Goal {
        private final UndineEntity undine;
        private Vec3 startOrbitFrom;
        private int orbitTime;
        private int maxOrbitTime;
        private int attackCooldown;

        public UndineAttackGoal(UndineEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.undine = entity;
        }

        public boolean m_8036_() {
            if (this.undine.m_21827_()) {
                return false;
            }
            if (this.undine.usingMeleeWeapon()) {
                return false;
            }
            LivingEntity target = this.undine.m_5448_();
            if (target != null && target.m_6084_()) {
                this.startOrbitFrom = target.m_146892_();
                return true;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity target = this.undine.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            this.undine.setFlying(true);
            if (this.orbitTime < this.maxOrbitTime) {
                if (this.undine.getMiscAnimation() == 0) {
                    ++this.orbitTime;
                    --this.attackCooldown;
                }
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(15.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.undine.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 1.2);
                if (this.isTimeToAttack()) {
                    this.resetAttackCooldown();
                    this.undine.setMiscAnimation(this.randomAttack(this.undine.m_20270_((Entity)target)));
                    this.undine.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
            } else {
                this.orbitTime = 0;
                if (this.canSummonFrogs()) {
                    this.undine.setMiscAnimation(7);
                }
            }
        }

        public void m_8056_() {
            this.orbitTime = 0;
            this.maxOrbitTime = 80 + this.undine.m_217043_().m_188503_(80);
            this.undine.m_21561_(true);
            this.attackCooldown = 0;
        }

        public Vec3 orbitAroundPos(float circleDistance) {
            float angle = 3.0f * (float)(Math.toRadians(this.orbitTime) * 3.0);
            double extraX = circleDistance * Mth.m_14031_((float)angle);
            double extraZ = circleDistance * Mth.m_14089_((float)angle);
            return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
        }

        private boolean canSummonFrogs() {
            if (this.undine.m_21824_()) {
                return false;
            }
            List list = this.undine.f_19853_.m_45971_(AquaFrogEntity.class, TargetingConditions.m_148353_().m_26883_(20.0).m_148355_().m_26893_(), (LivingEntity)this.undine, this.undine.m_20191_().m_82400_(20.0));
            if (!list.isEmpty()) {
                for (AquaFrogEntity entity : list) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 200, 0, false, false, false));
                }
            }
            return this.undine.f_19796_.m_188503_(3) + 1 > list.size();
        }

        private void resetAttackCooldown() {
            this.attackCooldown = this.m_183277_(30);
        }

        private boolean isTimeToAttack() {
            return this.attackCooldown <= 0;
        }

        private int randomAttack(double distance) {
            if (distance < 10.0) {
                if ((double)this.undine.f_19796_.m_188501_() <= 0.2) {
                    return 6;
                }
                if ((double)this.undine.f_19796_.m_188501_() <= 0.3) {
                    return 4;
                }
            }
            if (distance < 20.0 && (double)this.undine.f_19796_.m_188501_() <= 0.1) {
                return 5;
            }
            if ((double)this.undine.f_19796_.m_188501_() <= 0.4) {
                return 3;
            }
            return this.undine.m_217043_().m_188499_() ? 1 : 2;
        }
    }
}

