/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.api.entity.navigator.NoSpinFlightPathNavigator;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.entity.AquaFrogEntity;
import com.github.manasmods.tensura.entity.FeatheredSerpentEntity;
import com.github.manasmods.tensura.entity.human.HinataSakaguchiEntity;
import com.github.manasmods.tensura.entity.magic.beam.ElectroBlastProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.LightningSphereProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.WindBladeProjectile;
import com.github.manasmods.tensura.entity.magic.projectile.WindSphereProjectile;
import com.github.manasmods.tensura.entity.template.GreaterSpiritEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class SylphideEntity
extends GreaterSpiritEntity {
    public SylphideEntity(EntityType<? extends SylphideEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends GreaterSpiritEntity>)pEntityType, pLevel);
        this.bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.GREEN, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 40.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((PathfinderMob)this, 2.0, true){

            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return SylphideEntity.this.usingMeleeWeapon();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new SylphideAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new GreaterSpiritEntity.FollowHinataGoal(this, 1.0, HinataSakaguchiEntity.class));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new GreaterSpiritEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this, 1.0, 12));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, SylphideEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void switchNavigator(boolean onLand) {
        if (onLand || this.m_5803_()) {
            this.f_21342_ = new TensuraTamableEntity.SleepMoveControl(){

                @Override
                public void m_8126_() {
                    if (SylphideEntity.this.getMiscAnimation() >= 6 && SylphideEntity.this.getMiscAnimation() != 10) {
                        return;
                    }
                    super.m_8126_();
                }
            };
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.wasFlying = true;
        } else {
            this.f_21342_ = new GreaterSpiritEntity.GreaterMoveControl(this);
            this.f_21344_ = new NoSpinFlightPathNavigator((Mob)this, this.f_19853_);
            this.wasFlying = false;
        }
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity2;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (pSource.m_7639_() instanceof AquaFrogEntity) {
            return false;
        }
        pAmount = DamageSourceHelper.isLightningDamage(pSource) ? (pAmount *= 0.05f) : (DamageSourceHelper.isNaturalEffects(pSource) ? (pAmount *= 0.2f) : (pAmount *= this.getPhysicalAttackInput(pSource)));
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && (entity2 = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity damageSource = (LivingEntity)entity2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(FeatheredSerpentEntity.class, this.m_20191_().m_82400_(32.0), entity -> !entity.m_21824_());
            if (!list.isEmpty()) {
                list.forEach(frog -> frog.m_6710_(damageSource));
            }
        }
        return hurt;
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof FeatheredSerpentEntity) {
            FeatheredSerpentEntity serpent = (FeatheredSerpentEntity)entity;
            return serpent.m_21824_() == this.m_21824_();
        }
        if (entity instanceof SylphideEntity) {
            SylphideEntity sylphide = (SylphideEntity)entity;
            return sylphide.m_21824_() == this.m_21824_();
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            this.m_7311_(Math.min(60, this.m_20094_()));
        } else if (this.m_6084_() && this.f_19797_ % 20 == 0) {
            TensuraParticleHelper.addParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 2.0);
        }
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                if ((this.getMiscAnimation() == 1 || this.getMiscAnimation() == 2) && this.miscAnimationTicks == 5) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    SylphideEntity.shootWindSphere((LivingEntity)this);
                    this.m_5496_(SoundEvents.f_11862_, 7.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if ((this.getMiscAnimation() == 3 || this.getMiscAnimation() == 4) && this.miscAnimationTicks == 10) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    SylphideEntity.shootWindBlade((LivingEntity)this);
                    this.m_5496_(SoundEvents.f_12317_, 7.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                } else if (this.getMiscAnimation() == 5) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks >= 20 && this.miscAnimationTicks <= 50) {
                        this.lightningBall();
                    } else {
                        this.setMagicID(0);
                    }
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                } else if (this.getMiscAnimation() == 9) {
                    this.m_21573_().m_26573_();
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    if (this.miscAnimationTicks == 10) {
                        this.electroBlast();
                    }
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 35) {
                        this.m_5496_(SoundEvents.f_12089_, 5.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 10) {
                    this.m_21573_().m_26573_();
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    if (this.miscAnimationTicks >= 30) {
                        this.aerialBlade();
                        this.m_5496_(SoundEvents.f_12317_, 5.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                        this.m_5496_(SoundEvents.f_12089_, 3.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 6) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks >= 30) {
                        this.combust();
                        this.m_5496_(SoundEvents.f_12317_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 7) {
                    this.m_21573_().m_26573_();
                    switch (this.miscAnimationTicks) {
                        case 10: {
                            this.summonFeatheredSerpent(3, 7);
                            break;
                        }
                        case 20: {
                            this.summonFeatheredSerpent(5, 10);
                            break;
                        }
                        case 30: {
                            this.summonFeatheredSerpent(7, 15);
                        }
                    }
                    this.m_5496_(SoundEvents.f_12052_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -1 -> 200;
            case 5 -> 67;
            case 6 -> 60;
            case 7 -> 45;
            case 8 -> 30;
            case 9 -> 40;
            case 10 -> 70;
            default -> 20;
        };
    }

    public static void shootWindSphere(LivingEntity entity) {
        WindSphereProjectile sphere = new WindSphereProjectile(entity.f_19853_, entity);
        sphere.setSize(0.75f);
        sphere.setSkill(SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)ExtraSkills.WIND_MANIPULATION.get()));
        float angle = (float)Math.PI / 180 * entity.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        sphere.m_7678_(entity.m_20185_() + xOffset, entity.m_20188_() - 0.2, entity.m_20189_() + zOffset, entity.m_146908_(), entity.m_146909_());
        sphere.setDamage((float)entity.m_21133_(Attributes.f_22281_));
        sphere.setSpiritAttack(true);
        sphere.setSpeed(1.5f);
        sphere.m_20242_(true);
        sphere.shootFromRot(entity.m_20154_());
        entity.f_19853_.m_7967_((Entity)sphere);
    }

    public static void shootWindBlade(LivingEntity entity) {
        WindBladeProjectile blade = new WindBladeProjectile(entity.f_19853_, entity);
        blade.setSkill(SkillUtils.getSkillOrNull((Entity)entity, (ManasSkill)SpiritualMagics.WIND_BLADE.get()));
        float angle = (float)Math.PI / 180 * entity.f_20883_;
        double xOffset = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double zOffset = Mth.m_14089_((float)angle);
        blade.m_7678_(entity.m_20185_() + xOffset, entity.m_20188_() - 0.2, entity.m_20189_() + zOffset, entity.m_146908_(), entity.m_146909_());
        blade.setDamage((float)entity.m_21133_(Attributes.f_22281_) * 1.5f);
        blade.setSpiritAttack(true);
        blade.setSpeed(2.0f);
        blade.m_20242_(true);
        blade.shootFromRot(entity.m_20154_());
        entity.f_19853_.m_7967_((Entity)blade);
    }

    private void lightningBall() {
        int ballId = this.getMagicID();
        if (ballId == 0) {
            LightningSphereProjectile sphere = new LightningSphereProjectile(this.f_19853_, (LivingEntity)this);
            sphere.setSize(0.1f);
            sphere.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 3.0));
            sphere.setSpiritAttack(true);
            sphere.setMpCost(500.0);
            sphere.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.WIND_MANIPULATION.get()).orElse(null));
            sphere.setExplosionRadius(4.0f);
            sphere.m_146884_(this.m_146892_().m_82520_(0.0, 4.0, 0.0));
            sphere.setOwnerOffset(new Vec3(0.0, 3.0, 0.0));
            sphere.setLookDistance(30.0f);
            sphere.setDelayTick(30);
            sphere.m_20242_(true);
            sphere.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 200, 1, false, false, false));
            sphere.setEffectRange(3.0f);
            this.m_9236_().m_7967_((Entity)sphere);
            this.setMagicID(sphere.m_19879_());
        } else {
            Entity entity = this.m_9236_().m_6815_(ballId);
            if (!(entity instanceof LightningSphereProjectile)) {
                this.setMagicID(0);
                this.lightningBall();
            } else {
                LightningSphereProjectile ball = (LightningSphereProjectile)entity;
                if (ball.getDelayTick() > 0) {
                    ball.setSize(ball.getSize() + 0.1f);
                }
            }
        }
        this.m_5496_(SoundEvents.f_12521_, 5.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
    }

    private void electroBlast() {
        ElectroBlastProjectile beam = new ElectroBlastProjectile(this.f_19853_, (LivingEntity)this);
        beam.setFollowingOwner(true);
        beam.setSize(1.0f);
        beam.setLife(25);
        float damage = (float)(this.m_21133_(Attributes.f_22281_) * 2.0);
        beam.setDamage(damage);
        beam.setExplosionRadius(2.0f);
        beam.setRange(20.0f);
        beam.m_146884_(this.m_146892_());
        beam.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)SpiritualMagics.ELECTRO_BLAST.get()));
        beam.setMpCost(2000.0);
        this.f_19853_.m_7967_((Entity)beam);
    }

    public void aerialBlade() {
        if (this.miscAnimationTicks % 10 != 0) {
            return;
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 5.0f, 1.0f);
        int radius = 4;
        BlockHitResult result = SkillHelper.getPlayerPOVHitResult(this.f_19853_, (Entity)this, ClipContext.Fluid.NONE, radius + 2);
        BlockPos ahead = result.m_82425_();
        Vec3 aheadVec = new Vec3((double)ahead.m_123341_(), (double)ahead.m_123342_(), (double)ahead.m_123343_());
        TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, this.f_19853_, aheadVec, (ParticleOptions)TensuraParticles.GUST.get(), 3.0);
        TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, this.f_19853_, aheadVec, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 4.0);
        TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, this.f_19853_, aheadVec, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 5.0);
        TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, this.f_19853_, aheadVec, (ParticleOptions)ParticleTypes.f_123766_, 4.0);
        TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, this.f_19853_, aheadVec, (ParticleOptions)ParticleTypes.f_123766_, 5.0);
        AABB thisInflation = this.m_20191_().m_82400_((double)radius);
        List aroundList = this.m_9236_().m_6443_(LivingEntity.class, thisInflation, living -> !living.m_7306_((Entity)this) && living.m_6084_() && !living.m_7307_((Entity)this));
        for (LivingEntity target : aroundList) {
            target.m_20256_(aheadVec.m_82546_(target.m_20182_()).m_82541_().m_82490_(2.0));
            target.f_19864_ = true;
        }
        AABB box = new AABB(ahead).m_82400_((double)radius);
        List list = this.m_9236_().m_6443_(LivingEntity.class, box.m_82367_(thisInflation), living -> !living.m_7306_((Entity)this) && living.m_6084_() && !living.m_7307_((Entity)this));
        if (list.isEmpty()) {
            return;
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        for (LivingEntity target : list) {
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) continue;
            }
            target.m_6469_(TensuraDamageSources.elementalAttack("tensura.wind_attack", (Entity)this, true), damage);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 3.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.GUST.get(), 3.0);
        }
    }

    public void combust() {
        if (this.miscAnimationTicks % 10 != 0) {
            return;
        }
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20188_(), this.m_20189_(), 10, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.LIGHTNING_EFFECT.get(), this.m_20185_(), this.m_20188_(), this.m_20189_(), 10, 0.08, 0.08, 0.08, 0.2, true);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.LIGHTNING_SPARK.get(), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 3.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.GUST.get(), 4.0);
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()) + 10.0);
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, this::shouldAttack);
        if (list.isEmpty()) {
            return;
        }
        float damage = (float)(this.m_21133_(Attributes.f_22281_) * 0.5);
        TensuraDamageSource damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)this).m_19389_(), 100.0, SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.WIND_MANIPULATION.get())).setNotTensuraMagic();
        for (LivingEntity target : list) {
            target.m_6469_((DamageSource)damageSource, damage);
            target.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 200, 2, false, false, false));
            target.m_20334_(0.0, 0.1, 0.0);
            SkillHelper.knockBack((LivingEntity)this, target, 2.0f);
        }
    }

    private void summonFeatheredSerpent(int minRadius, int maxRadius) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int i = Mth.m_14107_((double)this.m_20185_());
        int j = Mth.m_14107_((double)this.m_20186_());
        int k = Mth.m_14107_((double)this.m_20189_());
        FeatheredSerpentEntity serpent = new FeatheredSerpentEntity((EntityType<? extends FeatheredSerpentEntity>)((EntityType)TensuraEntityTypes.FEATHERED_SERPENT.get()), (Level)serverLevel);
        for (int l = 0; l < 50; ++l) {
            int i1 = i + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int j1 = j + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            int k1 = k + Mth.m_216271_((RandomSource)this.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.f_19796_, (int)-1, (int)1);
            BlockPos blockpos = new BlockPos(i1, j1, k1);
            EntityType entitytype = (EntityType)TensuraEntityTypes.FEATHERED_SERPENT.get();
            SpawnPlacements.Type type = SpawnPlacements.m_21752_((EntityType)entitytype);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)serverLevel, (BlockPos)blockpos, (EntityType)entitytype)) continue;
            serpent.m_6034_(i1, j1, k1);
            if (!serverLevel.m_45784_((Entity)serpent) || !serverLevel.m_45786_((Entity)serpent)) continue;
            serpent.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(serpent.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
            serpent.m_6710_(this.m_5448_());
            serverLevel.m_47205_((Entity)serpent);
            serpent.setSummonerUUID(this.getSummonerUUID());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)serpent, (ParticleOptions)TensuraParticles.GUST.get(), 3.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)serpent, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 2.0);
            break;
        }
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.WIND;
    }

    @Override
    public Item getElementalCore() {
        return (Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get();
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 29) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
            this.spawnDeathParticles();
        }
    }

    @Override
    protected void spawnDeathParticles() {
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.SMALL_GUST.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.GUST.get(), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_215671_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_215675_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_215672_;
    }

    public boolean shouldStand() {
        if (this.m_21525_()) {
            return true;
        }
        if (this.getMiscAnimation() == 6) {
            return true;
        }
        if (this.getMiscAnimation() == 7) {
            return true;
        }
        if (this.getMiscAnimation() == 8) {
            return true;
        }
        if (this.m_5803_() || this.m_21825_()) {
            return false;
        }
        return this.m_20096_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.relax", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_()) {
            if (this.getMiscAnimation() == -1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.idle_train", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.stay_by", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (event.isMoving() && !this.m_21525_()) {
            if (!this.m_21660_() || this.m_20096_() || this.getMiscAnimation() == 6 || this.getMiscAnimation() == 7 || this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.fly_fast", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.wind_sphere_right", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.wind_sphere_left", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.wind_blade_right", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.wind_blade_left", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.lightning_sphere", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.aerial_blade_burst", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 7) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 9) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.electro_blast", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 10) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.sylphide.aerial_blade", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    static class SylphideAttackGoal
    extends Goal {
        private final SylphideEntity sylphide;
        private Vec3 startOrbitFrom;
        private int orbitTime;
        private int maxOrbitTime;
        private int attackCooldown;

        public SylphideAttackGoal(SylphideEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.sylphide = entity;
        }

        public boolean m_8036_() {
            if (this.sylphide.m_21827_()) {
                return false;
            }
            if (this.sylphide.usingMeleeWeapon()) {
                return false;
            }
            LivingEntity target = this.sylphide.m_5448_();
            if (target != null && target.m_6084_()) {
                this.startOrbitFrom = target.m_146892_();
                return true;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity target = this.sylphide.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            this.sylphide.setFlying(true);
            if (this.orbitTime < this.maxOrbitTime) {
                if (this.sylphide.getMiscAnimation() == 0) {
                    ++this.orbitTime;
                    --this.attackCooldown;
                }
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(15.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.sylphide.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 1.2);
                if (this.isTimeToAttack()) {
                    this.resetAttackCooldown();
                    this.sylphide.setMiscAnimation(this.randomAttack(this.sylphide.m_20270_((Entity)target)));
                    this.sylphide.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
            } else {
                this.orbitTime = 0;
                if (this.canSummonSerpents()) {
                    this.sylphide.setMiscAnimation(7);
                }
            }
        }

        public void m_8056_() {
            this.orbitTime = 0;
            this.maxOrbitTime = 80 + this.sylphide.m_217043_().m_188503_(80);
            this.sylphide.m_21561_(true);
            this.attackCooldown = 0;
        }

        public Vec3 orbitAroundPos(float circleDistance) {
            float angle = 3.0f * (float)(Math.toRadians(this.orbitTime) * 3.0);
            double extraX = circleDistance * Mth.m_14031_((float)angle);
            double extraZ = circleDistance * Mth.m_14089_((float)angle);
            return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
        }

        private boolean canSummonSerpents() {
            if (this.sylphide.m_21824_()) {
                return false;
            }
            List list = this.sylphide.f_19853_.m_45971_(FeatheredSerpentEntity.class, TargetingConditions.m_148353_().m_26883_(20.0).m_148355_().m_26893_(), (LivingEntity)this.sylphide, this.sylphide.m_20191_().m_82400_(20.0));
            if (!list.isEmpty()) {
                for (FeatheredSerpentEntity entity : list) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 200, 0, false, false, false));
                }
            }
            return this.sylphide.f_19796_.m_188503_(3) + 1 > list.size();
        }

        private void resetAttackCooldown() {
            this.attackCooldown = this.m_183277_(30);
        }

        private boolean isTimeToAttack() {
            return this.attackCooldown <= 0;
        }

        private int randomAttack(double distance) {
            if (distance < 10.0) {
                if ((double)this.sylphide.f_19796_.m_188501_() <= 0.1) {
                    return 6;
                }
                if ((double)this.sylphide.f_19796_.m_188501_() <= 0.2) {
                    return 10;
                }
            }
            if (distance < 20.0 && (double)this.sylphide.f_19796_.m_188501_() <= 0.3) {
                return 9;
            }
            if ((double)this.sylphide.f_19796_.m_188501_() <= 0.3) {
                return 5;
            }
            if ((double)this.sylphide.f_19796_.m_188501_() <= 0.5) {
                return this.sylphide.m_217043_().m_188499_() ? 3 : 4;
            }
            return this.sylphide.m_217043_().m_188499_() ? 1 : 2;
        }
    }
}

