/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.api.entity.ai.BasicSpellGoal;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.OrcDisasterEntity;
import com.github.manasmods.tensura.entity.OrcEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.world.TensuraGameRules;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class OrcLordEntity
extends OrcEntity
implements IGiantMob {
    private static final EntityDataAccessor<Integer> LAUGHING = SynchedEntityData.m_135353_(OrcLordEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int selfRegen;

    public OrcLordEntity(EntityType<? extends OrcLordEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OrcEntity>)pEntityType, pLevel);
        this.m_21553_(false);
        this.f_21364_ = 2000;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22265_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f){

            @Override
            public boolean m_8036_() {
                if (OrcLordEntity.this.getLaughing() > 0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<OrcLordEntity>(this, 1.2, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new OrcLordAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonOrcsGoal(this, 15, 400));
        this.f_21345_.m_25352_(5, (Goal)new RecoveryMagicGoal(this, 15, 100, 20.0f));
        this.f_21345_.m_25352_(6, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this){

            @Override
            public boolean m_8036_() {
                if (OrcLordEntity.this.getLaughing() > 0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, OrcEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected boolean shouldAttack(LivingEntity entity) {
        Player player;
        if (entity == this || this.m_7307_((Entity)entity)) {
            return false;
        }
        if (this.m_21826_() != null) {
            if (entity.m_7307_((Entity)this.m_21826_())) {
                return false;
            }
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                return mob.m_5448_() == this.m_21826_();
            }
            return this.m_21826_().m_21214_() == entity || this.m_21826_().m_21188_() == entity;
        }
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            return true;
        }
        if (entity instanceof AbstractVillager || entity instanceof AbstractIllager) {
            return true;
        }
        if (entity instanceof Animal) {
            return !(entity instanceof OrcEntity);
        }
        return entity instanceof IronGolem;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LAUGHING, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Laughing", this.getLaughing());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLaughing(compound.m_128451_("Laughing"));
    }

    public int getLaughing() {
        return (Integer)this.f_19804_.m_135370_(LAUGHING);
    }

    public void setLaughing(int tick) {
        this.f_19804_.m_135381_(LAUGHING, (Object)tick);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19325_ || source == DamageSource.f_19310_ || source == DamageSource.f_19314_ || super.m_6673_(source);
    }

    @Override
    public boolean shouldSwim() {
        return false;
    }

    @Override
    public boolean canSleep() {
        return false;
    }

    @Override
    public boolean canEquipSlots(EquipmentSlot slot) {
        if (!super.canEquipSlots(slot)) {
            return false;
        }
        return !slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = 1.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() + this.m_6048_() + passenger.m_6049_() - 1.75;
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    @Override
    public boolean breakableBlocks(LivingEntity entity, BlockPos pos, BlockState state) {
        if (state.m_204336_(TensuraTags.Blocks.BOSS_IMMUNE)) {
            return false;
        }
        return ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)pos, (BlockState)state);
    }

    @Override
    public boolean dropBlockLoot(LivingEntity entity, BlockState state) {
        return !state.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY);
    }

    @Nullable
    protected ManasSkillInstance getStarved() {
        Optional skill = SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)UniqueSkills.STARVED.get());
        if (skill.isEmpty()) {
            return null;
        }
        if (!((ManasSkillInstance)skill.get()).canInteractSkill((LivingEntity)this)) {
            return null;
        }
        return (ManasSkillInstance)skill.get();
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof OrcEntity) {
            OrcEntity orc = (OrcEntity)entity;
            return orc.m_21824_() == this.m_21824_();
        }
        return false;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (this.m_7307_((Entity)pTarget)) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.m_21824_()) {
            return;
        }
        if (this.isColliding((LivingEntity)this, false) || this.f_19797_ % 20 == 0 && this.m_5448_() != null) {
            List list;
            if (this.f_19797_ % 20 == 0 && !(list = this.f_19853_.m_45976_(BarrierPart.class, this.m_20191_().m_82400_(1.0))).isEmpty()) {
                for (BarrierPart barrier : list) {
                    this.m_7327_((Entity)barrier);
                }
            }
            if (!this.breakBlocks((LivingEntity)this, 2.0f, false, 1, this.inventory, true)) {
                return;
            }
            if (this.getMiscAnimation() >= 1) {
                return;
            }
            this.setMiscAnimation(8);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getLaughing() > 0) {
            this.setLaughing(this.getLaughing() - 1);
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.m_20202_() instanceof Boat || this.m_20202_() instanceof AbstractMinecart) {
            this.m_20202_().m_6469_(DamageSource.m_19370_((LivingEntity)this), 40.0f);
        }
        if (--this.selfRegen <= 0 && this.m_21223_() < this.m_21233_() && this.m_6084_()) {
            this.healAndEat();
        }
    }

    @Override
    protected void evolvingTick() {
        if (this.getEvolving() > 0) {
            this.setEvolving(this.getEvolving() - 1);
            this.m_6210_();
            this.m_5496_(SoundEvents.f_12241_, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
            if (this.getEvolving() == 0) {
                this.evolveToDisaster();
            }
        }
    }

    protected void healAndEat() {
        this.m_5634_(2.0f);
        this.selfRegen = 20;
        if (this.m_146895_() != null && this.getMiscAnimation() <= 1) {
            this.setMiscAnimation(7);
        } else if (this.getMiscAnimation() <= 1 && this.m_146895_() == null) {
            boolean shouldEat;
            boolean bl = shouldEat = this.m_21223_() < this.m_21233_() / 4.0f && (double)this.f_19796_.m_188501_() <= 0.2 || this.m_21223_() < this.m_21233_() / 8.0f;
            if (!shouldEat) {
                return;
            }
            List list = this.f_19853_.m_45976_(OrcEntity.class, this.m_20191_().m_82400_(3.0));
            if (!list.isEmpty()) {
                for (OrcEntity sacrifice : list) {
                    if (sacrifice == this) continue;
                    this.setMiscAnimation(7);
                    sacrifice.m_7998_((Entity)this, true);
                    return;
                }
            }
        }
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.m_6084_() && !this.f_19853_.f_46443_) {
                if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 15) {
                    this.areaAttack(1.5f, 0.75f);
                    TensuraParticleHelper.spawnGroundSlamParticle((LivingEntity)this, 5, 2.5f);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215778_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                        SkillHelper.launchBlock((Entity)this, this.m_20182_(), 3, 1, 0.4f, 0.3f, blockState -> {
                            if (this.m_217043_().m_188503_(3) != 1) {
                                return false;
                            }
                            return blockState.m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING);
                        }, blockPos -> !blockPos.equals((Object)this.m_20097_().m_7495_()));
                    }
                } else if (this.getMiscAnimation() == 4) {
                    Entity entity;
                    LivingEntity target = this.m_5448_();
                    if (this.miscAnimationTicks == 10 && this.m_146895_() == null) {
                        if (target != null && target.m_20270_((Entity)this) <= 4.0f && target != this) {
                            target.m_7998_((Entity)this, true);
                        }
                    } else if (this.miscAnimationTicks == 20 && (entity = this.m_146895_()) instanceof LivingEntity) {
                        LivingEntity passenger = (LivingEntity)entity;
                        passenger.m_8127_();
                        passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * 2.0));
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    }
                } else if (this.getMiscAnimation() == 7) {
                    Entity target2;
                    if (this.miscAnimationTicks == 5 && this.m_146895_() == null) {
                        LivingEntity target2 = this.m_5448_();
                        if (target2 != null && target2.m_20270_((Entity)this) <= 4.0f && target2 != this) {
                            target2.m_7998_((Entity)this, true);
                        }
                    } else if (this.miscAnimationTicks == 15 && (target2 = this.m_146895_()) instanceof LivingEntity) {
                        LivingEntity passenger = (LivingEntity)target2;
                        passenger.m_8127_();
                        float HP = passenger.m_21223_();
                        passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19380_(), (float)(this.m_21133_(Attributes.f_22281_) * 3.0));
                        if (!passenger.m_6084_()) {
                            this.m_5634_(HP * 2.0f);
                        } else {
                            this.m_5634_(50.0f);
                        }
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215769_, SoundSource.HOSTILE, 1.0f, 1.0f);
                    }
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    public void areaAttack(float damageMultiplier, float upVector) {
        AABB aabb = this.m_20191_().m_82400_(this.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get()));
        List list = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && entity != this.m_21826_() && entity != this);
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity target : list) {
            LivingEntity orcTarget;
            OrcEntity orc;
            if (target instanceof OrcEntity && !(orc = (OrcEntity)target).m_21824_() && this.m_5448_() != orc && ((orcTarget = orc.m_5448_()) == null || orcTarget != this && !orcTarget.m_7307_((Entity)this))) continue;
            target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damageMultiplier));
            target.m_20184_().m_82520_(0.0, (double)upVector, 0.0);
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            default -> 11;
            case 2 -> 15;
            case 3 -> 22;
            case 4 -> 35;
            case 5 -> 25;
            case 6 -> 30;
            case 7 -> 29;
            case 8 -> 27;
        };
    }

    @Override
    public void m_7334_(Entity pEntity) {
        if (pEntity instanceof OrcEntity) {
            return;
        }
        super.m_7334_(pEntity);
    }

    @Override
    protected void hurtShield(ItemStack stack, float pAmount) {
        if (pAmount >= 3.0f) {
            stack.m_41622_(1 + Mth.m_14143_((float)pAmount), (LivingEntity)this, living -> living.m_21166_(EquipmentSlot.OFFHAND));
        }
        this.m_5496_(SoundEvents.f_12346_, 1.0f, 1.0f);
        this.setMiscAnimation(1);
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity entity2;
        boolean hurt = super.m_6469_(pSource, pAmount);
        if (hurt && (entity2 = pSource.m_7639_()) instanceof LivingEntity) {
            Player player;
            LivingEntity damageSource = (LivingEntity)entity2;
            if (!damageSource.m_6084_()) {
                return true;
            }
            if (damageSource instanceof Player && ((player = (Player)damageSource).m_7500_() || player.m_5833_())) {
                return true;
            }
            List list = this.f_19853_.m_6443_(OrcEntity.class, this.m_20191_().m_82400_(32.0), entity -> !entity.m_21824_() && !(entity instanceof OrcLordEntity));
            if (!list.isEmpty()) {
                list.forEach(orc -> orc.m_6710_(damageSource));
            }
        }
        return hurt;
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        if (super.m_7327_(pEntity) && pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            if (this.getStarved() != null) {
                SkillHelper.addEffectWithSource(living, (LivingEntity)this, (MobEffect)TensuraMobEffects.CORROSION.get(), 200, this.getClass() == OrcLordEntity.class ? 3 : 2, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_8035_() {
        super.m_8035_();
        if (this.getMiscAnimation() == 0) {
            this.setMiscAnimation(6);
        }
    }

    public boolean m_214076_(ServerLevel pLevel, LivingEntity pEntity) {
        boolean wasKilled = super.m_214076_(pLevel, pEntity);
        if (wasKilled && this.m_6084_()) {
            if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                this.setLaughing(20);
                this.m_5496_(SoundEvents.f_12241_, 10.0f, 1.0f);
            }
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123749_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123749_, 1.0);
            float heal = 5.0f;
            AttributeInstance HP = this.m_21051_(Attributes.f_22276_);
            if (HP != null) {
                HP.m_22100_(HP.m_22115_() + (double)heal);
            }
            this.m_5634_(30.0f);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 0, false, false));
            List list = this.f_19853_.m_45976_(OrcEntity.class, this.m_20191_().m_82400_(16.0));
            if (!list.isEmpty()) {
                for (OrcEntity sub : list) {
                    if (sub == this || sub.m_21824_()) continue;
                    sub.m_7292_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 400, 0, false, false));
                    sub.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 0, false, false));
                }
            }
            TensuraEPCapability.getFrom((LivingEntity)this).ifPresent(cap -> {
                double targetEP = SkillUtils.getEPGain(pEntity, (LivingEntity)this);
                double percentage = (double)TensuraGameRules.getEPGain(this.f_19853_) > 0.5 ? (double)TensuraGameRules.getEPGain(this.f_19853_) : 0.5 - (double)TensuraGameRules.getEPGain(this.f_19853_);
                cap.setEP((LivingEntity)this, cap.getEP() + targetEP * percentage);
                if (this.getClass() == OrcLordEntity.class && cap.getEP() >= 200000.0) {
                    this.m_21573_().m_26573_();
                    this.m_20331_(true);
                    this.setEvolving(40);
                }
            });
        }
        return wasKilled;
    }

    protected void evolveToDisaster() {
        CompoundTag tag = this.serializeNBT();
        this.m_146870_();
        OrcDisasterEntity orc = new OrcDisasterEntity((EntityType<? extends OrcDisasterEntity>)((EntityType)TensuraEntityTypes.ORC_DISASTER.get()), this.f_19853_);
        orc.m_20258_(tag);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            orc.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(orc.m_20183_()), MobSpawnType.CONVERSION, null, null);
        }
        RaceHelper.applyBaseAttribute(OrcDisasterEntity.setAttributes(), (LivingEntity)orc);
        orc.m_21153_(orc.m_21233_());
        RaceHelper.updateSpiritualHP((LivingEntity)orc);
        RaceHelper.updateEntityEPCount((LivingEntity)orc);
        orc.setEvolving(0);
        orc.m_20331_(false);
        this.f_19853_.m_7967_((Entity)orc);
        orc.m_6210_();
        this.f_19853_.m_5594_(null, orc.m_20183_(), SoundEvents.f_12306_, SoundSource.PLAYERS, 10.0f, 1.0f);
        this.f_19853_.m_7967_((Entity)orc);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_, 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123747_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123812_);
    }

    @Override
    protected void dropBlood() {
        if (this.f_19796_.m_188499_()) {
            return;
        }
        this.m_19998_((ItemLike)TensuraMobDropItems.ROYAL_BLOOD.get());
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    @Override
    protected boolean removeWhenNoAction() {
        return false;
    }

    @Override
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (!pReason.equals((Object)MobSpawnType.BUCKET) && !pReason.equals((Object)MobSpawnType.CONVERSION)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        int i = pRandom.m_188503_(100);
        ItemStack stack = new ItemStack((ItemLike)TensuraToolItems.MEAT_CRUSHER.get());
        if (i < 5) {
            stack = new ItemStack((ItemLike)TensuraToolItems.BLADE_TIGER_SCYTHE.get());
        }
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(4, stack);
        this.inventory.m_6596_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getLaughing() > 0 || this.getEvolving() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.laugh", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.m_20096_() && this.m_21660_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.m_20096_() || !this.isInFluidType()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.getLaughing() > 0) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.laugh", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            switch (this.getMiscAnimation()) {
                case 1: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.punch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 2: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.cleaver_swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 3: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.cleaver_slam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 4: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.crush", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 5: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.yell", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 6: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.eat_item", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 7: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.eat_mob", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 8: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.recover", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 9: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_lord.shield", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public class OrcLordAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final OrcLordEntity orc;

        public OrcLordAttackGoal(OrcLordEntity beast) {
            super(OrcLordEntity.this, (PathfinderMob)beast, 2.0, true);
            this.orc = beast;
        }

        public void m_8037_() {
            if (this.orc.getMiscAnimation() > 2) {
                return;
            }
            super.m_8037_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (this.orc.getMiscAnimation() == 0 || this.orc.getMiscAnimation() == 1) {
                double attackRange;
                int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
                if (randomAttack == 0) {
                    return;
                }
                switch (randomAttack) {
                    case 4: {
                        double d = d0 + 9.0;
                        break;
                    }
                    case 3: {
                        double d = d0 + 4.0;
                        break;
                    }
                    default: {
                        double d = attackRange = d0;
                    }
                }
                if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                    this.m_25563_();
                    this.orc.setMiscAnimation(randomAttack);
                    if (randomAttack == 3 || randomAttack == 7) {
                        this.orc.m_21573_().m_26573_();
                    }
                    if (randomAttack == 1 || randomAttack == 2) {
                        this.orc.m_7327_((Entity)pEnemy);
                    }
                }
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if ((double)this.orc.f_19796_.m_188501_() <= 0.2 && distSqr <= 9.0 && !target.m_20159_() && !target.m_20160_() && target != this.orc) {
                if (target.m_21223_() <= target.m_21233_() / 5.0f) {
                    return 7;
                }
                return 4;
            }
            if (!this.orc.m_21205_().m_41619_()) {
                if ((double)this.orc.f_19796_.m_188501_() <= 0.5) {
                    return 3;
                }
                return 2;
            }
            return 1;
        }

        @Override
        protected double m_6639_(LivingEntity pAttackTarget) {
            double attackRange = this.orc.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
            return super.m_6639_(pAttackTarget) + attackRange * attackRange;
        }
    }

    static class SummonOrcsGoal
    extends BasicSpellGoal {
        private final TargetingConditions orcCountTargeting = TargetingConditions.m_148353_().m_26883_(32.0).m_148355_().m_26893_();
        private final OrcLordEntity orcLord;
        protected boolean summonAtSpawn;

        public SummonOrcsGoal(OrcLordEntity creature, int castWarmUpTime, int castingInterval) {
            super((Mob)creature, castWarmUpTime, castingInterval);
            this.orcLord = creature;
        }

        @Override
        public boolean m_8036_() {
            if (this.orcLord.m_21824_()) {
                return false;
            }
            if (!super.m_8036_() && this.summonAtSpawn) {
                return false;
            }
            int i = this.orcLord.f_19853_.m_45971_(OrcEntity.class, this.orcCountTargeting, (LivingEntity)this.orcLord, this.orcLord.m_20191_().m_82400_(32.0)).size();
            return this.orcLord.f_19796_.m_188503_(30) + 1 > i;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.orcLord.setMiscAnimation(5);
        }

        @Override
        protected void performSpellCasting() {
            if (!this.summonAtSpawn) {
                this.summonAtSpawn = true;
            }
            this.summonOrcRandomPos(4, 0, 7);
        }

        protected void summonOrcRandomPos(int amount, int minRadius, int maxRadius) {
            ServerLevel serverLevel = (ServerLevel)this.orcLord.f_19853_;
            int i = Mth.m_14107_((double)this.orcLord.m_20185_());
            int j = Mth.m_14107_((double)this.orcLord.m_20186_());
            int k = Mth.m_14107_((double)this.orcLord.m_20189_());
            block0: for (int orcs = 0; orcs < amount; ++orcs) {
                OrcEntity orc = new OrcEntity((EntityType<? extends OrcEntity>)((EntityType)TensuraEntityTypes.ORC.get()), (Level)serverLevel);
                for (int l = 0; l < 50; ++l) {
                    int i1 = i + Mth.m_216271_((RandomSource)this.orcLord.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.orcLord.f_19796_, (int)-1, (int)1);
                    int j1 = j + Mth.m_216271_((RandomSource)this.orcLord.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.orcLord.f_19796_, (int)-1, (int)1);
                    int k1 = k + Mth.m_216271_((RandomSource)this.orcLord.f_19796_, (int)minRadius, (int)maxRadius) * Mth.m_216271_((RandomSource)this.orcLord.f_19796_, (int)-1, (int)1);
                    BlockPos blockpos = new BlockPos(i1, j1, k1);
                    EntityType entitytype = (EntityType)TensuraEntityTypes.ORC.get();
                    SpawnPlacements.Type type = SpawnPlacements.m_21752_((EntityType)entitytype);
                    if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)type, (LevelReader)serverLevel, (BlockPos)blockpos, (EntityType)entitytype) || !SpawnPlacements.m_217074_((EntityType)entitytype, (ServerLevelAccessor)serverLevel, (MobSpawnType)MobSpawnType.REINFORCEMENT, (BlockPos)blockpos, (RandomSource)serverLevel.f_46441_)) continue;
                    orc.m_6034_(i1, j1, k1);
                    if (!serverLevel.m_45784_((Entity)orc) || !serverLevel.m_45786_((Entity)orc)) continue;
                    orc.m_6518_((ServerLevelAccessor)serverLevel, serverLevel.m_6436_(orc.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    orc.m_6710_(this.orcLord.m_5448_());
                    this.makeKnight(orc);
                    serverLevel.m_47205_((Entity)orc);
                    continue block0;
                }
            }
        }

        protected void makeKnight(OrcEntity orc) {
            ItemStack helmet = new ItemStack((ItemLike)Items.f_42468_);
            ItemStack chestplate = new ItemStack((ItemLike)Items.f_42469_);
            ItemStack leggings = new ItemStack((ItemLike)Items.f_42470_);
            ItemStack boots = new ItemStack((ItemLike)Items.f_42471_);
            ItemStack weapon = new ItemStack((ItemLike)(this.orcLord.f_19796_.m_188499_() ? (ItemLike)TensuraToolItems.IRON_SPEAR.get() : Items.f_42386_));
            if ((double)this.orcLord.f_19796_.m_188501_() <= 0.3) {
                weapon = this.orcLord.f_19796_.m_188499_() ? new ItemStack((ItemLike)TensuraToolItems.LONG_BOW.get()) : new ItemStack((ItemLike)Items.f_42717_);
            }
            if ((double)this.orcLord.f_19796_.m_188501_() <= 0.05) {
                helmet = new ItemStack((ItemLike)Items.f_42480_);
                chestplate = new ItemStack((ItemLike)Items.f_42481_);
                leggings = new ItemStack((ItemLike)Items.f_42482_);
                boots = new ItemStack((ItemLike)Items.f_42483_);
                weapon = new ItemStack((ItemLike)Items.f_42396_);
            }
            orc.m_8061_(EquipmentSlot.HEAD, helmet);
            orc.m_8061_(EquipmentSlot.CHEST, chestplate);
            orc.m_8061_(EquipmentSlot.LEGS, leggings);
            orc.m_8061_(EquipmentSlot.FEET, boots);
            orc.m_8061_(EquipmentSlot.MAINHAND, weapon);
            if ((double)this.orcLord.f_19796_.m_188501_() <= 0.1) {
                orc.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
            }
        }

        @Override
        protected boolean noTargetActivation() {
            return !this.summonAtSpawn;
        }

        @Override
        protected SoundEvent getCastingSoundEvent() {
            return SoundEvents.f_215769_;
        }
    }

    static class RecoveryMagicGoal
    extends BasicSpellGoal {
        private final OrcLordEntity orcLord;
        private final float healAmount;

        public RecoveryMagicGoal(OrcLordEntity creature, int castWarmUpTime, int castingInterval, float healAmount) {
            super((Mob)creature, castWarmUpTime, castingInterval);
            this.orcLord = creature;
            this.healAmount = healAmount;
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            return this.orcLord.shouldHeal();
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            this.orcLord.setMiscAnimation(8);
        }

        @Override
        protected void performSpellCasting() {
            this.orcLord.m_5634_(this.healAmount);
            this.orcLord.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 30, 0, false, false, false));
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this.orcLord, (ParticleOptions)ParticleTypes.f_123810_, 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this.orcLord, (ParticleOptions)ParticleTypes.f_123749_, 2.0);
        }

        @Override
        protected boolean noTargetActivation() {
            return true;
        }

        @Override
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12053_;
        }

        @Override
        protected SoundEvent getCastingSoundEvent() {
            return SoundEvents.f_11887_;
        }
    }
}

