/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.entity.OrcDisasterEntity;
import com.github.manasmods.tensura.entity.OrcLordEntity;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.OrcVariant;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OrcEntity
extends HumanoidNPCEntity
implements IAnimatable,
IRanking {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(OrcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(OrcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EVOLVING = SynchedEntityData.m_135353_(OrcEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int miscAnimationTicks = 0;
    public boolean prevSwim = false;

    public OrcEntity(EntityType<? extends OrcEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends HumanoidNPCEntity>)pEntityType, pLevel);
        this.f_21364_ = 5;
        this.f_19793_ = 1.0f;
        this.f_21365_ = new EvolvingLookControl();
        this.f_21342_ = new EvolvingMoveControl();
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 1.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<OrcEntity>(this, 1.2, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 20.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 20.0f){

            @Override
            public boolean m_8036_() {
                OrcEntity orc = OrcEntity.this;
                LivingEntity target = orc.m_5448_();
                if (target == null) {
                    return false;
                }
                if (!orc.m_21824_() && target.m_20186_() - orc.m_20186_() < 5.0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal(this, (PathfinderMob)this, 2.0, true));
        this.f_21345_.m_25352_(4, (Goal)new FollowLordGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.2, OrcEntity.class));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, OrcEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((OrcEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(EVOLVING, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("Evolving", this.getEvolving());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)compound.m_128451_("Variant"));
        this.setEvolving(compound.m_128451_("Evolving"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    @Override
    public void setMiscAnimation(int tick) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)tick);
    }

    public OrcVariant getVariant() {
        return OrcVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(OrcVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public int getEvolving() {
        return (Integer)this.f_19804_.m_135370_(EVOLVING);
    }

    public void setEvolving(int tick) {
        this.f_19804_.m_135381_(EVOLVING, (Object)tick);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (f_21798_.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    @Override
    public void evolve() {
        this.gainSwimSpeed((LivingEntity)this, 1.0);
    }

    @Override
    public void m_6136_(boolean pIsCharging) {
        super.m_6136_(pIsCharging);
        if (pIsCharging) {
            this.setMiscAnimation(3);
        }
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        OrcEntity orc;
        OrcEntity baby = (OrcEntity)((EntityType)TensuraEntityTypes.ORC.get()).m_20615_((Level)pLevel);
        if (baby == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            baby.m_21816_(uuid);
            baby.m_7105_(true);
        }
        float chance = 0.0f;
        if (this.getVariant().equals((Object)OrcVariant.ROYAL) || this.getVariant().equals((Object)OrcVariant.ROYAL_LORD)) {
            chance += 0.5f;
        }
        if (pOtherParent instanceof OrcEntity && ((orc = (OrcEntity)pOtherParent).getVariant().equals((Object)OrcVariant.ROYAL) || orc.getVariant().equals((Object)OrcVariant.ROYAL_LORD))) {
            chance += 0.5f;
        }
        if (this.f_19796_.m_188501_() <= chance) {
            baby.setVariant(OrcVariant.ROYAL);
        }
        return baby;
    }

    public boolean m_6898_(ItemStack pStack) {
        if (pStack.m_150930_((Item)TensuraMobDropItems.ROYAL_BLOOD.get())) {
            return false;
        }
        return pStack.m_41720_().m_41472_();
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19314_ || super.m_6673_(source);
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        if (this.m_5803_()) {
            return entitydimensions.m_20390_(1.0f, 0.5f);
        }
        if (this.shouldSwim()) {
            return entitydimensions.m_20390_(1.0f, 0.25f);
        }
        if (this.getClass() == OrcEntity.class && (this.m_21827_() || this.m_21825_())) {
            return entitydimensions.m_20390_(1.0f, 0.75f);
        }
        if (this.getClass() == OrcDisasterEntity.class) {
            return entitydimensions;
        }
        int tick = 40 - this.getEvolving();
        if (this.getEvolving() > 0 && tick > 0) {
            float scale = 1.0f + 0.5f * ((float)tick / 40.0f);
            return entitydimensions.m_20388_(scale);
        }
        return entitydimensions;
    }

    @Override
    public boolean canSleep() {
        return true;
    }

    public void m_7334_(Entity pEntity) {
        if (pEntity instanceof OrcLordEntity) {
            return;
        }
        super.m_7334_(pEntity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.evolvingTick();
        if (this.prevSwim != this.isInFluidType() && !this.m_20096_()) {
            this.m_6210_();
            this.prevSwim = this.isInFluidType() && !this.m_20096_();
        }
        this.miscAnimationHandler();
    }

    protected void evolvingTick() {
        if (this.getEvolving() > 0) {
            this.setEvolving(this.getEvolving() - 1);
            this.m_6210_();
            this.m_5496_(SoundEvents.f_12241_, 1.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
            if (this.getEvolving() == 0) {
                if (this.canEvolveToLord()) {
                    this.royalLordEvolves();
                } else {
                    this.m_5496_(SoundEvents.f_12306_, 1.0f, 1.0f);
                    this.setEvolving(0);
                    this.m_6210_();
                }
            }
        }
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        if (miscAnimation == 3) {
            return 25;
        }
        return 7;
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() != 2) {
            this.setMiscAnimation(1);
        }
        return flag;
    }

    @Override
    protected void hurtShield(ItemStack stack, float pAmount) {
        super.hurtShield(stack, pAmount);
        this.setMiscAnimation(2);
    }

    @Override
    protected boolean spearThrowAttack(LivingEntity pTarget, ItemStack weapon) {
        boolean success = super.spearThrowAttack(pTarget, weapon);
        if (success) {
            this.setMiscAnimation(4);
        }
        return success;
    }

    @Override
    protected float m_21519_(EquipmentSlot pSlot) {
        if (this.m_21824_()) {
            return 0.0f;
        }
        if (pSlot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR)) {
            if (super.m_21519_(pSlot) >= 2.0f) {
                return 2.0f;
            }
            return 0.0f;
        }
        return super.m_21519_(pSlot);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        this.dropBlood();
    }

    protected void dropBlood() {
        if (this.getVariant().equals((Object)OrcVariant.NORMAL)) {
            return;
        }
        if ((double)this.f_19796_.m_188501_() > 0.2 || this.getSpawnType() == MobSpawnType.BREEDING) {
            return;
        }
        this.m_19998_((ItemLike)TensuraMobDropItems.ROYAL_BLOOD.get());
    }

    private boolean canEvolveToLord() {
        if (this.m_21824_()) {
            return false;
        }
        if (this.m_6162_()) {
            return false;
        }
        return this.getVariant().equals((Object)OrcVariant.ROYAL_LORD);
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack stack) {
        if (this.canEvolveToLord() && stack.m_150930_((Item)TensuraMobDropItems.ROYAL_BLOOD.get()) && this.getEvolving() > -10 && this.getEvolving() <= 0) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.setEvolving(this.getEvolving() - 1);
            if (this.getEvolving() <= -10 && TensuraEPCapability.getEP((LivingEntity)this) >= 80000.0) {
                this.setEvolving(40);
                TensuraEPCapability.getFrom((LivingEntity)this).ifPresent(cap -> cap.addNeutralTarget(player.m_20148_()));
            }
            this.m_5634_(this.m_21233_());
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (this.m_6898_(stack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.m_8035_();
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, stack);
                this.m_146740_(OrcEntity.m_216967_((int)(-this.m_146764_())), true);
                this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.m_6162_() && this.m_5957_()) {
                this.m_142075_(player, hand, stack);
                this.m_27595_(player);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
    }

    private void royalLordEvolves() {
        Level level = this.m_9236_();
        CompoundTag tag = this.serializeNBT();
        this.m_146870_();
        OrcLordEntity orc = new OrcLordEntity((EntityType<? extends OrcLordEntity>)((EntityType)TensuraEntityTypes.ORC_LORD.get()), level);
        orc.m_20258_(tag);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            orc.m_6518_((ServerLevelAccessor)serverLevel, level.m_6436_(orc.m_20183_()), MobSpawnType.CONVERSION, null, null);
        }
        orc.setVariant(OrcVariant.NORMAL);
        RaceHelper.applyBaseAttribute(OrcLordEntity.setAttributes(), (LivingEntity)orc, true);
        RaceHelper.updateSpiritualHP((LivingEntity)orc);
        RaceHelper.updateEntityEPCount((LivingEntity)orc);
        orc.m_21153_(orc.m_21233_());
        level.m_7967_((Entity)orc);
        level.m_5594_(null, orc.m_20183_(), SoundEvents.f_12306_, SoundSource.PLAYERS, 1.0f, 1.0f);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_, 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123747_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123812_);
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        if (this.m_21824_()) {
            return false;
        }
        List list = this.f_19853_.m_45976_(OrcLordEntity.class, this.m_20191_().m_82377_(30.0, 8.0, 30.0));
        return list.isEmpty();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (this.getClass() != OrcEntity.class) {
            return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        }
        if (this.canSpawnSpecialVariant(pReason) && SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.orcLordChance.get(), pLevel.m_213780_())) {
            OrcLordEntity orcLord = new OrcLordEntity((EntityType<? extends OrcLordEntity>)((EntityType)TensuraEntityTypes.ORC_LORD.get()), this.m_9236_());
            orcLord.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            orcLord.m_213945_(this.f_19796_, pDifficulty);
            orcLord.m_6518_(pLevel, this.f_19853_.m_6436_(this.m_20183_()), MobSpawnType.NATURAL, null, null);
            this.m_9236_().m_7967_((Entity)orcLord);
            this.m_146870_();
        } else if (SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.orcRoyalChance.get(), pLevel.m_213780_())) {
            if (this.canSpawnSpecialVariant(pReason) && SpawnRateConfig.rollChance((Integer)SpawnRateConfig.INSTANCE.orcRoyalLordChance.get(), pLevel.m_213780_())) {
                this.setVariant(OrcVariant.ROYAL_LORD);
                TensuraSkillInstance instance = new TensuraSkillInstance((ManasSkill)CommonSkills.SELF_REGENERATION.get());
                instance.setToggled(true);
                SkillAPI.getSkillsFrom((Entity)this).learnSkill((ManasSkillInstance)instance);
            } else {
                this.setVariant(OrcVariant.ROYAL);
            }
        }
        if (!pReason.equals((Object)MobSpawnType.BUCKET)) {
            this.m_213945_(this.f_19796_, pDifficulty);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.orcSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Override
    protected void m_213945_(RandomSource pRandom, DifficultyInstance pDifficulty) {
        super.m_213945_(pRandom, pDifficulty);
        if (pRandom.m_188501_() >= 0.2f) {
            return;
        }
        int i = pRandom.m_188503_(3);
        ItemStack stack = new ItemStack((ItemLike)Items.f_42386_);
        if (i == 0) {
            stack = new ItemStack((ItemLike)TensuraToolItems.IRON_SPEAR.get());
        }
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
        this.inventory.m_6836_(4, stack);
        this.inventory.m_6596_();
    }

    @Override
    @Nullable
    public Item getEquipmentForArmorSlot(EquipmentSlot pSlot, int pChance) {
        switch (pSlot) {
            case HEAD: {
                if (pChance == 0) {
                    return Items.f_42407_;
                }
                if (pChance == 1) {
                    return Items.f_42468_;
                }
                return null;
            }
            case CHEST: {
                if (pChance == 0) {
                    return Items.f_42408_;
                }
                if (pChance == 1) {
                    return Items.f_42465_;
                }
                if (pChance == 2) {
                    return Items.f_42469_;
                }
                return null;
            }
            case LEGS: {
                if (pChance == 0) {
                    return Items.f_42462_;
                }
                if (pChance == 1) {
                    return Items.f_42466_;
                }
                if (pChance == 2) {
                    return Items.f_42470_;
                }
                return null;
            }
            case FEET: {
                if (pChance == 0) {
                    return Items.f_42463_;
                }
                if (pChance == 1) {
                    return Items.f_42467_;
                }
                if (pChance == 2) {
                    return Items.f_42471_;
                }
                return null;
            }
        }
        return null;
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return SoundEvents.f_12302_;
        }
        return this.m_6162_() ? SoundEvents.f_12239_ : SoundEvents.f_12301_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12304_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12303_;
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.shouldSwim()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.sitting", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            if (this.m_20096_() && this.m_21660_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.m_20096_() || !this.isInFluidType()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.shield", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.crossbow", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4 || this.m_6117_() && this.isSpearType(this.m_21211_())) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc.spear", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public class EvolvingLookControl
    extends TensuraTamableEntity.SleepLookControl {
        public EvolvingLookControl() {
            super(OrcEntity.this);
        }

        @Override
        public void m_8128_() {
            if (OrcEntity.this.getEvolving() <= 0) {
                super.m_8128_();
            }
        }
    }

    public class EvolvingMoveControl
    extends TensuraTamableEntity.SleepMoveControl {
        public EvolvingMoveControl() {
            super(OrcEntity.this);
        }

        @Override
        public void m_8126_() {
            if (OrcEntity.this.getEvolving() <= 0) {
                super.m_8126_();
            }
        }
    }

    static class FollowLordGoal
    extends Goal {
        private final OrcEntity orc;
        @Nullable
        private OrcLordEntity lord;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowLordGoal(OrcEntity orc, double pSpeedModifier) {
            this.orc = orc;
            this.speedModifier = pSpeedModifier;
        }

        public boolean m_8036_() {
            boolean lordLowHealth;
            if (this.orc.m_21824_()) {
                return false;
            }
            if (this.orc.m_21523_() || this.orc.m_20159_()) {
                return false;
            }
            List list = this.orc.f_19853_.m_45976_(OrcLordEntity.class, this.orc.m_20191_().m_82377_(30.0, 8.0, 30.0));
            OrcLordEntity lord = null;
            double d0 = Double.MAX_VALUE;
            for (OrcLordEntity parent : list) {
                double distance = this.orc.m_20280_((Entity)parent);
                if (!(distance <= d0)) continue;
                d0 = distance;
                lord = parent;
            }
            if (lord == null) {
                return false;
            }
            if (this.orc.m_5448_() != null && lord.m_21223_() > lord.m_21233_() / 8.0f) {
                return false;
            }
            boolean bl = lordLowHealth = lord.m_21223_() < lord.m_21233_() / 4.0f;
            if (d0 > 100.0 || lordLowHealth && d0 > 12.0) {
                this.lord = lord;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.orc.m_21824_()) {
                return false;
            }
            if (this.orc.m_21523_() || this.orc.m_20159_()) {
                return false;
            }
            if (this.orc.m_5448_() != null) {
                return false;
            }
            if (this.lord == null) {
                return false;
            }
            if (!this.lord.m_6084_()) {
                return false;
            }
            double d0 = this.orc.m_20280_((Entity)this.lord);
            return d0 >= 16.0 && d0 <= 100.0;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            if (this.orc.m_5803_()) {
                this.orc.setSleeping(false);
            }
        }

        public void m_8041_() {
            this.lord = null;
            this.orc.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (this.lord != null) {
                if (this.lord.m_5448_() != null && this.orc.m_5448_() == null && this.lord.m_5448_() != this.orc && this.lord.m_5448_().m_20270_((Entity)this.orc) <= 30.0f) {
                    this.orc.m_6710_(this.lord.m_5448_());
                }
                boolean isDisaster = this.lord instanceof OrcDisasterEntity;
                this.orc.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.INSPIRATION.get(), 200, isDisaster ? 1 : 0, false, false, false), (Entity)this.lord);
                this.orc.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.RAMPAGE.get(), 200, 0, false, false, false), (Entity)this.lord);
                if (isDisaster) {
                    this.orc.m_147207_(new MobEffectInstance(MobEffects.f_19605_, 200, 2, false, false, false), (Entity)this.lord);
                    this.orc.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.STRENGTHEN.get(), 200, 1, false, false, false), (Entity)this.lord);
                }
            }
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            if (this.lord == null) {
                return;
            }
            this.timeToRecalcPath = this.m_183277_(10);
            this.orc.m_21573_().m_5624_((Entity)this.lord, this.speedModifier);
        }
    }
}

