/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.api.entity.ai.CrossbowAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.OrcEntity;
import com.github.manasmods.tensura.entity.OrcLordEntity;
import com.github.manasmods.tensura.entity.magic.misc.ChaosEaterProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.items.TensuraToolItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.UniqueSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;

public class OrcDisasterEntity
extends OrcLordEntity {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).m_7005_(true).m_7003_(true);

    public OrcDisasterEntity(EntityType<? extends OrcDisasterEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends OrcLordEntity>)pEntityType, pLevel);
        this.f_21364_ = 8000;
        this.f_19793_ = 2.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22281_, 50.0).m_22268_(Attributes.f_22276_, 700.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 3.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 4.0).m_22265_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, new CrossbowAttackGoal<OrcDisasterEntity>(this, 1.2, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.SpearTypeAttackGoal(this, 1.0, 20, 15.0f));
        this.f_21345_.m_25352_(3, (Goal)new OrcDisasterAttackGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SummonOrcKnightsGoal(this, 15, 400));
        this.f_21345_.m_25352_(5, (Goal)new OrcLordEntity.RecoveryMagicGoal(this, 15, 100, 50.0f));
        this.f_21345_.m_25352_(6, (Goal)new WanderingFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, OrcEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossEvent.m_6456_(this.m_5446_());
        }
    }

    public boolean m_7301_(MobEffectInstance instance) {
        if (instance.m_19544_() == TensuraMobEffects.CORROSION.get()) {
            return false;
        }
        return super.m_7301_(instance);
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        if (DamageSourceHelper.isCorrosion(source)) {
            return true;
        }
        if (DamageSourceHelper.isPoison(source)) {
            return true;
        }
        return source == DamageSource.f_19315_ || source == DamageSource.f_19312_ || source == DamageSource.f_19310_ || source == DamageSource.f_19314_ || source == DamageSource.f_146703_ || source == DamageSource.f_19311_ || source == DamageSource.f_19325_ || super.m_6673_(source);
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.m_6543_(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.m_6539_(pPlayer);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
    }

    @Override
    protected void healAndEat() {
        this.m_5634_(10.0f);
        this.selfRegen = 20;
        if (this.m_146895_() != null && this.getMiscAnimation() <= 1) {
            this.setMiscAnimation(7);
        } else if (this.getMiscAnimation() <= 1 && this.m_146895_() == null) {
            boolean shouldEat;
            boolean bl = shouldEat = this.m_21223_() < this.m_21233_() / 4.0f && (double)this.f_19796_.m_188501_() <= 0.2 || this.m_21223_() < this.m_21233_() / 8.0f;
            if (!shouldEat) {
                return;
            }
            List list = this.f_19853_.m_45976_(OrcEntity.class, this.m_20191_().m_82400_(4.0));
            if (!list.isEmpty()) {
                for (OrcEntity sacrifice : list) {
                    if (sacrifice == this) continue;
                    this.setMiscAnimation(7);
                    sacrifice.m_7998_((Entity)this, true);
                    return;
                }
            }
        }
    }

    @Override
    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.m_6084_() && !this.f_19853_.f_46443_) {
                if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 15) {
                    this.areaAttack(2.0f, 1.25f);
                    TensuraParticleHelper.spawnServerGroundSlamParticle((LivingEntity)this, 5, 5.0f);
                    TensuraParticleHelper.spawnServerGroundSlamParticle((LivingEntity)this, 5, 3.0f);
                    TensuraParticleHelper.spawnServerGroundSlamParticle((LivingEntity)this, 10, 3.5f);
                    this.m_5496_(SoundEvents.f_215778_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                        SkillHelper.launchBlock((Entity)this, this.m_20182_(), 4, 1, 0.5f, 0.4f, blockState -> {
                            if (this.m_217043_().m_188503_(3) != 1) {
                                return false;
                            }
                            return blockState.m_204336_(TensuraTags.Blocks.EARTH_MANIPULATING);
                        }, blockPos -> !blockPos.equals((Object)this.m_20097_().m_7495_()));
                    }
                } else if (this.getMiscAnimation() == 4) {
                    Entity entity;
                    LivingEntity target = this.m_5448_();
                    if (this.miscAnimationTicks == 10 && this.m_146895_() == null) {
                        if (target != null && target.m_20270_((Entity)this) <= 5.0f && target != this) {
                            target.m_7998_((Entity)this, true);
                        }
                    } else if (this.miscAnimationTicks == 23 && (entity = this.m_146895_()) instanceof LivingEntity) {
                        LivingEntity passenger = (LivingEntity)entity;
                        passenger.m_8127_();
                        passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * 2.5));
                        this.m_5496_(SoundEvents.f_11913_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 7) {
                    Entity target2;
                    if (this.miscAnimationTicks == 15 && this.m_146895_() == null) {
                        LivingEntity target2 = this.m_5448_();
                        if (target2 != null && target2.m_20270_((Entity)this) <= 5.0f && target2 != this) {
                            target2.m_7998_((Entity)this, true);
                        }
                    } else if (this.miscAnimationTicks == 30 && (target2 = this.m_146895_()) instanceof LivingEntity) {
                        LivingEntity passenger = (LivingEntity)target2;
                        passenger.m_8127_();
                        float HP = passenger.m_21223_();
                        passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this).m_19380_(), (float)(this.m_21133_(Attributes.f_22281_) * 3.5));
                        if (!passenger.m_6084_()) {
                            this.m_5634_(HP * 3.0f);
                        } else {
                            this.m_5634_(75.0f);
                        }
                        this.m_5496_(SoundEvents.f_215769_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                    }
                } else if (this.getMiscAnimation() == 9 && this.miscAnimationTicks == 25) {
                    int amount = this.m_21223_() <= this.m_21233_() / 2.0f ? 6 : 4;
                    this.spawnChaosEater((LivingEntity)this, amount, 1.2f);
                    TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
                    this.m_5496_(SoundEvents.f_215769_, 10.0f, 0.95f + this.f_19796_.m_188501_() * 0.1f);
                }
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            default -> 11;
            case 2 -> 15;
            case 3 -> 20;
            case 4 -> 30;
            case 5, 6, 7, 9 -> 35;
            case 8 -> 25;
        };
    }

    private void spawnChaosEater(LivingEntity entity, int amount, float distance) {
        int rot = 360 / amount;
        for (int i = 0; i < amount; ++i) {
            Vec3 offset = new Vec3(0.0, (double)distance, 0.0).m_82535_(((float)(rot * i) - (float)rot / 2.0f) * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            Vec3 offPos = entity.m_146892_().m_82549_(offset);
            ChaosEaterProjectile chaosEater = new ChaosEaterProjectile(entity.m_9236_(), entity);
            chaosEater.m_146884_(offPos);
            chaosEater.setUpStartPos(amount, i, distance);
            LivingEntity target = this.m_5448_();
            List<LivingEntity> list = this.getTargetList();
            if (i != 0 && !list.isEmpty()) {
                target = list.get(this.m_217043_().m_188503_(list.size()));
            }
            chaosEater.setTarget(target);
            chaosEater.setSpeed(1.0f);
            chaosEater.shootFromRot(entity.m_20154_());
            chaosEater.setLife(300);
            chaosEater.setDamage((float)entity.m_21133_(Attributes.f_22281_));
            chaosEater.setMobEffect(new MobEffectInstance((MobEffect)TensuraMobEffects.CORROSION.get(), 200, 3, false, false, false));
            chaosEater.setEffectRange(1.5f);
            chaosEater.setMpCost(200.0);
            chaosEater.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)UniqueSkills.STARVED.get()));
            entity.m_9236_().m_7967_((Entity)chaosEater);
        }
    }

    private List<LivingEntity> getTargetList() {
        AABB box = this.m_20191_().m_82400_(Math.min(50.0, this.m_21133_(Attributes.f_22277_)));
        return this.m_9236_().m_6443_(LivingEntity.class, box, this::shouldAttack);
    }

    protected void m_6153_() {
        if (++this.f_20919_ >= 35) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_5496_(SoundEvents.f_11913_, 10.0f, 1.0f);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get());
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.CHAOS_EATER_EFFECT.get(), 2.0);
            TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123765_, 2.0);
        }
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.m_6084_()) {
            return;
        }
        if (this.m_20089_() == Pose.DYING) {
            this.setMiscAnimation(10);
        }
    }

    @Override
    protected float m_21519_(EquipmentSlot pSlot) {
        if (this.m_21824_()) {
            return 0.0f;
        }
        if (pSlot.equals((Object)EquipmentSlot.MAINHAND)) {
            return 1.0f;
        }
        return super.m_21519_(pSlot);
    }

    @Override
    protected void dropBlood() {
        int amount = this.m_217043_().m_216339_(1, 4);
        for (int i = 0; i < amount; ++i) {
            this.m_19998_((ItemLike)TensuraMobDropItems.ROYAL_BLOOD.get());
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            if (this.m_20096_() && this.m_21660_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.m_20096_() || !this.isInFluidType()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 10) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.cry", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            switch (this.getMiscAnimation()) {
                case 1: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.punch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 2: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.cleaver_swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 3: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.slam", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 4: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.crush", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 5: 
                case 9: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.yell", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 6: 
                case 7: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                    break;
                }
                case 8: {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.orc_disaster.recover", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
                }
            }
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public class OrcDisasterAttackGoal
    extends HumanoidNPCEntity.NPCMeleeAttackGoal {
        public final OrcDisasterEntity orc;

        public OrcDisasterAttackGoal(OrcDisasterEntity beast) {
            super(OrcDisasterEntity.this, (PathfinderMob)beast, 2.0, true);
            this.orc = beast;
        }

        public void m_8037_() {
            if (this.orc.getMiscAnimation() > 2) {
                return;
            }
            super.m_8037_();
        }

        protected void m_6739_(LivingEntity pEnemy, double pDistToEnemySqr) {
            double d0 = this.m_6639_(pEnemy);
            if (this.orc.getMiscAnimation() == 0 || this.orc.getMiscAnimation() == 1) {
                double attackRange;
                int randomAttack = this.randomAttack(pEnemy, pDistToEnemySqr);
                switch (randomAttack) {
                    case 9: {
                        double d = 2500.0;
                        break;
                    }
                    case 4: {
                        double d = d0 + 9.0;
                        break;
                    }
                    case 3: {
                        double d = d0 + 16.0;
                        break;
                    }
                    case 2: {
                        double d = d0 + 4.0;
                        break;
                    }
                    default: {
                        double d = attackRange = d0;
                    }
                }
                if (pDistToEnemySqr <= attackRange && this.m_25564_()) {
                    this.m_25563_();
                    this.orc.setMiscAnimation(randomAttack);
                    if (randomAttack == 3 || randomAttack == 7) {
                        this.orc.m_21573_().m_26573_();
                    }
                    if (randomAttack == 1 || randomAttack == 2) {
                        this.orc.m_7327_((Entity)pEnemy);
                    }
                }
            }
        }

        protected int randomAttack(LivingEntity target, double distSqr) {
            if ((double)this.orc.f_19796_.m_188501_() <= 0.2 && distSqr <= 20.0 && !target.m_20159_() && !target.m_20160_() && target != this.orc) {
                if (target.m_21223_() <= target.m_21233_() / 5.0f) {
                    return 7;
                }
                return 4;
            }
            if ((double)this.orc.f_19796_.m_188501_() <= 0.2 && distSqr <= 2500.0 && (distSqr >= 10.0 || target.m_20186_() >= this.orc.m_20186_() + 6.0) && this.orc.getStarved() != null) {
                return 9;
            }
            if ((double)this.orc.f_19796_.m_188501_() <= 0.3) {
                return 3;
            }
            if (this.orc.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
                return 1;
            }
            return 2;
        }

        @Override
        protected double m_6639_(LivingEntity pAttackTarget) {
            double attackRange = this.orc.m_21133_((Attribute)ForgeMod.ATTACK_RANGE.get());
            return super.m_6639_(pAttackTarget) + attackRange * attackRange;
        }
    }

    public static class SummonOrcKnightsGoal
    extends OrcLordEntity.SummonOrcsGoal {
        private final OrcLordEntity orcLord;

        public SummonOrcKnightsGoal(OrcLordEntity lord, int castWarmUpTime, int castingInterval) {
            super(lord, castWarmUpTime, castingInterval);
            this.orcLord = lord;
        }

        @Override
        protected void performSpellCasting() {
            if (!this.summonAtSpawn) {
                this.summonAtSpawn = true;
            }
            this.summonOrcRandomPos(5, 0, 10);
        }

        @Override
        protected void makeKnight(OrcEntity orc) {
            ItemStack helmet = new ItemStack((ItemLike)Items.f_42480_);
            ItemStack chest = new ItemStack((ItemLike)Items.f_42481_);
            ItemStack leggings = new ItemStack((ItemLike)Items.f_42482_);
            ItemStack boots = new ItemStack((ItemLike)Items.f_42483_);
            ItemStack weapon = new ItemStack((ItemLike)(this.orcLord.m_217043_().m_188499_() ? (ItemLike)TensuraToolItems.IRON_SPEAR.get() : Items.f_42386_));
            if ((double)this.orcLord.m_217043_().m_188501_() <= 0.3) {
                weapon = this.orcLord.m_217043_().m_188499_() ? new ItemStack((ItemLike)TensuraToolItems.WAR_BOW.get()) : new ItemStack((ItemLike)Items.f_42717_);
            }
            orc.m_8061_(EquipmentSlot.HEAD, helmet);
            orc.m_8061_(EquipmentSlot.CHEST, chest);
            orc.m_8061_(EquipmentSlot.LEGS, leggings);
            orc.m_8061_(EquipmentSlot.FEET, boots);
            orc.m_8061_(EquipmentSlot.MAINHAND, weapon);
            if ((double)this.orcLord.m_217043_().m_188501_() <= 0.2) {
                orc.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
            }
        }
    }
}

