/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.api.entity.ai.PanicAroundEntityGoal;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.controller.JumpingEntityMoveControl;
import com.github.manasmods.tensura.api.entity.subclass.IJumpingEntity;
import com.github.manasmods.tensura.entity.SlimeEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.SlimeType;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class MetalSlimeEntity
extends SlimeEntity {
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public static final AnimationBuilder IDLE = new AnimationBuilder().addAnimation("animation.slime.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder WALK = new AnimationBuilder().addAnimation("animation.slime.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder JUMPING = new AnimationBuilder().addAnimation("animation.slime.jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder DAMAGED = new AnimationBuilder().addAnimation("animation.slime.hurt", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    protected int regenAmount;

    public MetalSlimeEntity(EntityType<? extends MetalSlimeEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends SlimeEntity>)pEntityType, pLevel);
        this.f_21342_ = new MetalSlimeMoveControl((PathfinderMob)this);
        this.regenAmount = 4;
        this.f_21364_ = 400;
        this.setSize(4, false, false, false);
        this.setType(SlimeType.MERGE);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22288_, 1.2).m_22268_(Attributes.f_22279_, 2.0).m_22265_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this, 60, 1.0, 10, 7));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(1, new PanicAroundEntityGoal<Player>((PathfinderMob)this, 2.0, Player.class, 16.0f));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            public boolean m_8036_() {
                if (!MetalSlimeEntity.this.m_21824_()) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new WanderingFollowOwnerGoal(this, 0.2, 20.0f, 5.0f, false));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.waterMovement();
    }

    @Override
    protected void selfRegen() {
        this.m_5634_(this.regenAmount);
        this.selfRegen = 20;
    }

    protected void waterMovement() {
        if (!this.m_20069_()) {
            return;
        }
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
    }

    @Override
    public boolean m_6673_(DamageSource source) {
        return this.ignoreDamageSource(source) || super.m_6673_(source);
    }

    @Override
    public void setSize(int pSize, boolean pResetHealth) {
        this.setSize(pSize, true, pResetHealth, false);
    }

    public boolean ignoreDamageSource(DamageSource source) {
        LivingEntity living;
        TensuraDamageSource damageSource;
        if (source instanceof TensuraDamageSource && (damageSource = (TensuraDamageSource)source).getIgnoreResistance() >= 1.0f) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && SkillUtils.reducingResistances(living = (LivingEntity)entity)) {
            return false;
        }
        return DamageSourceHelper.isNaturalEffects(source);
    }

    @Override
    public int getJumpDelay() {
        return this.f_19796_.m_188503_(10);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    public boolean playerInRadius() {
        return !this.f_19853_.m_6443_(Player.class, this.m_20191_().m_82377_(10.0, 10.0, 10.0), player -> !player.m_7500_() && !player.m_5833_()).isEmpty();
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    @Override
    protected void m_6135_() {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, (double)this.m_6118_() * 2.0, vec3.f_82481_);
        this.f_19812_ = true;
    }

    @Override
    public boolean isTamingFood(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isDyeable() {
        return false;
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            if ((this.m_20096_() || this.m_20072_() || this.m_20077_() || this.f_19798_) && !this.isHurt()) {
                event.getController().setAnimation(WALK);
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(DAMAGED);
            return PlayState.CONTINUE;
        }
        if (this.m_20096_()) {
            event.getController().setAnimation(IDLE);
        }
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState hurtPredicate(AnimationEvent<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) && this.isHurt()) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(DAMAGED);
        }
        return PlayState.CONTINUE;
    }

    private <T extends IAnimatable> PlayState crouchPredicate(AnimationEvent<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped) && this.jump()) {
            event.getController().markNeedsReload();
            event.getController().setAnimation(JUMPING);
        }
        return PlayState.CONTINUE;
    }

    @Override
    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "hurtController", 0.0f, this::hurtPredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "crouchController", 0.0f, this::crouchPredicate));
    }

    @Override
    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected static class MetalSlimeMoveControl
    extends JumpingEntityMoveControl {
        public MetalSlimeMoveControl(PathfinderMob slimeIn) {
            super(slimeIn, 0.05f);
        }

        @Override
        public void setJumpDelay(IJumpingEntity jumpingEntity) {
            MetalSlimeEntity slime;
            this.jumpDelay = jumpingEntity.getJumpDelay();
            if (this.mob.m_5448_() == null) {
                return;
            }
            PathfinderMob pathfinderMob = this.mob;
            if (!(pathfinderMob instanceof MetalSlimeEntity) || !(slime = (MetalSlimeEntity)pathfinderMob).playerInRadius()) {
                return;
            }
            this.jumpDelay /= 2;
        }
    }
}

