/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.api.entity.ai.FindWaterGoal;
import com.github.manasmods.tensura.api.entity.ai.LeaveWaterGoal;
import com.github.manasmods.tensura.api.entity.ai.SemiAquaticFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.SemiAquaticRandomSwimmingGoal;
import com.github.manasmods.tensura.api.entity.controller.AquaticMoveController;
import com.github.manasmods.tensura.api.entity.navigator.SemiAquaticNavigator;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.api.entity.subclass.ISemiAquatic;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.LandfishVariant;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LandfishEntity
extends TensuraTamableEntity
implements IAnimatable,
ISemiAquatic,
IFollower,
IRanking {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(LandfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EVOLUTION_STATE = SynchedEntityData.m_135353_(LandfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(LandfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MOISTNESS_LEVEL = SynchedEntityData.m_135353_(LandfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int miscAnimationTicks = 0;
    public float prevSwimProgress;
    public float swimProgress;
    private int swimTimer = -1000;
    private boolean isLandNavigator;
    @Nullable
    private UUID lastLightningBoltUUID;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public LandfishEntity(EntityType<? extends LandfishEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        this.f_19793_ = 1.0f;
        this.f_21364_ = 5;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, (double)0.01f).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new SemiAquaticFollowOwnerGoal(this, 1.5, 10.0f, 5.0f, false, false));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(4, (Goal)new FindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(5, (Goal)new LeaveWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.2, Ingredient.m_204132_(TensuraTags.Items.FISHES), false));
        this.f_21345_.m_25352_(7, (Goal)new SemiAquaticRandomSwimmingGoal((Animal)this, 1.2, 30));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this, 60, 1.0, 10, 7));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((LandfishEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Dolphin.class, false, null));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Guardian.class, false, null));
        this.f_21346_.m_25352_(7, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new AquaticMoveController((PathfinderMob)this, 1.1f);
            this.f_21344_ = new SemiAquaticNavigator((Mob)this, this.f_19853_);
            this.isLandNavigator = false;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(EVOLUTION_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(MOISTNESS_LEVEL, (Object)3000);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("EvoState", this.getCurrentEvolutionState());
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("SwimTimer", this.swimTimer);
        compound.m_128405_("Moistness", this.getMoistnessLevel());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setCurrentEvolutionState(compound.m_128451_("EvoState"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)compound.m_128451_("Variant"));
        this.swimTimer = compound.m_128451_("SwimTimer");
        this.setMoistnessLevel(compound.m_128451_("Moistness"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public LandfishVariant getVariant() {
        return LandfishVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(LandfishVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public int getMoistnessLevel() {
        return (Integer)this.f_19804_.m_135370_(MOISTNESS_LEVEL);
    }

    public void setMoistnessLevel(int pMoistnessLevel) {
        this.f_19804_.m_135381_(MOISTNESS_LEVEL, (Object)pMoistnessLevel);
    }

    @Override
    public boolean shouldEnterWater() {
        if (this.getMoistnessLevel() <= 300 && !this.m_21827_()) {
            if (this.m_5448_() != null) {
                this.m_6710_(null);
            }
            return true;
        }
        return !this.shouldLeaveWater() && this.swimTimer <= -1000;
    }

    @Override
    public boolean shouldLeaveWater() {
        if (this.m_5448_() != null && !this.m_5448_().m_20069_()) {
            return true;
        }
        return this.swimTimer > 600;
    }

    @Override
    public boolean shouldStopMoving() {
        return this.m_21827_();
    }

    @Override
    public int getWaterSearchRange() {
        return 45;
    }

    public boolean isPushedByFluid(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    public boolean m_6914_(LevelReader worldIn) {
        return worldIn.m_45784_((Entity)this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    @Override
    public boolean shouldFollow() {
        return !this.m_21827_() && !this.isWandering() && (this.m_5448_() == null || !this.m_5448_().m_6084_()) && this.getMoistnessLevel() >= 300;
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag) {
            if (this.getMiscAnimation() == 0) {
                this.setMiscAnimation(1);
            }
            if (this.m_217043_().m_188503_(4) == 1 && pEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)pEntity;
                switch (this.getVariant()) {
                    case ELDER_GUARDIAN: {
                        target.m_147207_(new MobEffectInstance(MobEffects.f_19599_, 400, 1, false, false, true), (Entity)this);
                        break;
                    }
                    case PUFFER: {
                        target.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 100, 1, false, false, true), (Entity)this);
                    }
                }
            }
        }
        return flag;
    }

    @Override
    public int getCurrentEvolutionState() {
        return (Integer)this.f_19804_.m_135370_(EVOLUTION_STATE);
    }

    @Override
    public void setCurrentEvolutionState(int state) {
        this.f_19804_.m_135381_(EVOLUTION_STATE, (Object)state);
    }

    @Override
    public void evolve() {
        int current = this.getCurrentEvolutionState();
        if (current < this.getMaxEvolutionState()) {
            this.setCurrentEvolutionState(current + 1);
            if (this.getVariant().equals((Object)LandfishVariant.GUARDIAN)) {
                this.setVariant(LandfishVariant.ELDER_GUARDIAN);
            }
        }
    }

    public void m_8038_(ServerLevel pLevel, LightningBolt pLightning) {
        if (!this.getVariant().equals((Object)LandfishVariant.GUARDIAN)) {
            return;
        }
        UUID uuid = pLightning.m_20148_();
        if (!uuid.equals(this.lastLightningBoltUUID)) {
            this.setVariant(LandfishVariant.ELDER_GUARDIAN);
            AttributeInstance health = this.m_21051_(Attributes.f_22276_);
            if (health != null) {
                health.m_22100_(health.m_22115_() + 10.0);
            }
            this.m_5634_(this.m_21233_());
            this.lastLightningBoltUUID = uuid;
            this.m_5496_(SoundEvents.f_11880_, 2.0f, 1.0f);
        }
    }

    private boolean needWater() {
        if (this.getVariant().getId() >= 5) {
            return false;
        }
        return !this.m_21023_(MobEffects.f_19608_);
    }

    @Override
    public void m_8119_() {
        boolean ground;
        super.m_8119_();
        this.prevSwimProgress = this.swimProgress;
        boolean bl = ground = !this.m_20072_();
        if (!ground && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (ground && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (ground && this.swimProgress > 0.0f) {
            this.swimProgress -= 1.0f;
        }
        if (!ground && this.swimProgress < 5.0f) {
            this.swimProgress += 1.0f;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.m_20071_()) {
                this.setMoistnessLevel(3000);
            } else if (this.needWater()) {
                this.setMoistnessLevel(this.getMoistnessLevel() - 1);
                if (this.getMoistnessLevel() <= 0) {
                    this.m_6469_(DamageSource.f_19324_, 1.0f);
                }
            }
            this.swimTimer = this.m_20069_() ? ++this.swimTimer : --this.swimTimer;
        } else if (this.m_20069_() && this.m_20184_().m_82556_() > 0.01) {
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            }
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            default -> 10;
            case 1 -> 9;
            case 2 -> 31;
        };
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11758_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11761_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11759_;
    }

    public void m_27563_(ServerLevel pLevel, Animal pMate) {
        super.m_27563_(pLevel, pMate);
        this.setMiscAnimation(3);
    }

    @Override
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        LandfishVariant variant;
        int i;
        LandfishEntity fish = (LandfishEntity)((EntityType)TensuraEntityTypes.LANDFISH.get()).m_20615_((Level)pLevel);
        if (fish == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            fish.m_21816_(uuid);
            fish.m_7105_(true);
        }
        if ((i = this.f_19796_.m_188503_(9)) < 3) {
            variant = this.getVariant();
        } else if (i < 6 && pOtherParent instanceof LandfishEntity) {
            LandfishEntity entity = (LandfishEntity)pOtherParent;
            variant = entity.getVariant();
        } else {
            variant = this.randomVariant((ServerLevelAccessor)pLevel);
        }
        fish.setVariant(variant);
        return fish;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.COOKED_FISHES);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        if (this.m_6898_(itemstack)) {
            if (this.m_21223_() < this.m_21233_()) {
                if (!player.m_7500_()) {
                    itemstack.m_41774_(1);
                }
                this.m_5634_(3.0f);
                this.setMiscAnimation(2);
                this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            int i = this.m_146764_();
            if (!this.f_19853_.m_5776_() && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_27595_(player);
                this.setMiscAnimation(1);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146740_(LandfishEntity.m_216967_((int)(-i)), true);
                this.setMiscAnimation(2);
                this.m_9236_().m_6269_(player, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        } else if (itemstack.m_150930_(Items.f_42447_)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
            }
            this.setMoistnessLevel(3000);
            this.setMiscAnimation(3);
            if (this.f_19796_.m_188503_(5) == 0) {
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12018_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42446_);
                if (!player.m_36356_(stack)) {
                    player.m_36176_(stack, false);
                }
                this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_11911_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || itemstack.m_204117_(TensuraTags.Items.FISHES);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (!super.m_6071_(player, hand).m_19077_() && this.m_21830_((LivingEntity)player) && !this.m_6162_()) {
                this.commanding(player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        if (itemstack.m_204117_(TensuraTags.Items.FISHES)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.setMiscAnimation(3);
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public static boolean checkLandfishSpawnRules(EntityType<LandfishEntity> fish, LevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        int i = pLevel.m_5736_();
        int j = i - 13;
        return pPos.m_123342_() >= j && pPos.m_123342_() <= i && pLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.landfishSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setVariant(this.randomVariant(pLevel));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    private LandfishVariant randomVariant(ServerLevelAccessor pLevel) {
        if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207602_)) {
            return LandfishVariant.byId(this.m_217043_().m_188503_(8));
        }
        if (pLevel.m_204166_(this.m_20183_()).m_203656_(BiomeTags.f_207603_)) {
            return LandfishVariant.byId(this.m_217043_().m_188503_(7));
        }
        return LandfishVariant.byId(this.m_217043_().m_188503_(5));
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            if (this.isInFluidType()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else if (this.m_21223_() < this.m_21233_() / 4.0f) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.walk_hurt", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.isInFluidType()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.idle_swim", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.stay", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21223_() < this.m_21233_() / 4.0f) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.idle_hurt", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.slap", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2 && !this.m_21825_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.eat", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.landfish.jump", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

