/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.ManasSkillInstance;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.ai.TamableFollowParentGoal;
import com.github.manasmods.tensura.api.entity.ai.UndergroundTargetingEntitiesGoal;
import com.github.manasmods.tensura.api.entity.navigator.NoSpinFlightPathNavigator;
import com.github.manasmods.tensura.api.entity.subclass.IFollower;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.capability.effects.TensuraEffectsCapability;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.IfritEntity;
import com.github.manasmods.tensura.entity.SalamanderEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierEntity;
import com.github.manasmods.tensura.entity.magic.barrier.BarrierPart;
import com.github.manasmods.tensura.entity.magic.barrier.FlareCircleEntity;
import com.github.manasmods.tensura.entity.magic.skill.FlameOrbProjectile;
import com.github.manasmods.tensura.entity.template.HumanoidNPCEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.network.TensuraNetwork;
import com.github.manasmods.tensura.network.play2client.RequestFxSpawningPacket;
import com.github.manasmods.tensura.race.RaceHelper;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.magic.SpiritualMagics;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PacketDistributor;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class IfritCloneEntity
extends HumanoidNPCEntity
implements IAnimatable,
FlyingAnimal,
IFollower,
IGiantMob {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(IfritCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(IfritCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<BlockPos> FLARE_POS = SynchedEntityData.m_135353_(IfritCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> FLARE_ID = SynchedEntityData.m_135353_(IfritCloneEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public float prevFlyProgress;
    public float flyProgress;
    protected boolean wasFlying;
    public int timeFlying = 0;
    public int miscAnimationTicks = 0;

    public IfritCloneEntity(EntityType<? extends IfritCloneEntity> pEntityType, Level pLevel) {
        super((EntityType<? extends HumanoidNPCEntity>)pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
        this.f_19793_ = 2.0f;
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand || this.m_5803_()) {
            this.f_21342_ = new TensuraTamableEntity.SleepMoveControl(){

                @Override
                public void m_8126_() {
                    if (IfritCloneEntity.this.getMiscAnimation() >= 5) {
                        return;
                    }
                    super.m_8126_();
                }
            };
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.f_19853_);
            this.wasFlying = false;
        } else {
            this.f_21342_ = new IfritMoveControl();
            this.f_21344_ = new NoSpinFlightPathNavigator((Mob)this, this.f_19853_);
            this.wasFlying = true;
        }
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ATTACK_RANGE.get(), 3.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new HumanoidNPCEntity.EatingItemGoal(this, entity -> this.shouldHeal(), 3.0f));
        this.f_21345_.m_25352_(3, (Goal)new HumanoidNPCEntity.NPCMeleeAttackGoal((PathfinderMob)this, 2.0, true){

            @Override
            public boolean m_8036_() {
                if (!super.m_8036_()) {
                    return false;
                }
                return IfritCloneEntity.this.usingMeleeWeapon();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new IfritAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FollowIfritGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(6, (Goal)new TamableFollowParentGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(7, (Goal)new WalkGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, IfritEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, new UndergroundTargetingEntitiesGoal<LivingEntity>(this, LivingEntity.class, false, 8.0f, this::shouldAttack));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean shouldAttack(LivingEntity entity) {
        SalamanderEntity salamander;
        Player player;
        if (entity == this) {
            return false;
        }
        if (!entity.m_6084_()) {
            return false;
        }
        if (this.m_21826_() != null) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                return mob.m_5448_() == this.m_21826_();
            }
            return this.m_21826_().m_21214_() == entity || this.m_21826_().m_21188_() == entity;
        }
        if (entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_()) {
            return true;
        }
        return !(entity instanceof SalamanderEntity && !(salamander = (SalamanderEntity)entity).m_21824_());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(FLARE_ID, (Object)0);
        this.f_19804_.m_135372_(FLARE_POS, (Object)BlockPos.f_121853_);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128379_("Flying", this.m_29443_());
        compound.m_128405_("FlareID", this.getFlareID());
        compound.m_128347_("FlareX", (double)this.getFlarePos().m_123341_());
        compound.m_128347_("FlareY", (double)this.getFlarePos().m_123342_());
        compound.m_128347_("FlareZ", (double)this.getFlarePos().m_123343_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setFlying(compound.m_128471_("Flying"));
        this.setFlareID(compound.m_128451_("FlareID"));
        this.setFlarePos(compound.m_128459_("FlareX"), compound.m_128459_("FlareY"), compound.m_128459_("FlareZ"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    @Override
    public void setMiscAnimation(int tick) {
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)tick);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public int getFlareID() {
        return (Integer)this.f_19804_.m_135370_(FLARE_ID);
    }

    public void setFlareID(int id) {
        this.f_19804_.m_135381_(FLARE_ID, (Object)id);
    }

    public BlockPos getFlarePos() {
        return (BlockPos)this.f_19804_.m_135370_(FLARE_POS);
    }

    public void setFlarePos(double x, double y, double z) {
        this.f_19804_.m_135381_(FLARE_POS, (Object)new BlockPos(x, y, z));
    }

    public void m_21839_(boolean pOrderedToSit) {
        super.m_21839_(pOrderedToSit);
        if (pOrderedToSit && this.m_217043_().m_188503_(4) == 1) {
            this.setMiscAnimation(-1);
        }
    }

    public boolean m_6060_() {
        return TensuraEffectsCapability.hasSyncedEffect((LivingEntity)this, (MobEffect)TensuraMobEffects.BLACK_BURN.get());
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        if (this.m_5803_()) {
            return entitydimensions.m_20390_(1.0f, 2.0f);
        }
        return entitydimensions;
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        LivingEntity living;
        Entity entity;
        boolean spiritualAttacker;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_21824_()) {
            HumanoidNPCEntity ifrit;
            SalamanderEntity salamander;
            Entity entity2 = pSource.m_7639_();
            if (entity2 instanceof SalamanderEntity && !(salamander = (SalamanderEntity)entity2).m_21824_()) {
                return false;
            }
            entity2 = pSource.m_7639_();
            if (entity2 instanceof IfritCloneEntity && !(ifrit = (IfritCloneEntity)entity2).m_21824_()) {
                return false;
            }
            entity2 = pSource.m_7639_();
            if (entity2 instanceof IfritEntity && !(ifrit = (IfritEntity)entity2).m_21824_()) {
                return false;
            }
        }
        boolean bl = spiritualAttacker = (entity = pSource.m_7640_()) instanceof LivingEntity && RaceHelper.isSpiritual(living = (LivingEntity)entity);
        if (DamageSourceHelper.isPhysicalAttack(pSource) && !spiritualAttacker) {
            pAmount *= 0.05f;
        }
        if (IfritEntity.shouldEvaporateProjectile(pSource.m_7640_())) {
            this.m_5496_(SoundEvents.f_12031_, 1.0f, 0.8f);
            pSource.m_7640_().m_142687_(Entity.RemovalReason.KILLED);
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (!this.m_21824_()) {
            HumanoidNPCEntity ifrit;
            SalamanderEntity salamander;
            if (pTarget instanceof SalamanderEntity && !(salamander = (SalamanderEntity)pTarget).m_21824_()) {
                return false;
            }
            if (pTarget instanceof IfritCloneEntity && !(ifrit = (IfritCloneEntity)pTarget).m_21824_()) {
                return false;
            }
            if (pTarget instanceof IfritEntity && !(ifrit = (IfritEntity)pTarget).m_21824_()) {
                return false;
            }
        }
        return super.m_6779_(pTarget);
    }

    public void copySkills(LivingEntity owner) {
        this.m_6593_(owner.m_7755_());
        for (MobEffectInstance instance : owner.m_21220_()) {
            this.m_7292_(instance);
        }
        List<ManasSkillInstance> list = List.copyOf(SkillAPI.getSkillsFrom((Entity)owner).getLearnedSkills());
        for (ManasSkillInstance instance : list) {
            ManasSkillInstance skillInstance = TensuraSkillInstance.fromNBT((CompoundTag)instance.toNBT());
            skillInstance.setToggled(true);
            SkillAPI.getSkillsFrom((Entity)this).learnSkill(skillInstance);
        }
    }

    @Override
    public boolean shouldFollow() {
        return !this.m_21827_() && !this.isWandering() && (this.m_5448_() == null || !this.m_5448_().m_6084_());
    }

    @Override
    public boolean shouldSwim() {
        return false;
    }

    @Override
    public boolean m_7243_(ItemStack pStack) {
        return false;
    }

    @Override
    public boolean canEquipSlots(EquipmentSlot slot) {
        if (!super.canEquipSlots(slot)) {
            return false;
        }
        return !slot.m_20743_().equals((Object)EquipmentSlot.Type.ARMOR);
    }

    private boolean usingMeleeWeapon() {
        Item item = this.m_21205_().m_41720_();
        if (item instanceof AxeItem) {
            return true;
        }
        return item instanceof SwordItem;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isColliding((LivingEntity)this, false)) {
            List list;
            if (this.f_19797_ % 20 == 0 && !(list = this.f_19853_.m_45976_(BarrierPart.class, this.m_20191_().m_82400_(1.0))).isEmpty()) {
                for (BarrierPart barrier : list) {
                    this.m_7327_((Entity)barrier);
                }
            }
            if (!this.m_21824_() && this.m_29443_() && this.m_5448_() != null) {
                this.breakBlocks((LivingEntity)this, 2.0f, true, 0, null, true);
            }
        }
        if (this.m_20072_() && this.f_19797_ % 10 == 0 && this.removeFluid((LivingEntity)this, FluidTags.f_13131_, 3.0f, true, 0)) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12031_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Override
    public boolean breakableBlocks(LivingEntity entity, BlockPos pos, BlockState state) {
        if (state.m_204336_(TensuraTags.Blocks.BOSS_IMMUNE)) {
            return false;
        }
        return ForgeEventFactory.onEntityDestroyBlock((LivingEntity)entity, (BlockPos)pos, (BlockState)state);
    }

    @Override
    public boolean dropBlockLoot(LivingEntity entity, BlockState state) {
        return !state.m_204336_(TensuraTags.Blocks.SKILL_BREAK_EASY);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.handleFlying();
        this.miscAnimationHandler();
        if (!this.f_19853_.m_5776_()) {
            List list;
            if (this.m_20202_() instanceof Boat || this.m_20202_() instanceof AbstractMinecart) {
                this.m_20202_().m_6469_(DamageSource.m_19370_((LivingEntity)this), 40.0f);
            }
            if (this.f_19797_ % 100 == 0 && (list = this.f_19853_.m_45971_(IfritEntity.class, TargetingConditions.m_148353_().m_26883_(32.0).m_148355_().m_26893_(), (LivingEntity)this, this.m_20191_().m_82400_(32.0))).isEmpty()) {
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123756_, 1.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.RED_FIRE.get(), 2.0);
                this.m_146870_();
            }
        } else if (this.m_6084_()) {
            if (this.f_19797_ % 10 == 0) {
                TensuraParticleHelper.addParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.RED_FIRE.get(), 2.0);
            }
            Vec3 vec3 = this.m_20252_(1.0f).m_82541_();
            float radius = -0.15f;
            double yPos = this.m_20188_() + (double)0.2f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = Mth.m_14089_((float)angle);
            if (this.m_5803_()) {
                yPos -= (double)0.2f;
                radius = -0.5f;
            } else if (this.getMiscAnimation() == -1) {
                yPos -= (double)1.6f;
                radius = 0.6f;
            } else if (this.getMiscAnimation() == 7) {
                radius = -0.3f;
                yPos -= (double)0.1f;
            } else if (this.m_20184_().m_82556_() > 0.03 && this.getMiscAnimation() < 5 && this.getMiscAnimation() != 3) {
                if (!this.m_20096_()) {
                    yPos -= (double)0.2f;
                    radius = 0.3f;
                } else if (this.m_21660_()) {
                    radius = 0.0f;
                }
            }
            for (int i = 0; i < 15; ++i) {
                double ox = Math.random() * 0.3 - 0.15;
                double oy = Math.random() * 0.3 - 0.15;
                double oz = Math.random() * 0.3 - 0.15;
                Vec3 randomVec = new Vec3(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).m_82541_();
                Vec3 result = vec3.m_82490_(-1.0).m_82549_(randomVec).m_82541_().m_82490_(0.1);
                this.m_9236_().m_7106_((ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), this.m_20185_() - vec3.f_82479_ * 0.1 + ox + extraX * (double)radius, yPos + oy, this.m_20189_() - vec3.f_82481_ * 0.1 + oz + extraZ * (double)radius, result.f_82479_, result.f_82480_, result.f_82481_);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() - vec3.f_82479_ * 0.1 + ox + extraX * (double)radius, yPos + oy, this.m_20189_() - vec3.f_82481_ * 0.1 + oz + extraZ * (double)radius, result.f_82479_, result.f_82480_, result.f_82481_);
            }
        }
    }

    protected void handleFlying() {
        this.prevFlyProgress = this.flyProgress;
        if (this.m_29443_()) {
            if (this.flyProgress < 5.0f) {
                this.flyProgress += 1.0f;
            }
        } else if (this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (!this.f_19853_.m_5776_()) {
            boolean isFlying = this.m_29443_();
            if (isFlying != this.wasFlying) {
                this.switchNavigator(!isFlying);
            }
            if (isFlying) {
                ++this.timeFlying;
                this.m_20242_(true);
                if (this.m_21827_() || this.m_20159_() || this.m_27593_() || this.m_5803_()) {
                    this.setFlying(false);
                }
            } else {
                this.timeFlying = 0;
                this.m_20242_(false);
            }
        }
    }

    protected void miscAnimationHandler() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (!this.m_9236_().m_5776_()) {
                if ((this.getMiscAnimation() == 1 || this.getMiscAnimation() == 2) && this.miscAnimationTicks == 10) {
                    LivingEntity target = this.m_5448_();
                    if (target != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    IfritEntity.shootFireBolt((LivingEntity)this);
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else if (this.getMiscAnimation() == 3) {
                    LivingEntity target;
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks >= 10 && this.miscAnimationTicks <= 25) {
                        this.flameOrb();
                    }
                    if ((target = this.m_5448_()) != null) {
                        this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    }
                    this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else if (this.getMiscAnimation() == 4 && this.miscAnimationTicks == 25) {
                    IfritEntity.hellFire((Mob)this);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else if (this.getMiscAnimation() == 5) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 1) {
                        Vec3 pos;
                        LivingEntity target = this.m_5448_();
                        if (target != null) {
                            pos = target.m_20182_();
                        } else {
                            BlockHitResult result = SkillHelper.getPlayerPOVHitResult(this.f_19853_, (Entity)this, ClipContext.Fluid.NONE, 20.0);
                            pos = result.m_82450_();
                        }
                        this.setFlarePos(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
                        this.setFlareID(0);
                    } else {
                        this.flareCircle(this.miscAnimationTicks);
                    }
                } else if (this.getMiscAnimation() == 6) {
                    this.m_21573_().m_26573_();
                    if (this.miscAnimationTicks == 15) {
                        IfritEntity.combust((LivingEntity)this, this::shouldAttack);
                        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            case -1 -> 200;
            case 3, 7, 8 -> 40;
            case 4, 6 -> 30;
            case 5 -> 65;
            default -> 15;
        };
    }

    private void flameOrb() {
        int orbID = this.getFlareID();
        if (orbID == 0) {
            FlameOrbProjectile orb = new FlameOrbProjectile(this.f_19853_, (LivingEntity)this);
            orb.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 3.0));
            orb.setBurnTicks(100);
            orb.setSpiritAttack(true);
            orb.setMpCost(500.0);
            orb.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.FLAME_MANIPULATION.get()).orElse(null));
            orb.setExplosionRadius(4.0f);
            orb.m_146884_(this.m_146892_().m_82520_(0.0, 4.0, 0.0));
            orb.setOwnerOffset(new Vec3(0.0, 4.0, 0.0));
            orb.setLookDistance(30.0f);
            orb.setDelayTick(15);
            orb.m_20242_(true);
            this.m_9236_().m_7967_((Entity)orb);
            this.setFlareID(orb.m_19879_());
        } else {
            Entity entity = this.m_9236_().m_6815_(orbID);
            if (!(entity instanceof FlameOrbProjectile)) {
                this.setFlareID(0);
                this.flameOrb();
            } else {
                FlameOrbProjectile orb = (FlameOrbProjectile)entity;
                if (orb.getDelayTick() > 0) {
                    orb.setSize(orb.getSize() + 0.1f);
                }
            }
        }
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void flareCircle(int heldTicks) {
        BlockPos pos = this.getFlarePos();
        if (heldTicks >= 20) {
            int flareID = this.getFlareID();
            if (flareID == 0) {
                FlareCircleEntity barrier = new FlareCircleEntity((EntityType<? extends FlareCircleEntity>)((EntityType)TensuraEntityTypes.FLARE_CIRCLE.get()), this.f_19853_);
                barrier.m_5602_((Entity)this);
                barrier.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 2.0));
                barrier.setRadius(5.0f);
                barrier.setHeight(7.0f);
                barrier.setLife(30);
                barrier.setHealth(200.0f);
                barrier.m_146884_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
                barrier.setMpCost(2000.0);
                barrier.setSkill(SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)SpiritualMagics.FLARE_CIRCLE.get()).orElse(null));
                this.m_9236_().m_7967_((Entity)barrier);
                this.setFlareID(barrier.m_19879_());
            } else {
                Entity entity = this.m_9236_().m_6815_(flareID);
                if (!(entity instanceof BarrierEntity)) {
                    this.setFlareID(0);
                } else {
                    BarrierEntity barrier = (BarrierEntity)entity;
                    barrier.increaseLife(2);
                }
            }
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else {
            TensuraNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this), (Object)new RequestFxSpawningPacket(new ResourceLocation("tensura:flare_circle_circle"), pos, 0.0, 0.0, 0.0, 0, true));
        }
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.m_20069_() && this.m_20184_().f_82480_ > 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.5, 1.0));
        }
        super.m_7023_(vec3d);
    }

    @Override
    public void followEntity(TamableAnimal animal, LivingEntity owner, double followSpeed) {
        if (this.m_20270_((Entity)owner) > 5.0f) {
            this.setFlying(true);
            this.m_21566_().m_6849_(owner.m_20185_(), owner.m_20186_() + (double)owner.m_20206_(), owner.m_20189_(), followSpeed);
        } else {
            if (this.f_19861_) {
                this.setFlying(false);
            }
            if (this.m_29443_()) {
                BlockPos vec = this.getGround((LivingEntity)this, this.m_20183_());
                this.m_21566_().m_6849_((double)vec.m_123341_(), (double)vec.m_123342_(), (double)vec.m_123343_(), followSpeed);
            } else {
                this.m_21573_().m_5624_((Entity)owner, followSpeed);
            }
        }
    }

    @Override
    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.m_6084_()) {
            return;
        }
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.RED_FIRE.get());
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.HEAT_EFFECT.get(), 2.0);
        TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)ParticleTypes.f_123796_, 2.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    public boolean shouldStand() {
        if (this.getMiscAnimation() == 3) {
            return true;
        }
        if (this.getMiscAnimation() >= 5) {
            return true;
        }
        return this.m_20096_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.m_21825_() && this.getMiscAnimation() == -1) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.idle_train", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (event.isMoving() && this.getMiscAnimation() < 5 && this.getMiscAnimation() != 3) {
            if (this.m_20096_()) {
                if (this.m_21660_()) {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.run", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                } else {
                    event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
                }
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (this.shouldStand()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.idle_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState miscPredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_ball_right", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_ball_left", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_ball_massive", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 4) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.fire_wall", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 5) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.flare_circle", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 6) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.burst", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 7 || this.getMiscAnimation() == 8) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ifrit.summon", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "miscController", 0.0f, this::miscPredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class IfritMoveControl
    extends MoveControl {
        private final Mob parentEntity;

        public IfritMoveControl() {
            super((Mob)IfritCloneEntity.this);
            this.parentEntity = IfritCloneEntity.this;
        }

        public void m_8126_() {
            if (IfritCloneEntity.this.getMiscAnimation() >= 5) {
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.parentEntity.m_20185_(), this.f_24976_ - this.parentEntity.m_20186_(), this.f_24977_ - this.parentEntity.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.parentEntity.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                this.parentEntity.m_20256_(this.parentEntity.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                    this.parentEntity.m_146922_(Mth.m_14148_((float)this.parentEntity.m_146908_(), (float)yaw, (float)8.0f));
                }
            }
        }
    }

    static class IfritAttackGoal
    extends Goal {
        private final IfritCloneEntity ifrit;
        private Vec3 startOrbitFrom;
        private int orbitTime;
        private int maxOrbitTime;
        private int attackCooldown;

        public IfritAttackGoal(IfritCloneEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.ifrit = entity;
        }

        public boolean m_8036_() {
            if (this.ifrit.m_21827_()) {
                return false;
            }
            if (this.ifrit.usingMeleeWeapon()) {
                return false;
            }
            LivingEntity target = this.ifrit.m_5448_();
            if (target != null && target.m_6084_()) {
                this.startOrbitFrom = target.m_146892_();
                return true;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity target = this.ifrit.m_5448_();
            if (target == null || !target.m_6084_()) {
                return;
            }
            this.ifrit.setFlying(true);
            if (this.orbitTime < this.maxOrbitTime) {
                if (this.ifrit.getMiscAnimation() == 0) {
                    ++this.orbitTime;
                    --this.attackCooldown;
                }
                float zoomIn = 1.0f - (float)this.orbitTime / (float)this.maxOrbitTime;
                Vec3 orbitPos = this.orbitAroundPos(15.0f).m_82520_(0.0, (double)(4.0f + zoomIn * 3.0f), 0.0);
                this.ifrit.m_21573_().m_26519_(orbitPos.f_82479_, orbitPos.f_82480_, orbitPos.f_82481_, 1.2);
                if (this.isTimeToAttack()) {
                    this.resetAttackCooldown();
                    this.ifrit.setMiscAnimation(this.randomAttack(this.ifrit.m_20270_((Entity)target)));
                    this.ifrit.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
            } else {
                this.orbitTime = 0;
            }
        }

        public void m_8056_() {
            this.orbitTime = 0;
            this.maxOrbitTime = 100 + this.ifrit.m_217043_().m_188503_(80);
            this.ifrit.m_21561_(true);
            this.attackCooldown = 0;
        }

        public Vec3 orbitAroundPos(float circleDistance) {
            float angle = 3.0f * (float)(Math.toRadians(this.orbitTime) * 3.0);
            double extraX = circleDistance * Mth.m_14031_((float)angle);
            double extraZ = circleDistance * Mth.m_14089_((float)angle);
            return this.startOrbitFrom.m_82520_(extraX, 0.0, extraZ);
        }

        private void resetAttackCooldown() {
            this.attackCooldown = this.m_183277_(30);
        }

        private boolean isTimeToAttack() {
            return this.attackCooldown <= 0;
        }

        private int randomAttack(double distance) {
            if (distance < 10.0 && (double)this.ifrit.f_19796_.m_188501_() <= 0.2) {
                return 6;
            }
            if (distance < 15.0) {
                if ((double)this.ifrit.f_19796_.m_188501_() <= 0.05) {
                    return 4;
                }
                if ((double)this.ifrit.f_19796_.m_188501_() <= 0.1) {
                    return 5;
                }
            }
            if ((double)this.ifrit.f_19796_.m_188501_() <= 0.4) {
                return 3;
            }
            return this.ifrit.m_217043_().m_188499_() ? 1 : 2;
        }
    }

    static class FollowIfritGoal
    extends Goal {
        private final IfritCloneEntity clone;
        @Nullable
        private IfritEntity ifrit;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowIfritGoal(IfritCloneEntity ifritClone, double pSpeedModifier) {
            this.clone = ifritClone;
            this.speedModifier = pSpeedModifier;
        }

        private boolean hasTarget() {
            if (this.clone.m_5448_() == null) {
                return false;
            }
            if (this.clone.m_5448_() instanceof SalamanderEntity) {
                return false;
            }
            if (this.clone.m_5448_() instanceof IfritCloneEntity) {
                return false;
            }
            return !(this.clone.m_5448_() instanceof IfritEntity);
        }

        public boolean m_8036_() {
            if (this.clone.m_21824_()) {
                return false;
            }
            if (this.clone.m_21523_() || this.clone.m_20159_()) {
                return false;
            }
            List list = this.clone.f_19853_.m_45976_(IfritEntity.class, this.clone.m_20191_().m_82377_(32.0, 16.0, 32.0));
            IfritEntity lord = null;
            double d0 = Double.MAX_VALUE;
            for (IfritEntity parent : list) {
                double distance = this.clone.m_20280_((Entity)parent);
                if (!(distance <= d0)) continue;
                d0 = distance;
                lord = parent;
            }
            if (lord == null) {
                return false;
            }
            if (this.hasTarget()) {
                return false;
            }
            if (d0 > 256.0) {
                this.ifrit = lord;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.clone.m_21824_()) {
                return false;
            }
            if (this.clone.m_21523_() || this.clone.m_20159_()) {
                return false;
            }
            if (this.hasTarget()) {
                return false;
            }
            if (this.ifrit == null) {
                return false;
            }
            if (!this.ifrit.m_6084_()) {
                return false;
            }
            double d0 = this.clone.m_20280_((Entity)this.ifrit);
            return d0 >= 49.0 && d0 <= 256.0;
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            if (this.clone.m_5803_()) {
                this.clone.setSleeping(false);
            }
        }

        public void m_8041_() {
            this.ifrit = null;
            this.clone.m_21573_().m_26573_();
        }

        public void m_8037_() {
            if (--this.timeToRecalcPath > 0) {
                return;
            }
            if (this.ifrit == null) {
                return;
            }
            if (this.ifrit.m_5448_() != null && !this.hasTarget() && this.ifrit.m_5448_() != this.clone && this.ifrit.m_5448_().m_20270_((Entity)this.clone) <= 30.0f) {
                this.clone.m_6710_(this.ifrit.m_5448_());
            }
            this.timeToRecalcPath = this.m_183277_(10);
            this.clone.m_21573_().m_5624_((Entity)this.ifrit, this.speedModifier);
        }
    }

    public class WalkGoal
    extends Goal {
        protected final IfritCloneEntity entity;
        protected double x;
        protected double y;
        protected double z;
        private boolean flightTarget = false;

        public WalkGoal(IfritCloneEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.entity = entity;
        }

        public boolean m_8036_() {
            if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_() || this.entity.m_21827_()) {
                return false;
            }
            if (this.entity.m_217043_().m_188503_(30) != 0 && !this.entity.m_29443_()) {
                return false;
            }
            this.flightTarget = this.entity.m_20096_() ? IfritCloneEntity.this.f_19796_.m_188499_() : IfritCloneEntity.this.f_19796_.m_188503_(5) > 0 && this.entity.timeFlying < 200;
            Vec3 position = this.getPosition();
            if (position == null) {
                return false;
            }
            this.x = position.f_82479_;
            this.y = position.f_82480_;
            this.z = position.f_82481_;
            return true;
        }

        public void m_8037_() {
            if (this.flightTarget) {
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
                if (IfritCloneEntity.this.m_29443_() && this.entity.f_19861_) {
                    this.entity.setFlying(false);
                }
            }
            if (IfritCloneEntity.this.m_29443_() && this.entity.f_19861_ && this.entity.timeFlying > 10) {
                this.entity.setFlying(false);
            }
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vector3d = this.entity.m_20182_();
            if (IfritCloneEntity.this.isOverWater((LivingEntity)this.entity)) {
                this.flightTarget = true;
            }
            Vec3 pos = Vec3.m_82512_((Vec3i)this.entity.getWanderPos());
            double distance = (Double)TensuraConfig.INSTANCE.entitiesConfig.tamedWanderRadius.get();
            if (this.entity.isWandering() && this.entity.m_20238_(pos) >= distance * distance) {
                return pos;
            }
            if (this.flightTarget) {
                if (this.entity.timeFlying < 50) {
                    return IfritCloneEntity.this.getBlockInViewAway((LivingEntity)this.entity, vector3d, 0.0f);
                }
                return IfritCloneEntity.this.getBlockGrounding((LivingEntity)this.entity, vector3d);
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.entity, (int)10, (int)7);
        }

        public boolean m_8045_() {
            if (this.entity.m_21827_()) {
                return false;
            }
            if (this.flightTarget) {
                return this.entity.m_29443_() && this.entity.m_20275_(this.x, this.y, this.z) > 2.0;
            }
            return !this.entity.m_21573_().m_26571_() && !this.entity.m_20160_();
        }

        public void m_8056_() {
            if (this.flightTarget) {
                this.entity.setFlying(true);
                this.entity.m_21566_().m_6849_(this.x, this.y, this.z, 1.0);
            } else {
                this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
            }
        }

        public void m_8041_() {
            this.entity.m_21573_().m_26573_();
            super.m_8041_();
        }
    }
}

