/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IRanking;
import com.github.manasmods.tensura.api.entity.subclass.SpittingRangedMonster;
import com.github.manasmods.tensura.block.MothEggBlock;
import com.github.manasmods.tensura.capability.ep.TensuraEPCapability;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.HellCaterpillarEntity;
import com.github.manasmods.tensura.entity.projectile.MonsterSpitProjectile;
import com.github.manasmods.tensura.entity.template.FLyingTamableEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.entity.variant.MothVariant;
import com.github.manasmods.tensura.registry.blocks.TensuraBlocks;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.skill.CommonSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class HellMothEntity
extends FLyingTamableEntity
implements IAnimatable,
SpittingRangedMonster,
IRanking {
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(HellMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BABY_SIZE = SynchedEntityData.m_135353_(HellMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ATTACK_MODE = SynchedEntityData.m_135353_(HellMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(HellMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(HellMothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int miscAnimationTicks = 0;
    public float attackTicks;
    public boolean isWet;
    public static final AnimationBuilder POWDER_ATTACK = new AnimationBuilder().addAnimation("animation.hell_moth.powder_attack", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder IDLE_GROUND = new AnimationBuilder().addAnimation("animation.hell_moth.idle_ground", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder IDLE_FLY = new AnimationBuilder().addAnimation("animation.hell_moth.idle_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder FLY_AGRO = new AnimationBuilder().addAnimation("animation.hell_moth.fly_agro", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder FLY = new AnimationBuilder().addAnimation("animation.hell_moth.fly_passive", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder WALK = new AnimationBuilder().addAnimation("animation.hell_moth.walking", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP);
    public static final AnimationBuilder WATER_SHAKE = new AnimationBuilder().addAnimation("animation.hell_moth.water_shaking", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder CLEAN_ANTENNA = new AnimationBuilder().addAnimation("animation.hell_moth.cleaning", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationBuilder HATCH = new AnimationBuilder().addAnimation("animation.hell_moth.hatch", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public HellMothEntity(EntityType<? extends HellMothEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22280_, (double)0.6f).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.3).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MothLayEggGoal(this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(1, (Goal)new MothBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21346_.m_25352_(4, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(6, (Goal)new MothEatOrCleanGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new MothFollowLamp(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new FLyingTamableEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MothAttackGoal(this, 1.25, 20, 20.0f));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((HellMothEntity)this).m_21674_(arg_0)));
        this.f_21345_.m_25352_(5, new MothTargetGoal<Player>(this, Player.class, null));
        this.f_21345_.m_25352_(5, new MothTargetGoal<Spider>(this, Spider.class, null));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_EGG, (Object)false);
        this.f_19804_.m_135372_(BABY_SIZE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_MODE, (Object)0);
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("HasEgg", this.hasEgg());
        compound.m_128405_("BabySize", this.getBabySize());
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("AttackMode", this.getAttackMode());
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHasEgg(compound.m_128471_("HasEgg"));
        this.setAttackMode(compound.m_128451_("AttackMode"));
        this.f_19804_.m_135381_(BABY_SIZE, (Object)compound.m_128451_("BabySize"));
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)compound.m_128451_("Variant"));
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public int getBabySize() {
        return (Integer)this.f_19804_.m_135370_(BABY_SIZE);
    }

    public void setBabySize(int pSize) {
        this.f_19804_.m_135381_(BABY_SIZE, (Object)pSize);
        this.m_20090_();
        this.m_6210_();
        Objects.requireNonNull(this.m_21051_(Attributes.f_22276_)).m_22100_((double)(10 * pSize));
        Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22100_((double)(1.5f * (float)pSize));
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions dimensions = super.m_6972_(pPose);
        if (this.m_6162_()) {
            return super.m_6972_(pPose).m_20388_(0.5f * (float)this.getBabySize());
        }
        return dimensions;
    }

    public int getAttackMode() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_MODE);
    }

    public void setAttackMode(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_MODE, (Object)attackTicks);
    }

    public MothVariant getVariant() {
        return MothVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public void setVariant(MothVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || super.m_6673_(source);
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (pState.m_204336_(TensuraTags.Blocks.WEB_BLOCKS)) {
            return;
        }
        super.m_7601_(pState, pMotionMultiplier);
    }

    protected float m_6041_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_6041_();
    }

    protected float m_20098_() {
        BlockState blockstate = this.f_19853_.m_8055_(this.m_20183_());
        return blockstate.m_204336_(TensuraTags.Blocks.WEB_BLOCKS) ? 1.0f : super.m_20098_();
    }

    public boolean hasEgg() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    void setHasEgg(boolean pHasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)pHasEgg);
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.hasEgg();
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        int randomSize;
        HellMothEntity moth = (HellMothEntity)((EntityType)TensuraEntityTypes.HELL_MOTH.get()).m_20615_((Level)pLevel);
        if (moth == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            moth.m_21816_(uuid);
            moth.m_7105_(true);
        }
        if ((randomSize = new Random().nextInt(10)) >= 8) {
            moth.setBabySize(2);
        } else {
            moth.setBabySize(1);
        }
        return moth;
    }

    @Override
    public void evolve() {
        if ((double)this.f_19796_.m_188501_() <= 0.1) {
            this.setVariant(MothVariant.GEHENNA);
            TensuraEPCapability.setLivingEP((LivingEntity)this, TensuraEPCapability.getEP((LivingEntity)this) + 1000.0);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.animationTicking();
        if (this.m_5448_() != null && this.getAttackMode() == 0) {
            this.attackTicks += 1.0f;
            if (this.attackTicks > 500.0f) {
                this.setAttackMode(1);
                this.attackTicks = 0.0f;
            }
        }
        if (this.getAttackMode() == 1 && this.m_21660_()) {
            float radius = this.m_20205_();
            double x = this.m_20185_() + (this.f_19853_.f_46441_.m_188500_() - 0.5) * (double)radius;
            double y = this.m_20186_() - 1.0 + (this.f_19853_.f_46441_.m_188500_() - 0.5) * (double)radius * 0.75;
            double z = this.m_20189_() + (this.f_19853_.f_46441_.m_188500_() - 0.5) * (double)radius;
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 10; ++j) {
                    double newX = x + this.m_217043_().m_188583_() / 2.0;
                    double newY = y + this.m_217043_().m_188583_() / 2.0;
                    double newZ = z + this.m_217043_().m_188583_() / 2.0;
                    this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(Vec3.m_82501_((int)0xE0D000)), 1.0f), newX, newY - (double)i, newZ, 0.0, -0.1, 0.0);
                }
            }
        }
    }

    protected void animationTicking() {
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (this.miscAnimationTicks > 15) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if (this.m_20071_()) {
            this.isWet = true;
            if (this.getMiscAnimation() == 2 && !this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)56);
                this.setMiscAnimation(0);
            }
        } else if (this.isWet && this.m_20096_()) {
            this.isWet = false;
            this.setMiscAnimation(2);
            this.m_5496_(SoundEvents.f_12623_, this.m_6121_(), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_146850_(GameEvent.f_223710_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_) {
            return;
        }
        if (this.m_5448_() == null) {
            return;
        }
        if (this.m_6162_() && this.getBabySize() <= 1) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (this.m_20270_((Entity)target) > 6.0f && (this.m_21826_() == null || !(this.m_20270_((Entity)this.m_21826_()) > 12.0f)) || this.getAttackMode() == 1) {
            Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.6, 1.0);
            if (this.getAttackMode() == 1) {
                vec3 = this.m_20184_().m_82542_(1.2, 0.6, 1.2);
            }
            double d0 = vec3.f_82480_;
            if (this.m_20186_() < target.m_20186_() + 7.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3 = new Vec3(vec3.f_82479_, d0, vec3.f_82481_);
            Vec3 vec31 = new Vec3(target.m_20185_() - this.m_20185_(), 0.0, target.m_20189_() - this.m_20189_());
            if (vec31.m_165925_() > 10.0) {
                Vec3 vec32 = vec31.m_82541_();
                vec3 = vec3.m_82520_(vec32.f_82479_ * 0.3 - vec3.f_82479_ * 0.6, 0.0, vec32.f_82481_ * 0.3 - vec3.f_82481_ * 0.6);
            }
            this.m_20256_(vec3);
            if (vec3.m_165925_() > 0.05) {
                this.m_146922_((float)Mth.m_14136_((double)vec3.f_82481_, (double)vec3.f_82479_) * 57.295776f - 90.0f);
            }
        }
    }

    public void m_146762_(int pAge) {
        if (this.getBabySize() == 1 && pAge >= 0) {
            this.m_146762_(-24000);
            this.setBabySize(2);
        } else {
            super.m_146762_(pAge);
        }
    }

    public float m_5610_(BlockPos pPos, LevelReader pLevel) {
        return MothEggBlock.onEggCanPlace((BlockGetter)pLevel, pPos) ? 10.0f : super.m_5610_(pPos, pLevel);
    }

    @Override
    public void m_6504_(@NotNull LivingEntity pTarget, float pDistanceFactor) {
        MonsterSpitProjectile spit = new MonsterSpitProjectile(this.f_19853_, (LivingEntity)this);
        spit.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
        double d1 = pTarget.m_20185_() - this.m_20185_();
        double d2 = pTarget.m_20188_() - (double)1.1f - spit.m_20186_();
        double d3 = pTarget.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        spit.m_6686_(d1, d2 + d4, d3, 1.6f, 1.0f);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f);
        }
        this.f_19853_.m_7967_((Entity)spit);
    }

    @Override
    public void spitHit(LivingEntity pTarget) {
        if (pTarget instanceof HellMothEntity || pTarget instanceof HellCaterpillarEntity) {
            return;
        }
        if (pTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this), 8.0f)) {
            int level;
            int n = level = this.f_19796_.m_188503_(10) >= 8 ? 1 : 0;
            if (this.hasParalysis()) {
                pTarget.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 300, level, false, false, true), (Entity)this);
            }
            pTarget.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 200, level, false, false, true), (Entity)this);
        }
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(5.0f);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_13167_);
    }

    public boolean hasParalysis() {
        return SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)CommonSkills.PARALYSIS.get()).isPresent();
    }

    public static boolean checkMothSpawnRules(EntityType<HellMothEntity> moth, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_8055_(pPos.m_7495_()).m_204336_(BlockTags.f_184232_) && Monster.m_219009_((ServerLevelAccessor)pLevel, (BlockPos)pPos, (RandomSource)pRandom) && HellMothEntity.m_217057_(moth, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.hellMothSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (new Random().nextInt(20) == 10) {
            this.setVariant(MothVariant.GEHENNA);
            TensuraEPCapability.setLivingEP((LivingEntity)this, TensuraEPCapability.getEP((LivingEntity)this) + 1000.0);
        }
        this.setMiscAnimation(1);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    protected ResourceLocation m_7582_() {
        if (this.getVariant().equals((Object)MothVariant.GEHENNA)) {
            return new ResourceLocation(Registry.f_122826_.m_7981_((Object)this.m_6095_()).m_135827_(), "entities/gehenna_moth");
        }
        return super.m_7582_();
    }

    public void m_6667_(DamageSource pCause) {
        this.isWet = false;
        this.setMiscAnimation(0);
        super.m_6667_(pCause);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TensuraSoundEvents.MOTH_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TensuraSoundEvents.MOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TensuraSoundEvents.MOTH_DEATH.get();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.getMiscAnimation() == 1) {
            return PlayState.CONTINUE;
        }
        if (this.m_20096_() || this.m_20069_() || this.m_20077_()) {
            if (event.isMoving()) {
                event.getController().setAnimation(WALK);
            } else if (this.getMiscAnimation() == 0) {
                event.getController().setAnimation(IDLE_GROUND);
            }
        } else if (event.isMoving()) {
            if (this.m_21660_()) {
                if (this.getAttackMode() == 1) {
                    event.getController().setAnimation(POWDER_ATTACK);
                } else {
                    event.getController().setAnimation(FLY_AGRO);
                }
            } else {
                event.getController().setAnimation(FLY);
            }
        } else {
            event.getController().setAnimation(IDLE_FLY);
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState playOncePredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            if (this.getMiscAnimation() == 1) {
                event.getController().markNeedsReload();
                event.getController().setAnimation(HATCH);
            } else if (this.getMiscAnimation() == 2) {
                event.getController().markNeedsReload();
                event.getController().setAnimation(WATER_SHAKE);
            } else if (this.getMiscAnimation() == 3) {
                event.getController().markNeedsReload();
                event.getController().setAnimation(CLEAN_ANTENNA);
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "playOnceController", 0.0f, this::playOncePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class MothLayEggGoal
    extends MoveToBlockGoal {
        private final HellMothEntity moth;

        MothLayEggGoal(HellMothEntity moth, double pSpeedModifier) {
            super((PathfinderMob)moth, pSpeedModifier, 20);
            this.moth = moth;
        }

        public boolean m_8036_() {
            return this.moth.hasEgg() && super.m_8036_() && !this.moth.m_21827_();
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = this.moth.m_20183_();
            if (this.m_25625_()) {
                Level level = this.moth.f_19853_;
                level.m_5594_(null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                level.m_46796_(2001, blockpos, Block.m_49956_((BlockState)level.m_8055_(blockpos.m_7495_())));
                level.m_7731_(this.f_25602_.m_7494_(), (BlockState)((MothEggBlock)((Object)TensuraBlocks.MOTH_EGG.get())).m_49966_().m_61124_((Property)MothEggBlock.EGGS, (Comparable)Integer.valueOf(this.moth.f_19796_.m_188503_(4) + 1)), 3);
                this.moth.setHasEgg(false);
                this.moth.m_27601_(600);
            } else {
                this.moth.setFlying(Boolean.TRUE);
            }
        }

        protected BlockPos m_6669_() {
            BlockPos newPos = new BlockPos((double)this.f_25602_.m_123341_() + 0.5, (double)this.f_25602_.m_123342_(), (double)this.f_25602_.m_123343_() + 0.5);
            return newPos.m_7494_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            return pLevel.m_46859_(pPos.m_7494_()) && MothEggBlock.canPlaceEgg((BlockGetter)pLevel, pPos);
        }
    }

    static class MothBreedGoal
    extends BreedGoal {
        private final HellMothEntity moth;

        MothBreedGoal(HellMothEntity moth, double pSpeedModifier) {
            super((Animal)moth, pSpeedModifier);
            this.moth = moth;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.moth.hasEgg();
        }

        protected void m_8026_() {
            ServerPlayer serverplayer = this.f_25113_.m_27592_();
            if (serverplayer == null && this.f_25115_ != null && this.f_25115_.m_27592_() != null) {
                serverplayer = this.f_25115_.m_27592_();
            }
            if (serverplayer != null && this.f_25115_ != null) {
                serverplayer.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayer, this.f_25113_, this.f_25115_, null);
            }
            this.moth.setHasEgg(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource randomsource = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), randomsource.m_188503_(7) + 1));
            }
        }
    }

    static class MothEatOrCleanGoal
    extends EatBlockGoal {
        protected final HellMothEntity moth;

        public MothEatOrCleanGoal(HellMothEntity hellMothEntity) {
            super((Mob)hellMothEntity);
            this.moth = hellMothEntity;
        }

        public boolean m_8036_() {
            if (this.moth.m_217043_().m_188503_(200) != 0) {
                return false;
            }
            BlockPos blockpos = this.moth.m_20183_();
            boolean shouldEat = false;
            if (BlockStatePredicate.m_61287_((Block)Blocks.f_50034_).test(this.moth.f_19853_.m_8055_(blockpos))) {
                shouldEat = true;
            } else if (this.moth.f_19853_.m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_50440_)) {
                shouldEat = true;
            }
            if (!shouldEat || this.moth.m_217043_().m_188503_(10) <= 5) {
                this.moth.setMiscAnimation(3);
                return false;
            }
            return true;
        }
    }

    static class MothFollowLamp
    extends TemptGoal {
        HellMothEntity moth;

        public MothFollowLamp(HellMothEntity pMob, double pSpeedModifier) {
            super((PathfinderMob)pMob, pSpeedModifier, Ingredient.m_204132_(TensuraTags.Items.MOTH_LAMP), false);
            this.moth = pMob;
        }

        public boolean m_8036_() {
            if (this.moth.hasEgg()) {
                return false;
            }
            if (this.moth.m_27593_()) {
                return false;
            }
            if (this.moth.m_5448_() != null) {
                return false;
            }
            if (this.moth.m_21827_()) {
                return false;
            }
            if (this.moth.m_213856_() >= 0.5f) {
                return false;
            }
            if (this.moth.m_21826_() != null && this.f_25925_ != null && !this.moth.m_21826_().equals((Object)this.f_25925_)) {
                return false;
            }
            return super.m_8036_();
        }
    }

    static class MothAttackGoal
    extends RangedAttackGoal {
        HellMothEntity moth;

        public MothAttackGoal(HellMothEntity moth, double pSpeedModifier, int pAttackInterval, float pAttackRadius) {
            super((RangedAttackMob)moth, pSpeedModifier, pAttackInterval, pAttackRadius);
            this.moth = moth;
        }

        public boolean m_8036_() {
            if (this.moth.m_6162_() && this.moth.getBabySize() <= 1) {
                return false;
            }
            return super.m_8036_();
        }

        public void m_8037_() {
            LivingEntity target = this.moth.m_5448_();
            if (target == null) {
                return;
            }
            if (this.moth.getAttackMode() == 1) {
                AABB aabb = new AABB(this.moth.m_20183_().m_6625_(2), this.moth.m_20183_().m_6625_(5));
                List list = this.moth.f_19853_.m_6443_(LivingEntity.class, aabb.m_82400_(2.0), entity -> !entity.m_7307_((Entity)this.moth) && !(entity instanceof HellCaterpillarEntity) && !(entity instanceof HellMothEntity));
                if (list.isEmpty()) {
                    return;
                }
                for (LivingEntity entity2 : list) {
                    if (entity2.equals((Object)target)) {
                        this.moth.setAttackMode(0);
                    }
                    entity2.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 200, 0), (Entity)this.moth);
                    if (!this.moth.hasParalysis()) continue;
                    entity2.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 300, entity2.m_21023_((MobEffect)TensuraMobEffects.PARALYSIS.get()) ? 2 : 1), (Entity)this.moth);
                }
            } else {
                super.m_8037_();
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.moth.setAttackMode(0);
        }
    }

    static class MothTargetGoal<T extends LivingEntity>
    extends NonTameRandomTargetGoal<T> {
        public MothTargetGoal(HellMothEntity mothEntity, Class<T> pEntityTypeToTarget, @Nullable Predicate<LivingEntity> pTargetPredicate) {
            super((TamableAnimal)mothEntity, pEntityTypeToTarget, true, pTargetPredicate);
        }

        public boolean m_8036_() {
            return this.f_26135_.m_213856_() < 0.5f && super.m_8036_();
        }
    }
}

