/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.api.entity.ai.WanderingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.IGiantMob;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.api.entity.subclass.SpittingRangedMonster;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.projectile.MonsterSpitProjectile;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.entity.TensuraEntityTypes;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.EatBlockGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class GiantAntEntity
extends TensuraTamableEntity
implements IAnimatable,
IGiantMob,
ITensuraMount,
SpittingRangedMonster {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(GiantAntEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> RANGED_ATTACK = SynchedEntityData.m_135353_(GiantAntEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.m_135353_(GiantAntEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int rangedCoolDown = 0;
    public int miscAnimationTicks = 0;
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public GiantAntEntity(EntityType<? extends GiantAntEntity> type, Level level) {
        super(type, level);
        this.f_19793_ = 3.0f;
        this.f_21364_ = 20;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 45.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, (double)0.32f).m_22268_(Attributes.f_22278_, (double)0.8f).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 2.0).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new WanderingFollowOwnerGoal(this, 1.2, 20.0f, 5.0f, false));
        this.f_21345_.m_25352_(4, (Goal)new AntEatOrCleanGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TensuraTamableEntity.WanderAroundPosGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new GiantAntAttackGoal(this, 1.2, 40, 20.0f, true));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Player.class, false, null));
        this.f_21346_.m_25352_(4, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Villager.class, false, null));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Animal.class, false, entity -> !(entity instanceof GiantAntEntity)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, IronGolem.class, false, null));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(RANGED_ATTACK, (Object)false);
        this.f_19804_.m_135372_(SADDLED, (Object)Boolean.FALSE);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128379_("Ranged", this.getRanged());
        compound.m_128379_("Saddled", this.isSaddled());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setRanged(compound.m_128471_("Ranged"));
        this.setSaddled(compound.m_128471_("Saddled"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    public boolean getRanged() {
        return (Boolean)this.f_19804_.m_135370_(RANGED_ATTACK);
    }

    public void setRanged(boolean ranged) {
        this.f_19804_.m_135381_(RANGED_ATTACK, (Object)ranged);
    }

    public boolean isSaddled() {
        return (Boolean)this.f_19804_.m_135370_(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.f_19804_.m_135381_(SADDLED, (Object)saddled);
    }

    public void m_7334_(Entity pEntity) {
        if (pEntity instanceof GiantAntEntity) {
            return;
        }
        super.m_7334_(pEntity);
    }

    public boolean m_5957_() {
        return false;
    }

    public boolean m_7848_(Animal pOtherAnimal) {
        return false;
    }

    public GiantAntEntity getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        GiantAntEntity ant = (GiantAntEntity)((EntityType)TensuraEntityTypes.GIANT_ANT.get()).m_20615_((Level)pLevel);
        if (ant == null) {
            return null;
        }
        UUID uuid = this.m_21805_();
        if (uuid != null) {
            ant.m_21816_(uuid);
            ant.m_7105_(true);
        }
        return ant;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        int i;
        if (pFallDistance < 8.0f) {
            return false;
        }
        if (pFallDistance > 8.0f) {
            this.m_5496_(SoundEvents.f_12319_, 0.4f, 1.0f);
        }
        if ((i = this.m_5639_(pFallDistance - 8.0f, pMultiplier)) <= 0) {
            return false;
        }
        this.m_6469_(pSource, i);
        if (this.m_20160_()) {
            for (Entity entity : this.m_146897_()) {
                entity.m_6469_(pSource, (float)i);
            }
        }
        this.m_21229_();
        return true;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.giantAntSpawnRate.get(), this.m_217043_(), pSpawnReason) && super.m_5545_(pLevel, pSpawnReason);
    }

    public int m_5792_() {
        return 3;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            Item item = itemstack.m_41720_();
            if (item.equals(TensuraMaterialItems.MONSTER_SADDLE.get()) && !this.isSaddled()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.setSaddled(true);
                this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (this.isSaddled() && item.equals(Items.f_42574_)) {
                this.m_5496_(SoundEvents.f_12344_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
                this.m_19998_((ItemLike)TensuraMaterialItems.MONSTER_SADDLE.get());
                this.setSaddled(false);
                return InteractionResult.SUCCESS;
            }
            if (player.m_36341_() || !this.isSaddled()) {
                this.commanding(player);
            } else if (player.m_146895_() == null) {
                this.m_21839_(false);
                this.setWandering(false);
                player.m_7998_((Entity)this, true);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.setMiscAnimation(2);
        this.m_5634_(5.0f);
    }

    public boolean m_6898_(ItemStack pStack) {
        if (pStack.m_41720_() instanceof HealingPotionItem) {
            return false;
        }
        return pStack.m_204117_(TensuraTags.Items.ADDITIONAL_ANT_FOOD) || pStack.m_41614_();
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = super.m_7327_(pEntity);
        if (flag && this.getMiscAnimation() == 0) {
            this.setMiscAnimation(3);
        }
        return flag;
    }

    public boolean m_6146_() {
        return true;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).equals((Object)this.m_21826_())) continue;
            return player;
        }
        return null;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = 1.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() + this.m_6048_() + passenger.m_6049_();
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity livingentity = this.getControllingPassenger();
            if (this.m_20160_() && livingentity != null && this.isSaddled()) {
                this.m_146922_(livingentity.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(livingentity.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = livingentity.f_20900_ * 0.5f;
                float f1 = livingentity.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.m_6109_()) {
                    float speed = (float)this.m_21133_(Attributes.f_22279_);
                    if (livingentity.m_20142_()) {
                        speed = (float)((double)speed * 1.75);
                    }
                    this.m_7910_(speed);
                    if (this.isInFluidType((fluidType, height) -> height > this.m_20204_()) && f1 > 0.0f) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.03, 0.0));
                    }
                    super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                } else if (livingentity instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
            } else {
                super.m_7023_(pTravelVector);
            }
        }
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.isSaddled() && !this.m_9236_().m_5776_()) {
            this.m_19998_((ItemLike)TensuraMaterialItems.MONSTER_SADDLE.get());
        }
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19314_ || source == DamageSource.f_19325_ || super.m_6673_(source);
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (pState.m_60734_() instanceof WebBlock) {
            return;
        }
        super.m_7601_(pState, pMotionMultiplier);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TensuraSoundEvents.CATERPILLAR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)TensuraSoundEvents.MOTH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TensuraSoundEvents.MOTH_DEATH.get();
    }

    public SoundSource m_5720_() {
        return SoundSource.NEUTRAL;
    }

    @Override
    public void m_8119_() {
        LivingEntity controller;
        super.m_8119_();
        this.targetingMovementHelper();
        if (!this.getRanged() && ++this.rangedCoolDown == 100) {
            this.rangedCoolDown = 0;
            this.setRanged(Boolean.TRUE);
        }
        if (!this.f_19853_.m_5776_()) {
            controller = this.getControllingPassenger();
            if (!this.m_21824_() || controller != null && this.m_21830_(controller)) {
                this.breakBlocks((LivingEntity)this, 1.0f, false);
            }
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 4 && this.miscAnimationTicks == 10) {
                LivingEntity target = this.m_5448_();
                if (target != null) {
                    this.performRangedAttack(target, this.m_6162_() ? 2.0 : 4.0, this.m_6162_() ? 1.0 : 2.0);
                    this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            } else if (this.getMiscAnimation() == -1 && this.miscAnimationTicks == 15 && (controller = this.getControllingPassenger()) != null) {
                BlockHitResult hitResult = SkillHelper.getPlayerPOVHitResult(this.f_19853_, (Entity)controller, ClipContext.Fluid.NONE, 30.0);
                this.performRangedAttack(hitResult.m_82425_(), -1.5, 5.0);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            if (this.miscAnimationTicks > this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() == 4) {
            return;
        }
        if (this.m_6162_()) {
            return;
        }
        this.setMiscAnimation(-1);
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            default -> 40;
            case 2 -> 20;
            case 3 -> 10;
            case -1, 4 -> 15;
        };
    }

    @Override
    public void spitParticle(MonsterSpitProjectile projectile) {
        this.particleSpawning(projectile, (ParticleOptions)new DustParticleOptions(new Vector3f(new Vec3(0.0, 255.0, 0.0)), 1.0f), 30);
    }

    @Override
    public void spitHit(LivingEntity pTarget) {
        if (pTarget instanceof GiantAntEntity) {
            return;
        }
        pTarget.m_6469_(DamageSource.m_19370_((LivingEntity)this), 12.0f);
        this.setRanged(Boolean.FALSE);
    }

    @Override
    public void impactEffect(MonsterSpitProjectile spit, double x, double y, double z) {
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.ACID_EFFECT.get(), x, y, z, 55, 0.08, 0.08, 0.08, 0.15, true);
        TensuraParticleHelper.spawnServerParticles(this.f_19853_, (ParticleOptions)TensuraParticles.ACID_BUBBLE.get(), x, y, z, 25, 0.08, 0.08, 0.08, 0.15, false);
        List list = this.f_19853_.m_6443_(LivingEntity.class, spit.m_20191_().m_82400_(3.0), entityData -> !entityData.m_7307_((Entity)this) && !entityData.m_7306_((Entity)this) && entityData != this.m_21826_());
        if (list.isEmpty()) {
            return;
        }
        for (LivingEntity pTarget : list) {
            pTarget.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.FRAGILITY.get(), 300, 0, false, false, true), (Entity)this);
            if (this.f_19796_.m_188503_(10) >= 8) {
                pTarget.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.FATAL_POISON.get(), 300, 0, false, false, true), (Entity)this);
                continue;
            }
            pTarget.m_147207_(new MobEffectInstance(MobEffects.f_19597_, 300, 1, false, false, true), (Entity)this);
        }
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        String name = this.m_21825_() ? "animation.giant_ant.stay" : (event.isMoving() ? (this.m_21660_() ? "animation.giant_ant.search" : "animation.giant_ant.walk") : "animation.giant_ant.idle");
        event.getController().setAnimation(new AnimationBuilder().addAnimation(name, (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState playOncePredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            String name = null;
            if (this.getMiscAnimation() == 1) {
                name = "animation.giant_ant.clean";
            } else if (this.getMiscAnimation() == 2) {
                name = "animation.giant_ant.eat";
            } else if (this.getMiscAnimation() == 3) {
                name = "animation.giant_ant.bite";
            } else if (this.getMiscAnimation() == 4 || this.getMiscAnimation() == -1) {
                name = "animation.giant_ant.spit";
            }
            if (name != null) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation(name, (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "playOnceController", 0.0f, this::playOncePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class AntEatOrCleanGoal
    extends EatBlockGoal {
        protected final GiantAntEntity ant;

        public AntEatOrCleanGoal(GiantAntEntity giantAnt) {
            super((Mob)giantAnt);
            this.ant = giantAnt;
        }

        public boolean m_8036_() {
            if (this.ant.m_217043_().m_188503_(400) != 0) {
                return false;
            }
            BlockPos blockpos = this.ant.m_20183_();
            boolean shouldEat = false;
            if (BlockStatePredicate.m_61287_((Block)Blocks.f_50034_).test(this.ant.f_19853_.m_8055_(blockpos))) {
                shouldEat = true;
            } else if (this.ant.f_19853_.m_8055_(blockpos.m_7495_()).m_60713_(Blocks.f_50440_)) {
                shouldEat = true;
            }
            if (!shouldEat || this.ant.m_217043_().m_188503_(7) <= 5) {
                this.ant.setMiscAnimation(1);
                return false;
            }
            return true;
        }
    }

    static class GiantAntAttackGoal
    extends MeleeAttackGoal {
        private final int attackInterval;
        private final float attackRadius;
        private int attackTime = -1;
        private final GiantAntEntity giantAnt;

        public GiantAntAttackGoal(GiantAntEntity ant, double pSpeedModifier, int pAttackInterval, float pAttackRadius, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)ant, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.attackInterval = pAttackInterval;
            this.attackRadius = pAttackRadius;
            this.giantAnt = ant;
        }

        public boolean m_8036_() {
            if (this.giantAnt.m_21827_()) {
                return false;
            }
            if (this.giantAnt.getRanged()) {
                LivingEntity livingentity = this.f_25540_.m_5448_();
                return livingentity != null && livingentity.m_6084_();
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (this.giantAnt.m_21827_()) {
                return false;
            }
            if (this.giantAnt.getRanged()) {
                LivingEntity target = this.f_25540_.m_5448_();
                if (target != null && target.m_6084_() && !this.f_25540_.m_21573_().m_26571_()) {
                    return true;
                }
                return this.m_8036_();
            }
            return super.m_8045_();
        }

        public void m_8041_() {
            this.attackTime = -1;
            super.m_8041_();
        }

        public void m_8037_() {
            LivingEntity target;
            if (this.giantAnt.getRanged() && (target = this.giantAnt.m_5448_()) != null) {
                this.f_25540_.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                double d0 = this.f_25540_.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                boolean flag = this.f_25540_.m_21574_().m_148306_((Entity)target);
                if (--this.attackTime == 0) {
                    if (!flag) {
                        return;
                    }
                    this.giantAnt.f_21344_.m_26573_();
                    this.giantAnt.setMiscAnimation(4);
                    this.attackTime = Mth.m_14143_((float)this.attackInterval);
                } else if (this.attackTime < 0) {
                    this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackInterval, (double)this.attackInterval));
                }
            }
            super.m_8037_();
        }
    }
}

