/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.entity;

import com.github.manasmods.manascore.api.skills.ManasSkill;
import com.github.manasmods.manascore.api.skills.SkillAPI;
import com.github.manasmods.tensura.ability.SkillHelper;
import com.github.manasmods.tensura.ability.SkillUtils;
import com.github.manasmods.tensura.ability.TensuraSkillInstance;
import com.github.manasmods.tensura.ability.magic.MagicElemental;
import com.github.manasmods.tensura.ability.magic.spiritual.SpiritualMagic;
import com.github.manasmods.tensura.api.entity.ai.DynamicMeleeAttackGoal;
import com.github.manasmods.tensura.api.entity.ai.FlyingFollowOwnerGoal;
import com.github.manasmods.tensura.api.entity.subclass.DynamicMeleeAttackAction;
import com.github.manasmods.tensura.api.entity.subclass.IElementalSpirit;
import com.github.manasmods.tensura.api.entity.subclass.ITensuraMount;
import com.github.manasmods.tensura.client.keybind.TensuraKeybinds;
import com.github.manasmods.tensura.client.particle.TensuraParticleHelper;
import com.github.manasmods.tensura.config.SpawnRateConfig;
import com.github.manasmods.tensura.data.TensuraTags;
import com.github.manasmods.tensura.entity.SylphideEntity;
import com.github.manasmods.tensura.entity.magic.projectile.WindSphereProjectile;
import com.github.manasmods.tensura.entity.template.FLyingTamableEntity;
import com.github.manasmods.tensura.entity.template.TensuraTamableEntity;
import com.github.manasmods.tensura.item.food.HealingPotionItem;
import com.github.manasmods.tensura.registry.effects.TensuraMobEffects;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.registry.items.TensuraMobDropItems;
import com.github.manasmods.tensura.registry.particle.TensuraParticles;
import com.github.manasmods.tensura.registry.skill.ExtraSkills;
import com.github.manasmods.tensura.registry.sound.TensuraSoundEvents;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import com.github.manasmods.tensura.util.damage.TensuraDamageSources;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class FeatheredSerpentEntity
extends FLyingTamableEntity
implements IAnimatable,
IElementalSpirit,
ITensuraMount,
PlayerRideable {
    private static final EntityDataAccessor<Integer> MISC_ANIMATION = SynchedEntityData.m_135353_(FeatheredSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMONING_TICK = SynchedEntityData.m_135353_(FeatheredSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Optional<UUID>> SUMMONER_UUID = SynchedEntityData.m_135353_(FeatheredSerpentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int miscAnimationTicks = 0;
    public boolean flyingPose = false;

    public FeatheredSerpentEntity(EntityType<? extends FeatheredSerpentEntity> type, Level level) {
        super(type, level);
        this.f_21364_ = 10;
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22280_, (double)0.3f).m_22268_(Attributes.f_22278_, 0.5).m_22265_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new SerpentAttackGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new IElementalSpirit.FollowGreaterSpiritGoal(this, 1.0, SylphideEntity.class));
        this.f_21345_.m_25352_(3, (Goal)new FlyingFollowOwnerGoal(this, 0.7, 10.0f, 4.0f, true, false));
        this.f_21345_.m_25352_(7, (Goal)new FLyingTamableEntity.WalkGoal(this, this));
        this.f_21345_.m_25352_(8, (Goal)new TensuraTamableEntity.FlyingWanderAroundPosGoal(this, this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new TensuraTamableEntity.TensuraOwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TensuraTamableEntity.TensuraOwnerHurtTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new TensuraTamableEntity.TensuraHurtByTargetGoal(this, SylphideEntity.class).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((FeatheredSerpentEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MISC_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(SUMMONING_TICK, (Object)-1);
        this.f_19804_.m_135372_(SUMMONER_UUID, Optional.empty());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getSummonerUUID() != null) {
            compound.m_128362_("Summoner", this.getSummonerUUID());
        }
        compound.m_128405_("MiscAnimation", this.getMiscAnimation());
        compound.m_128405_("SummoningTick", this.getSummoningTick());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128403_("Summoner")) {
            this.setSummonerUUID(compound.m_128342_("Summoner"));
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)compound.m_128451_("MiscAnimation"));
        this.setSummoningTick(compound.m_128451_("SummoningTick"));
    }

    public int getMiscAnimation() {
        return (Integer)this.f_19804_.m_135370_(MISC_ANIMATION);
    }

    public void setMiscAnimation(int animation) {
        if (this.getMiscAnimation() != 0 && animation != 0) {
            return;
        }
        this.f_19804_.m_135381_(MISC_ANIMATION, (Object)animation);
    }

    @Override
    public int getSummoningTick() {
        return (Integer)this.f_19804_.m_135370_(SUMMONING_TICK);
    }

    @Override
    public void setSummoningTick(int tick) {
        this.f_19804_.m_135381_(SUMMONING_TICK, (Object)tick);
    }

    @Override
    @Nullable
    public UUID getSummonerUUID() {
        return ((Optional)this.f_19804_.m_135370_(SUMMONER_UUID)).orElse(null);
    }

    @Override
    public void setSummonerUUID(@Nullable UUID pUuid) {
        this.f_19804_.m_135381_(SUMMONER_UUID, Optional.ofNullable(pUuid));
    }

    @Nullable
    public LivingEntity m_21826_() {
        if (this.getSummonerUUID() != null) {
            return null;
        }
        return super.m_21826_();
    }

    @Override
    public boolean canSleep() {
        return !this.m_21525_();
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.m_21824_()) {
            SylphideEntity sylphide;
            FeatheredSerpentEntity serpent;
            Entity entity = pSource.m_7639_();
            if (entity instanceof FeatheredSerpentEntity && !(serpent = (FeatheredSerpentEntity)entity).m_21824_()) {
                return false;
            }
            entity = pSource.m_7639_();
            if (entity instanceof SylphideEntity && !(sylphide = (SylphideEntity)entity).m_21824_()) {
                return false;
            }
        }
        return super.m_6469_(pSource, pAmount *= this.getPhysicalAttackInput(pSource));
    }

    @Override
    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (this.getSummonerUUID() != null) {
            if (entity instanceof IElementalSpirit) {
                IElementalSpirit spirit = (IElementalSpirit)entity;
                return Objects.equals(spirit.getSummonerUUID(), this.getSummonerUUID());
            }
            return Objects.equals(entity.m_20148_(), this.getSummonerUUID());
        }
        if (entity instanceof FeatheredSerpentEntity) {
            FeatheredSerpentEntity serpent = (FeatheredSerpentEntity)entity;
            return serpent.m_21824_() == this.m_21824_();
        }
        if (entity instanceof SylphideEntity) {
            SylphideEntity sylphide = (SylphideEntity)entity;
            return sylphide.m_21824_() == this.m_21824_();
        }
        return false;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (this.m_7307_((Entity)pTarget)) {
            return false;
        }
        return super.m_6779_(pTarget);
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public boolean m_5545_(LevelAccessor pLevel, MobSpawnType pSpawnReason) {
        return SpawnRateConfig.rollSpawn((Integer)SpawnRateConfig.INSTANCE.featheredSerpentSpawnRate.get(), this.m_217043_(), pSpawnReason);
    }

    @Override
    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pOtherParent) {
        return null;
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        EntityDimensions entitydimensions = super.m_6972_(pPose);
        if (this.m_5803_()) {
            return entitydimensions.m_20390_(1.5f, 0.5f);
        }
        if (this.isInFlyingPose()) {
            return entitydimensions.m_20390_(1.0f, 0.5f);
        }
        return entitydimensions;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.flyingPose != this.isInFlyingPose()) {
            this.flyingPose = this.isInFlyingPose();
            this.m_6210_();
        }
        if (this.getMiscAnimation() != 0) {
            ++this.miscAnimationTicks;
            if (!this.m_6084_()) {
                return;
            }
            if (this.getMiscAnimation() == 1 && this.miscAnimationTicks == 30) {
                target = this.m_5448_();
                if (target != null && target.m_20270_((Entity)this) <= 15.0f) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                    this.wingAttack(target.m_146892_());
                } else {
                    this.wingAttack(this.m_146892_().m_82549_(this.m_20154_().m_82490_(15.0)));
                }
            } else if (this.getMiscAnimation() == 2 && this.miscAnimationTicks == 5) {
                target = this.m_5448_();
                if (target != null) {
                    this.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                }
                this.windSphereAttack();
                this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else if (this.getMiscAnimation() == 3 && this.miscAnimationTicks == 10) {
                this.tailSwing();
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get(), 2.0);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)this, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get(), 3.0);
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.NEUTRAL, 1.5f, 1.0f);
            }
            if (this.miscAnimationTicks >= this.getAnimationTick(this.getMiscAnimation())) {
                this.setMiscAnimation(0);
                this.miscAnimationTicks = 0;
            }
        }
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.summoningTicking(this);
        LivingEntity livingentity = this.m_5448_();
        if (livingentity != null && livingentity.m_6084_() && this.m_20280_((Entity)livingentity) > 3.0) {
            this.setFlying(true);
        }
    }

    private int getAnimationTick(int miscAnimation) {
        return switch (miscAnimation) {
            default -> 20;
            case 1 -> 50;
            case 3 -> 32;
        };
    }

    public void wingAttack(Vec3 targetPos) {
        Level level = this.m_9236_();
        if (level.m_5776_()) {
            return;
        }
        Vec3 source = this.m_146892_();
        Vec3 sourceToTarget = targetPos.m_82546_(source);
        Vec3 normalizes = sourceToTarget.m_82541_();
        level.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
        for (int particleIndex = 1; particleIndex < Mth.m_14107_((double)sourceToTarget.m_82553_()) + 1; ++particleIndex) {
            Vec3 particlePos = source.m_82549_(normalizes.m_82490_((double)particleIndex));
            TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, level, particlePos, (ParticleOptions)TensuraParticles.GUST.get(), 5.0);
            TensuraParticleHelper.addServerParticlesAroundPos(this.f_19796_, level, particlePos, (ParticleOptions)TensuraParticles.SMALL_GUST.get(), 4.0);
            AABB aabb = new AABB(new BlockPos(particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_)).m_82400_(4.0);
            List list = level.m_6443_(Entity.class, aabb, living -> !living.m_7306_((Entity)this));
            if (list.isEmpty()) continue;
            float multiplier = this.hasWindManipulation() ? 1.0f : 0.5f;
            DamageSource damagesource = multiplier == 1.0f ? TensuraDamageSources.elementalAttack("tensura.wind_attack", (Entity)this, 100.0, new TensuraSkillInstance((ManasSkill)ExtraSkills.WIND_MANIPULATION.get()), true) : TensuraDamageSources.elementalAttack("tensura.wind_attack", (Entity)this, true);
            for (Entity target : list) {
                if (target instanceof LivingEntity) {
                    target.m_6469_(damagesource, (float)this.m_21133_(Attributes.f_22281_) * multiplier);
                }
                level.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 1.0f);
                SkillHelper.pushBackFromPos(this.m_20183_(), target, 3.0f);
            }
        }
    }

    public void windSphereAttack() {
        WindSphereProjectile windSphere = new WindSphereProjectile(this.f_19853_, (LivingEntity)this);
        windSphere.setSkill(SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.WIND_MANIPULATION.get()));
        float radius = 2.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        windSphere.m_7678_(this.m_20185_() + extraX, this.m_20188_() - 0.5, this.m_20189_() + extraZ, this.m_146908_(), this.m_146909_());
        windSphere.setDamage((float)(this.m_21133_(Attributes.f_22281_) * 0.75));
        windSphere.m_20242_(true);
        windSphere.setKnockForce(3.0f);
        windSphere.setBurnTicks(-1);
        windSphere.setSpiritAttack(true);
        windSphere.shootFromRot(this.m_20154_());
        this.f_19853_.m_7967_((Entity)windSphere);
    }

    public void tailSwing() {
        AABB aabb = this.m_20191_().m_82400_(5.0);
        List livingEntityList = this.f_19853_.m_6443_(LivingEntity.class, aabb, entity -> !entity.m_7307_((Entity)this) && entity != this.m_21826_() && entity != this && (!(entity instanceof FeatheredSerpentEntity) || entity == this.m_5448_()));
        if (livingEntityList.isEmpty()) {
            return;
        }
        double damageMultiplier = this.hasWindManipulation() ? 1.5 : 1.0;
        int level = this.hasWindManipulation() ? 1 : 0;
        TensuraDamageSource damageSource = DamageSourceHelper.addSkillAndCost(DamageSource.m_19370_((LivingEntity)this).m_19389_(), 20.0, SkillUtils.getSkillOrNull((Entity)this, (ManasSkill)ExtraSkills.WIND_MANIPULATION.get()));
        for (LivingEntity target : livingEntityList) {
            if (target.m_6469_((DamageSource)damageSource, (float)(this.m_21133_(Attributes.f_22281_) * damageMultiplier))) {
                target.m_147207_(new MobEffectInstance((MobEffect)TensuraMobEffects.PARALYSIS.get(), 100, level, false, false, false), (Entity)this);
                TensuraParticleHelper.addServerParticlesAroundSelf((Entity)target, (ParticleOptions)TensuraParticles.YELLOW_LIGHTNING_SPARK.get(), 1.0);
            }
            SkillHelper.knockBack((LivingEntity)this, target, 2.0f);
        }
    }

    public boolean hasWindManipulation() {
        return SkillAPI.getSkillsFrom((Entity)this).getSkill((ManasSkill)ExtraSkills.WIND_MANIPULATION.get()).isPresent();
    }

    @Override
    public void mountAbility(Player rider) {
        if (this.getMiscAnimation() == 1) {
            return;
        }
        if (this.getMiscAnimation() == 3) {
            return;
        }
        this.setMiscAnimation(1);
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(TensuraTags.Items.SPIRIT_FOOD);
    }

    public boolean isTamingFood(ItemStack pStack) {
        return pStack.m_150930_((Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get());
    }

    @Override
    public MagicElemental getElemental() {
        return MagicElemental.WIND;
    }

    @Override
    public SpiritualMagic.SpiritLevel getSpiritLevel() {
        return SpiritualMagic.SpiritLevel.MEDIUM;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() instanceof HealingPotionItem) {
            return super.m_6071_(player, hand);
        }
        InteractionResult eating = this.handleEating(player, hand, itemstack);
        if (eating.m_19077_()) {
            return eating;
        }
        if (this.f_19853_.f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || this.isTamingFood(itemstack);
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player)) {
                if (player.m_36341_()) {
                    this.commanding(player);
                } else if (!this.convertElementalCore((LivingEntity)this, player, hand, (Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get()) && player.m_146895_() == null) {
                    this.m_21839_(false);
                    this.setWandering(false);
                    player.m_7998_((Entity)this, false);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
        } else if (this.isTamingFood(itemstack)) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(10) == 7 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.f_19853_.m_7605_((Entity)this, (byte)7);
            } else {
                if (this.f_19796_.m_188503_(20) == 0) {
                    this.m_6710_((LivingEntity)player);
                }
                this.f_19853_.m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult handleEating(Player player, InteractionHand hand, ItemStack itemstack) {
        if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
            if (!player.m_7500_()) {
                itemstack.m_41774_(1);
            }
            this.m_8035_();
            this.m_9236_().m_6269_(null, (Entity)this, (SoundEvent)TensuraSoundEvents.EATING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_8035_() {
        super.m_8035_();
        this.m_5634_(3.0f);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        if (this.getSummoningTick() >= 0) {
            this.m_5907_();
        } else {
            super.m_6668_(pDamageSource);
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if ((double)this.f_19796_.m_188501_() > 0.1) {
            return;
        }
        this.m_19998_((ItemLike)TensuraMobDropItems.ELEMENTAL_ESSENCE.get());
    }

    public boolean m_20068_() {
        if (super.m_20068_()) {
            return true;
        }
        return this.getControllingPassenger() != null && !this.m_20096_();
    }

    public boolean m_6146_() {
        return true;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        for (Entity passenger : this.m_20197_()) {
            Player player;
            if (!(passenger instanceof Player) || !(player = (Player)passenger).equals((Object)this.m_21826_())) continue;
            return player;
        }
        return null;
    }

    public double m_6048_() {
        double old = super.m_6048_();
        if (this.isInFlyingPose()) {
            return old + 0.5;
        }
        return old;
    }

    public void m_7332_(Entity passenger) {
        if (!this.m_20363_(passenger)) {
            return;
        }
        passenger.m_183634_();
        float radius = -0.25f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double yOffset = this.m_20186_() - 0.5 + this.m_6048_() + passenger.m_6049_();
        passenger.m_6034_(this.m_20185_() + extraX, yOffset, this.m_20189_() + extraZ);
    }

    @Override
    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6084_()) {
            LivingEntity controller = this.getControllingPassenger();
            if (this.m_20160_() && controller != null) {
                this.m_146922_(controller.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(controller.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float f = controller.f_20900_ * 0.5f;
                float f1 = controller.f_20902_;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                this.f_20887_ = this.m_6113_() * 0.5f;
                if (this.m_6109_()) {
                    float speed = (float)this.m_21133_(Attributes.f_22279_) / 2.0f;
                    if (controller.m_20142_()) {
                        speed = (float)((double)speed * 1.5);
                    }
                    this.m_7910_(speed);
                    if (controller.f_20899_) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
                    } else if (TensuraKeybinds.MOUNT_DESCENDING.m_90857_()) {
                        this.descending((Entity)this, controller);
                    }
                    super.m_7023_(new Vec3((double)f, pTravelVector.f_82480_, (double)f1));
                } else if (controller instanceof Player) {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(pTravelVector);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TensuraSoundEvents.BIRD_FLAP.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_11895_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    public boolean isInFlyingPose() {
        if (this.m_21525_()) {
            return false;
        }
        if (this.m_20096_()) {
            return false;
        }
        if (!this.m_9236_().m_8055_(this.m_20097_().m_7495_()).m_60767_().m_76336_()) {
            return false;
        }
        return !this.m_21825_() && !this.m_21827_();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.sleep", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else if (this.isInFlyingPose()) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.idle_fly", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            }
        } else if (event.isMoving() && !this.m_21825_() && !this.m_21525_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState playOncePredicate(AnimationEvent<E> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationState.Stopped)) {
            event.getController().markNeedsReload();
            if (this.getMiscAnimation() == 1) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.wing_attack", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 2) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.sphere_shoot", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            } else if (this.getMiscAnimation() == 3) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.tail_swing", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            }
        }
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState posePredicate(AnimationEvent<E> event) {
        if (this.m_21825_() && !this.m_5803_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.sit", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.feathered_serpent.sphere_loop", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "playOnceController", 0.0f, this::playOncePredicate));
        data.addAnimationController(new AnimationController((IAnimatable)this, "posePredicate", 0.0f, this::posePredicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class SerpentAttackGoal
    extends DynamicMeleeAttackGoal {
        public final FeatheredSerpentEntity serpent;

        public SerpentAttackGoal(FeatheredSerpentEntity serpent) {
            super((PathfinderMob)serpent, List.of((self, target, goal) -> 1.0f));
            this.serpent = serpent;
        }

        @Override
        public boolean m_8036_() {
            if (this.serpent.m_21827_()) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        protected List<DynamicMeleeAttackAction> getActions() {
            ArrayList<DynamicMeleeAttackAction> list = new ArrayList<DynamicMeleeAttackAction>();
            list.add((self, target, goal) -> {
                float speed = 1.5f;
                double distanceSqr = self.m_20280_((Entity)target);
                if (distanceSqr > 400.0) {
                    speed = 2.0f;
                } else {
                    this.checkAndPerformAttack(distanceSqr);
                    self.m_21391_((Entity)target, 70.0f, 70.0f);
                }
                return speed;
            });
            return list;
        }

        protected void checkAndPerformAttack(double pDistToEnemySqr) {
            if (this.serpent.getMiscAnimation() == 0) {
                double attackRange;
                int randomAttack = this.randomAttack(pDistToEnemySqr);
                switch (randomAttack) {
                    case 1: {
                        double d = 100.0;
                        break;
                    }
                    case 2: {
                        double d = 900.0;
                        break;
                    }
                    default: {
                        double d = attackRange = 25.0;
                    }
                }
                if (pDistToEnemySqr <= attackRange) {
                    this.serpent.setMiscAnimation(randomAttack);
                    if (randomAttack == 1) {
                        this.serpent.m_21573_().m_26573_();
                    }
                }
            }
        }

        protected int randomAttack(double distance) {
            if (distance >= 100.0) {
                return 2;
            }
            return this.serpent.f_19796_.m_188503_(5) == 1 || distance >= 25.0 ? 1 : 3;
        }
    }
}

