/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.enchantment.IInherentEngrave;
import com.github.manasmods.tensura.entity.human.CloneEntity;
import com.github.manasmods.tensura.item.TensuraArmourMaterials;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class TsukumogamiEnchantment
extends EngravingEnchantment
implements IInherentEngrave {
    public TsukumogamiEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BREAKABLE, EquipmentSlot.values());
    }

    @Override
    public ChatFormatting getNameFormatting() {
        return ChatFormatting.RED;
    }

    public static void applyTsukumogami(ItemStack toStack, LivingEntity entity) {
        TieredItem item;
        Item item2 = toStack.m_41720_();
        boolean canApply = item2 instanceof TieredItem && (item = (TieredItem)item2).m_43314_().equals(TensuraToolTiers.HIHIIROKANE);
        boolean bl = canApply = canApply || (item2 = toStack.m_41720_()) instanceof ArmorItem && (item = (ArmorItem)item2).m_40401_().equals((Object)TensuraArmourMaterials.HIHIIROKANE);
        if (!canApply) {
            return;
        }
        if (toStack.getEnchantmentLevel((Enchantment)TensuraEnchantments.TSUKUMOGAMI.get()) >= 1) {
            return;
        }
        EngravingEnchantment.engrave(toStack, (Enchantment)TensuraEnchantments.TSUKUMOGAMI.get(), 1);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        CompoundTag tag = toStack.m_41784_();
        tag.m_128362_("OwnerUUID", player.m_20148_());
    }

    public static void updateOwnerHolding(ItemStack stack, @Nullable LivingEntity entity) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128403_("OwnerUUID")) {
            if (stack.getEnchantmentLevel((Enchantment)TensuraEnchantments.TSUKUMOGAMI.get()) < 1) {
                return;
            }
            if (entity == null) {
                return;
            }
            CompoundTag newTag = stack.m_41784_();
            newTag.m_128362_("OwnerUUID", entity.m_20148_());
        }
        if (entity == null) {
            tag.m_128379_("Activated", false);
        } else if (tag != null) {
            boolean correctOwner;
            boolean bl = correctOwner = Objects.equals(tag.m_128342_("OwnerUUID"), entity.m_20148_()) || entity instanceof CloneEntity;
            if (tag.m_128471_("Activated") != correctOwner) {
                entity.m_5496_(SoundEvents.f_11739_, 0.3f, 1.0f);
            }
            tag.m_128379_("Activated", correctOwner);
        }
    }
}

