/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.util.damage.TensuraDamageSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class SturdyEnchantment
extends EngravingEnchantment {
    public SturdyEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.BREAKABLE, EquipmentSlot.MAINHAND);
    }

    public float getDamageBonus(int level, MobType mobType, ItemStack enchantedItem) {
        float damage = 10.0f * (float)level;
        Item item = enchantedItem.m_41720_();
        if (item instanceof SwordItem) {
            SwordItem sword = (SwordItem)item;
            damage = sword.m_43299_() * (float)level;
        }
        if ((item = enchantedItem.m_41720_()) instanceof DiggerItem) {
            DiggerItem digger = (DiggerItem)item;
            damage = digger.m_41008_() * (float)level;
        }
        return damage * 0.3f;
    }

    public int m_7205_(int pLevel, DamageSource pSource) {
        TensuraDamageSource source;
        if (pSource.m_19378_() || pSource.m_238340_() || pSource.m_19379_()) {
            return 0;
        }
        if (pSource instanceof TensuraDamageSource && (source = (TensuraDamageSource)pSource).getIgnoreBarrier() > 0.0f) {
            return 0;
        }
        return pLevel * 2;
    }
}

