/*
 * Decompiled with CFR 0.152.
 */
package com.github.manasmods.tensura.enchantment;

import com.github.manasmods.tensura.config.TensuraConfig;
import com.github.manasmods.tensura.data.pack.Slotting.SlottingElementCombination;
import com.github.manasmods.tensura.data.pack.TensuraData;
import com.github.manasmods.tensura.enchantment.EngravingEnchantment;
import com.github.manasmods.tensura.entity.magic.TensuraProjectile;
import com.github.manasmods.tensura.item.TensuraToolTiers;
import com.github.manasmods.tensura.item.custom.ElementCoreItem;
import com.github.manasmods.tensura.item.custom.KunaiItem;
import com.github.manasmods.tensura.registry.enchantment.TensuraEnchantments;
import com.github.manasmods.tensura.registry.items.TensuraMaterialItems;
import com.github.manasmods.tensura.util.TensuraAdvancementsHelper;
import com.github.manasmods.tensura.util.damage.DamageSourceHelper;
import com.github.manasmods.tensura.util.damage.TensuraEntityDamageSource;
import com.mojang.math.Vector3f;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.registries.ForgeRegistries;

public class SlottingEnchantment
extends EngravingEnchantment {
    public SlottingEnchantment() {
        super(Enchantment.Rarity.VERY_RARE, EnchantmentCategory.WEAPON, EquipmentSlot.MAINHAND);
    }

    public int m_6586_() {
        return (Integer)TensuraConfig.INSTANCE.enchantmentsConfig.maxSlotting.get();
    }

    @Override
    public void doAdditionalAttack(ItemStack stack, LivingEntity attacker, Entity target, int pLevel, float originalDamage) {
        float f;
        if (target.f_19802_ >= 60) {
            return;
        }
        int cores = SlottingEnchantment.getContentWeight(stack);
        if (cores <= 0) {
            return;
        }
        float damage = DamageSourceHelper.getMainWeaponDamage(attacker, target);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            f = player.m_36403_(0.5f);
        } else {
            f = 1.0f;
        }
        float f2 = f;
        damage *= 0.2f + f2 * f2 * 0.8f;
        int earth = SlottingEnchantment.getCores(stack, (Item)TensuraMaterialItems.ELEMENT_CORE_EARTH.get());
        int fire = SlottingEnchantment.getCores(stack, (Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get());
        int space = SlottingEnchantment.getCores(stack, (Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get());
        int water = SlottingEnchantment.getCores(stack, (Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get());
        int wind = SlottingEnchantment.getCores(stack, (Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get());
        SlottingEnchantment.coreExtraDamage(target, attacker, earth, fire, space, water, wind, damage);
        SlottingEnchantment.damageEachCore(attacker, stack, cores == 1 ? 5 : 4 - cores);
    }

    private static void ignoreInvulnerableHurt(Entity pTarget, LivingEntity pAttacker, String damageType, float pAmount) {
        if (pAmount <= 0.0f) {
            return;
        }
        pTarget.f_19802_ = 0;
        DamageSource magicDamage = new TensuraEntityDamageSource(damageType, (Entity)pAttacker).setSlotting().m_19389_();
        DamageSourceHelper.dealSplitElementalDamage(pTarget, magicDamage, 0.9f, pAmount);
    }

    private static void coreExtraDamage(Entity pTarget, LivingEntity pAttacker, int earth, int fire, int space, int water, int wind, double baseDamage) {
        boolean hasCombination = false;
        double[] coreDamage = new double[]{baseDamage, baseDamage, baseDamage, baseDamage, baseDamage};
        for (SlottingElementCombination combination : TensuraData.getElementCombination()) {
            if (combination.getEarthCores() != earth || combination.getFireCores() != fire || combination.getSpaceCores() != space || combination.getWaterCores() != water || combination.getWindCores() != wind) continue;
            coreDamage[0] = coreDamage[0] * combination.getEarthMultiplier();
            coreDamage[1] = coreDamage[1] * combination.getFireMultiplier();
            coreDamage[2] = coreDamage[2] * combination.getSpaceMultiplier();
            coreDamage[3] = coreDamage[3] * combination.getWaterMultiplier();
            coreDamage[4] = coreDamage[4] * combination.getWindMultiplier();
            hasCombination = true;
            break;
        }
        if (!hasCombination) {
            return;
        }
        SlottingEnchantment.ignoreInvulnerableHurt(pTarget, pAttacker, "earth_attack", (float)coreDamage[0]);
        SlottingEnchantment.ignoreInvulnerableHurt(pTarget, pAttacker, "fire_attack", (float)coreDamage[1]);
        SlottingEnchantment.ignoreInvulnerableHurt(pTarget, pAttacker, "space_attack", (float)coreDamage[2]);
        SlottingEnchantment.ignoreInvulnerableHurt(pTarget, pAttacker, "water_attack", (float)coreDamage[3]);
        SlottingEnchantment.ignoreInvulnerableHurt(pTarget, pAttacker, "wind_attack", (float)coreDamage[4]);
    }

    private static void damageEachCore(LivingEntity pAttacker, ItemStack gear, int amount) {
        TieredItem tieredItem;
        Item item;
        if (amount <= 0) {
            return;
        }
        if (pAttacker instanceof Player) {
            Player player = (Player)pAttacker;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        if ((item = gear.m_41720_()) instanceof TieredItem && (tieredItem = (TieredItem)item).m_43314_().equals(TensuraToolTiers.HIHIIROKANE)) {
            return;
        }
        CompoundTag compoundtag = gear.m_41784_();
        if (!compoundtag.m_128441_("Cores")) {
            return;
        }
        ListTag newList = new ListTag();
        ListTag list = compoundtag.m_128437_("Cores", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.m_128728_(i);
            ItemStack elementCore = ItemStack.m_41712_((CompoundTag)itemTag);
            elementCore.m_41622_(amount, pAttacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            if (elementCore.m_41619_()) continue;
            elementCore.m_41739_(itemTag);
            newList.add((Object)itemTag);
        }
        compoundtag.m_128365_("Cores", (Tag)newList);
    }

    public static boolean onUse(LivingEntity entity, InteractionHand pHand) {
        if (entity.m_6144_()) {
            return false;
        }
        ItemStack pStack = entity.m_21120_(pHand);
        if (SlottingEnchantment.getContentWeight(pStack) <= 0) {
            return false;
        }
        boolean hasCombination = false;
        for (SlottingElementCombination elementCombination : TensuraData.getElementCombination()) {
            if (elementCombination.getEarthCores() != SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_EARTH.get()) || elementCombination.getFireCores() != SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get()) || elementCombination.getSpaceCores() != SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get()) || elementCombination.getWaterCores() != SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get()) || elementCombination.getWindCores() != SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get())) continue;
            hasCombination = true;
            break;
        }
        if (hasCombination) {
            entity.m_6672_(pHand);
        }
        return hasCombination;
    }

    public static boolean onRelease(ItemStack pStack, LivingEntity pLiving, int pTimeLeft) {
        if (pLiving.m_6144_()) {
            return false;
        }
        int cores = SlottingEnchantment.getContentWeight(pStack);
        if (cores <= 0) {
            return false;
        }
        int useTicks = pStack.m_41779_() - pTimeLeft;
        if (useTicks < 10) {
            return false;
        }
        if (cores >= 3 && pLiving instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pLiving;
            TensuraAdvancementsHelper.grant(serverPlayer, TensuraAdvancementsHelper.Advancements.INFINITY_CORES);
        }
        int earth = SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_EARTH.get());
        int fire = SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_FIRE.get());
        int space = SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_SPACE.get());
        int water = SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_WATER.get());
        int wind = SlottingEnchantment.getCores(pStack, (Item)TensuraMaterialItems.ELEMENT_CORE_WIND.get());
        SlottingEnchantment.coreProjectileShoot(pStack, pLiving, earth, fire, space, water, wind);
        if (pLiving instanceof Player) {
            Player player = (Player)pLiving;
            player.m_36246_(Stats.f_12982_.m_12902_((Object)pStack.m_41720_()));
        }
        return true;
    }

    private static void coreProjectileShoot(ItemStack pStack, LivingEntity living, int earth, int fire, int space, int water, int wind) {
        for (SlottingElementCombination combination : TensuraData.getElementCombination()) {
            if (combination.getEarthCores() != earth || combination.getFireCores() != fire || combination.getSpaceCores() != space || combination.getWaterCores() != water || combination.getWindCores() != wind) continue;
            if (combination.isDud()) {
                if (living instanceof Player) {
                    Player player = (Player)living;
                    if (!player.m_150110_().f_35937_) {
                        SlottingEnchantment.damageEveryCore(living, pStack, 50);
                    }
                }
                living.f_19853_.m_5594_(null, living.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            Optional entityType = EntityType.m_20632_((String)combination.getProjectile().getEntity().toString());
            if (entityType.isPresent()) {
                Entity entity = ((EntityType)entityType.get()).m_20615_(living.m_9236_());
                if (!(entity instanceof Projectile)) break;
                Projectile projectile = (Projectile)entity;
                if (living instanceof Player) {
                    Player player = (Player)living;
                    if (!player.m_150110_().f_35937_) {
                        SlottingEnchantment.damageEveryCore(living, pStack, 12);
                    }
                }
                living.m_6674_(living.m_7655_());
                if (projectile instanceof TensuraProjectile) {
                    TensuraProjectile magicProjectile = (TensuraProjectile)projectile;
                    magicProjectile.m_5602_((Entity)living);
                    magicProjectile.setSpiritAttack(true);
                    float damage = combination.getProjectile().getDamage();
                    magicProjectile.setDamage(damage *= DamageSourceHelper.getWeaponDamage(living, null, living.m_7655_() == InteractionHand.OFF_HAND));
                    magicProjectile.setSpeed(combination.getProjectile().getSpeed());
                    magicProjectile.setKnockForce(combination.getProjectile().getKnockForce());
                    magicProjectile.setExplosionRadius(combination.getProjectile().getExplosionRadius());
                    magicProjectile.setBurnTicks(combination.getProjectile().getBurnTicks());
                    magicProjectile.m_20242_(combination.getProjectile().isNoGravity());
                    MobEffect mobEffect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(combination.getProjectile().getMagicEffect().getEffectID());
                    if (mobEffect != null) {
                        magicProjectile.setMobEffect(new MobEffectInstance(mobEffect, combination.getProjectile().getMagicEffect().getTicks(), combination.getProjectile().getMagicEffect().getLevel()));
                        magicProjectile.setEffectRange(combination.getProjectile().getMagicEffect().getRange());
                    }
                    magicProjectile.setPosAndShoot(living);
                } else {
                    Vector3f vector3f = new Vector3f(living.m_20252_(2.0f));
                    projectile.m_6686_((double)vector3f.m_122239_(), (double)vector3f.m_122260_(), (double)vector3f.m_122269_(), 2.2f, 0.0f);
                }
                living.m_9236_().m_7967_((Entity)projectile);
                living.f_19853_.m_5594_(null, living.m_20183_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            living.f_19853_.m_5594_(null, living.m_20183_(), SoundEvents.f_12315_, SoundSource.PLAYERS, 1.0f, 1.0f);
            break;
        }
    }

    private static void damageEveryCore(LivingEntity entity, ItemStack gear, int amount) {
        TieredItem tieredItem;
        Item item = gear.m_41720_();
        if (item instanceof TieredItem && (tieredItem = (TieredItem)item).m_43314_().equals(TensuraToolTiers.HIHIIROKANE)) {
            return;
        }
        CompoundTag compoundtag = gear.m_41784_();
        if (!compoundtag.m_128441_("Cores")) {
            return;
        }
        ListTag newList = new ListTag();
        ListTag listtag = compoundtag.m_128437_("Cores", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag itemTag = listtag.m_128728_(i);
            ItemStack elementCore = ItemStack.m_41712_((CompoundTag)itemTag);
            elementCore.m_41622_(amount, entity, living -> living.m_21190_(entity.m_7655_()));
            if (elementCore.m_41619_()) continue;
            elementCore.m_41739_(itemTag);
            newList.add((Object)itemTag);
        }
        compoundtag.m_128365_("Cores", (Tag)newList);
    }

    public static int getElementalSlots(ItemStack stack) {
        if (stack.m_41720_() instanceof KunaiItem) {
            return 0;
        }
        return stack.getEnchantmentLevel((Enchantment)TensuraEnchantments.SLOTTING.get());
    }

    private static Stream<ItemStack> getContents(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41783_();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Cores", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_);
    }

    private static int getCores(ItemStack gear, Item core) {
        int coreNumber = 0;
        for (ItemStack cores : SlottingEnchantment.getContents(gear).toList()) {
            if (!cores.m_150930_(core)) continue;
            ++coreNumber;
        }
        return coreNumber;
    }

    public static int getContentWeight(ItemStack pStack) {
        return SlottingEnchantment.getContents(pStack).mapToInt(ItemStack::m_41613_).sum();
    }

    public static Optional<TooltipComponent> tooltipCore(ItemStack pStack) {
        if (SlottingEnchantment.getContentWeight(pStack) <= 0) {
            return Optional.empty();
        }
        NonNullList list = NonNullList.m_122779_();
        SlottingEnchantment.getContents(pStack).forEach(arg_0 -> list.add(arg_0));
        if (SlottingEnchantment.getContentWeight(pStack) >= SlottingEnchantment.getElementalSlots(pStack)) {
            return Optional.of(new BundleTooltip(list, 64));
        }
        return Optional.of(new BundleTooltip(list, SlottingEnchantment.getContentWeight(pStack)));
    }

    public static boolean putCoreOnTool(ItemStack pStack, ItemStack pOther, Slot pSlot, SlotAccess pAccess, ClickAction pAction, Player pPlayer) {
        if (pAction == ClickAction.SECONDARY && pSlot.m_150651_(pPlayer)) {
            if (pOther.m_41619_()) {
                SlottingEnchantment.removeCore(pStack).ifPresent(core -> {
                    SlottingEnchantment.playRemoveOneSound((Entity)pPlayer);
                    pAccess.m_142104_(core);
                });
                return true;
            }
            if (pOther.m_41720_() instanceof ElementCoreItem) {
                int i = SlottingEnchantment.add(pStack, pOther.m_41777_());
                if (i > 0) {
                    SlottingEnchantment.playInsertSound((Entity)pPlayer);
                    pOther.m_41774_(i);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean putToolUponCore(ItemStack pStack, Slot pSlot, ClickAction pAction, Player pPlayer) {
        if (pAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = pSlot.m_7993_();
        if (itemstack.m_41619_()) {
            SlottingEnchantment.removeCore(pStack).ifPresent(core -> {
                pSlot.m_5852_(core);
                pSlot.m_6654_();
                SlottingEnchantment.playRemoveOneSound((Entity)pPlayer);
            });
        } else if (itemstack.m_41720_().m_142095_() && itemstack.m_41720_() instanceof ElementCoreItem) {
            int i = SlottingEnchantment.getElementalSlots(pStack) - SlottingEnchantment.getContentWeight(pStack);
            int j = SlottingEnchantment.add(pStack, pSlot.m_150647_(itemstack.m_41613_(), i, pPlayer));
            if (j > 0) {
                SlottingEnchantment.playInsertSound((Entity)pPlayer);
            }
        }
        return true;
    }

    private static int add(ItemStack gear, ItemStack pInsertedStack) {
        if (!pInsertedStack.m_41619_() && pInsertedStack.m_41720_().m_142095_() && pInsertedStack.m_41720_() instanceof ElementCoreItem) {
            CompoundTag compoundtag = gear.m_41784_();
            if (!compoundtag.m_128441_("Cores")) {
                compoundtag.m_128365_("Cores", (Tag)new ListTag());
            }
            int i = SlottingEnchantment.getContentWeight(gear);
            int k = Math.min(pInsertedStack.m_41613_(), SlottingEnchantment.getElementalSlots(gear) - i);
            if (k == 0) {
                return 0;
            }
            ListTag listtag = compoundtag.m_128437_("Cores", 10);
            ItemStack stack = pInsertedStack.m_41777_();
            stack.m_41764_(k);
            CompoundTag tag = new CompoundTag();
            stack.m_41739_(tag);
            listtag.add(0, (Tag)tag);
            return k;
        }
        return 0;
    }

    private static Optional<ItemStack> removeCore(ItemStack pStack) {
        CompoundTag compoundtag = pStack.m_41784_();
        if (!compoundtag.m_128441_("Cores")) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.m_128437_("Cores", 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag tag = listtag.m_128728_(0);
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)tag).m_41777_();
        listtag.remove(0);
        if (listtag.isEmpty()) {
            pStack.m_41749_("Cores");
        } else {
            compoundtag.m_128365_("Cores", (Tag)listtag);
        }
        return Optional.of(itemstack);
    }

    private static void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private static void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_11859_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

